<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ReReminderPersona
 *
 * @ORM\Table(name="re_reminder_persona")
 * @ORM\Entity
 */
class ReReminderPersona
{
    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_persona_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $reReminderPersonaIx;

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_persona_db", type="string", length=2, nullable=false)
     */
    private $reReminderPersonaDb = 'WB';

    /**
     * @var integer
     *
     * @ORM\Column(name="re_reminder_persona_id", type="integer", nullable=false)
     */
    private $reReminderPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_sent_to_email", type="string", length=255, nullable=true)
     */
    private $reReminderSentToEmail;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_persona_id", type="string", length=36, nullable=false)
     */
    private $prPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_id", type="string", length=36, nullable=false)
     */
    private $reReminderId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var integer
     *
     * @ORM\Column(name="re_reminder_persona_trf_yn", type="integer", nullable=false)
     */
    private $reReminderPersonaTrfYn;


    public function __construct() {
        $this->reReminderPersonaId = 0;
        $this->reReminderPersonaTrfYn = 0;
        $this->reReminderPersonaDb = 'WB';
        $this->reReminderSentToEmail = '';
    }

    /**
     * Get reReminderPersonaIx
     *
     * @return string
     */
    public function getReReminderPersonaIx()
    {
        return $this->reReminderPersonaIx;
    }

    /**
     * Set reReminderPersonaDb
     *
     * @param string $reReminderPersonaDb
     *
     * @return ReReminderPersona
     */
    public function setReReminderPersonaDb($reReminderPersonaDb)
    {
        $this->reReminderPersonaDb = $reReminderPersonaDb;

        return $this;
    }

    /**
     * Get reReminderPersonaDb
     *
     * @return string
     */
    public function getReReminderPersonaDb()
    {
        return $this->reReminderPersonaDb;
    }

    /**
     * Set reReminderPersonaId
     *
     * @param integer $reReminderPersonaId
     *
     * @return ReReminderPersona
     */
    public function setReReminderPersonaId($reReminderPersonaId)
    {
        $this->reReminderPersonaId = $reReminderPersonaId;

        return $this;
    }

    /**
     * Get reReminderPersonaId
     *
     * @return integer
     */
    public function getReReminderPersonaId()
    {
        return $this->reReminderPersonaId;
    }

    /**
     * Set reReminderSentToEmail
     *
     * @param string $reReminderSentToEmail
     *
     * @return ReReminderPersona
     */
    public function setReReminderSentToEmail($reReminderSentToEmail)
    {
        $this->reReminderSentToEmail = $reReminderSentToEmail;

        return $this;
    }

    /**
     * Get reReminderSentToEmail
     *
     * @return string
     */
    public function getReReminderSentToEmail()
    {
        return $this->reReminderSentToEmail;
    }

    /**
     * Set prPersonaId
     *
     * @param string $prPersonaId
     *
     * @return ReReminderPersona
     */
    public function setPrPersonaId($prPersonaId)
    {
        $this->prPersonaId = $prPersonaId;

        return $this;
    }

    /**
     * Get prPersonaId
     *
     * @return string
     */
    public function getPrPersonaId()
    {
        return $this->prPersonaId;
    }

    /**
     * Set reReminderId
     *
     * @param string $reReminderId
     *
     * @return ReReminderPersona
     */
    public function setReReminderId($reReminderId)
    {
        $this->reReminderId = $reReminderId;

        return $this;
    }

    /**
     * Get reReminderId
     *
     * @return string
     */
    public function getReReminderId()
    {
        return $this->reReminderId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ReReminderPersona
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set reReminderPersonaTrfYn
     *
     * @param boolean $reReminderPersonaTrfYn
     *
     * @return ReReminderPersona
     */
    public function setReReminderPersonaTrfYn($reReminderPersonaTrfYn)
    {
        $this->reReminderPersonaTrfYn = $reReminderPersonaTrfYn;

        return $this;
    }

    /**
     * Get reReminderPersonaTrfYn
     *
     * @return boolean
     */
    public function getReReminderPersonaTrfYn()
    {
        return $this->reReminderPersonaTrfYn;
    }
}
