<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ReReminderStatus
 *
 * @ORM\Table(name="re_reminder_status")
 * @ORM\Entity
 */
class ReReminderStatus
{
    /**
     * @var integer
     *
     * @ORM\Column(name="re_reminder_status_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $reReminderStatusId;

    /**
     * @var string
     *
     * @ORM\Column(name="re_reminder_status_desc", type="text", length=65535, nullable=false)
     */
    private $reReminderStatusDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="re_reminder_status_trf_yn", type="boolean", nullable=false)
     */
    private $reReminderStatusTrfYn = '0';



    /**
     * Get reReminderStatusId
     *
     * @return integer
     */
    public function getReReminderStatusId()
    {
        return $this->reReminderStatusId;
    }

    /**
     * Set reReminderStatusDesc
     *
     * @param string $reReminderStatusDesc
     *
     * @return ReReminderStatus
     */
    public function setReReminderStatusDesc($reReminderStatusDesc)
    {
        $this->reReminderStatusDesc = $reReminderStatusDesc;

        return $this;
    }

    /**
     * Get reReminderStatusDesc
     *
     * @return string
     */
    public function getReReminderStatusDesc()
    {
        return $this->reReminderStatusDesc;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return ReReminderStatus
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set reReminderStatusTrfYn
     *
     * @param boolean $reReminderStatusTrfYn
     *
     * @return ReReminderStatus
     */
    public function setReReminderStatusTrfYn($reReminderStatusTrfYn)
    {
        $this->reReminderStatusTrfYn = $reReminderStatusTrfYn;

        return $this;
    }

    /**
     * Get reReminderStatusTrfYn
     *
     * @return boolean
     */
    public function getReReminderStatusTrfYn()
    {
        return $this->reReminderStatusTrfYn;
    }
}
