<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfArchive
 *
 * @ORM\Table(name="rf_archive", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"})
 * @ORM\Entity
 */
class RfArchive
{
    /**
     * @var integer
     *
     * @ORM\Column(name="rf_archive_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $rfArchiveId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_archive_name", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $rfArchiveName;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_archive_note", type="text", length=65535, nullable=true)
     */
    private $rfArchiveNote;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="ad_create_date", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $adCreateDate;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_date_tz", type="string", length=40, nullable=false)
     */
    private $adCreateDateTz;

    /**
     * @var string
     *
     * @ORM\Column(name="ad_create_user_name", type="string", length=36, nullable=true)
     */
    private $adCreateUserName;



    /**
     * Get rfArchiveId
     *
     * @return integer
     */
    public function getRfArchiveId()
    {
        return $this->rfArchiveId;
    }

    /**
     * Set rfArchiveName
     *
     * @param string $rfArchiveName
     *
     * @return RfArchive
     */
    public function setRfArchiveName($rfArchiveName)
    {
        $this->rfArchiveName = $rfArchiveName;

        return $this;
    }

    /**
     * Get rfArchiveName
     *
     * @return string
     */
    public function getRfArchiveName()
    {
        return $this->rfArchiveName;
    }

    /**
     * Set rfArchiveNote
     *
     * @param string $rfArchiveNote
     *
     * @return RfArchive
     */
    public function setRfArchiveNote($rfArchiveNote)
    {
        $this->rfArchiveNote = $rfArchiveNote;

        return $this;
    }

    /**
     * Get rfArchiveNote
     *
     * @return string
     */
    public function getRfArchiveNote()
    {
        return $this->rfArchiveNote;
    }

    /**
     * Set adCreateDate
     *
     * @param \DateTime $adCreateDate
     *
     * @return RfArchive
     */
    public function setAdCreateDate($adCreateDate)
    {
        $this->adCreateDate = $adCreateDate;

        return $this;
    }

    /**
     * Get adCreateDate
     *
     * @return \DateTime
     */
    public function getAdCreateDate()
    {
        return $this->adCreateDate;
    }

    /**
     * Set adCreateDateTz
     *
     * @param string $adCreateDateTz
     *
     * @return RfArchive
     */
    public function setAdCreateDateTz($adCreateDateTz)
    {
        $this->adCreateDateTz = $adCreateDateTz;

        return $this;
    }

    /**
     * Get adCreateDateTz
     *
     * @return string
     */
    public function getAdCreateDateTz()
    {
        return $this->adCreateDateTz;
    }

    /**
     * Set adCreateUserName
     *
     * @param string $adCreateUserName
     *
     * @return RfArchive
     */
    public function setAdCreateUserName($adCreateUserName)
    {
        $this->adCreateUserName = $adCreateUserName;

        return $this;
    }

    /**
     * Get adCreateUserName
     *
     * @return string
     */
    public function getAdCreateUserName()
    {
        return $this->adCreateUserName;
    }
}
