<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfAuditModule
 *
 * @ORM\Table(name="rf_audit_module", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_audit_module_trf_yn", columns={"rf_audit_module_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfAuditModule
{
    /**
     * @var integer
     *
     * @ORM\Column(name="rf_audit_module_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $rfAuditModuleId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_audit_module_name", type="string", length=100, nullable=false)
     */
    private $rfAuditModuleName;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_audit_module_description_internal", type="string", length=200, nullable=false)
     */
    private $rfAuditModuleDescriptionInternal;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_audit_module_description_external", type="string", length=200, nullable=false)
     */
    private $rfAuditModuleDescriptionExternal;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_audit_module_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfAuditModuleTrfYn;



    /**
     * Get rfAuditModuleId
     *
     * @return integer
     */
    public function getRfAuditModuleId()
    {
        return $this->rfAuditModuleId;
    }

    /**
     * Set rfAuditModuleName
     *
     * @param string $rfAuditModuleName
     *
     * @return RfAuditModule
     */
    public function setRfAuditModuleName($rfAuditModuleName)
    {
        $this->rfAuditModuleName = $rfAuditModuleName;

        return $this;
    }

    /**
     * Get rfAuditModuleName
     *
     * @return string
     */
    public function getRfAuditModuleName()
    {
        return $this->rfAuditModuleName;
    }

    /**
     * Set rfAuditModuleDescriptionInternal
     *
     * @param string $rfAuditModuleDescriptionInternal
     *
     * @return RfAuditModule
     */
    public function setRfAuditModuleDescriptionInternal($rfAuditModuleDescriptionInternal)
    {
        $this->rfAuditModuleDescriptionInternal = $rfAuditModuleDescriptionInternal;

        return $this;
    }

    /**
     * Get rfAuditModuleDescriptionInternal
     *
     * @return string
     */
    public function getRfAuditModuleDescriptionInternal()
    {
        return $this->rfAuditModuleDescriptionInternal;
    }

    /**
     * Set rfAuditModuleDescriptionExternal
     *
     * @param string $rfAuditModuleDescriptionExternal
     *
     * @return RfAuditModule
     */
    public function setRfAuditModuleDescriptionExternal($rfAuditModuleDescriptionExternal)
    {
        $this->rfAuditModuleDescriptionExternal = $rfAuditModuleDescriptionExternal;

        return $this;
    }

    /**
     * Get rfAuditModuleDescriptionExternal
     *
     * @return string
     */
    public function getRfAuditModuleDescriptionExternal()
    {
        return $this->rfAuditModuleDescriptionExternal;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfAuditModule
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfAuditModuleTrfYn
     *
     * @param boolean $rfAuditModuleTrfYn
     *
     * @return RfAuditModule
     */
    public function setRfAuditModuleTrfYn($rfAuditModuleTrfYn)
    {
        $this->rfAuditModuleTrfYn = $rfAuditModuleTrfYn;

        return $this;
    }

    /**
     * Get rfAuditModuleTrfYn
     *
     * @return boolean
     */
    public function getRfAuditModuleTrfYn()
    {
        return $this->rfAuditModuleTrfYn;
    }
}
