<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfBank
 *
 * @ORM\Table(name="rf_bank", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_bank_trf_yn", columns={"rf_bank_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfBank
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfBankIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rfBankDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_bank_id", type="integer", nullable=false)
     */
    private $rfBankId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_abbrev", type="string", length=5, nullable=true)
     */
    private $rfBankAbbrev;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_acc_name", type="string", length=70, nullable=true)
     */
    private $rfBankAccName;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_acc_no", type="string", length=50, nullable=true)
     */
    private $rfBankAccNo;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_detail_1", type="string", length=100, nullable=true)
     */
    private $rfBankDetail1;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_detail_2", type="string", length=100, nullable=true)
     */
    private $rfBankDetail2;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_detail_3", type="string", length=100, nullable=true)
     */
    private $rfBankDetail3;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_bank_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfBankInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_name", type="string", length=70, nullable=true)
     */
    private $rfBankName;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_bank_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfBankSysCode;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_bank_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfBankInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_bank_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfBankTrfYn;



    /**
     * Get rfBankIx
     *
     * @return string
     */
    public function getRfBankIx()
    {
        return $this->rfBankIx;
    }

    /**
     * Set rfBankDb
     *
     * @param string $rfBankDb
     *
     * @return RfBank
     */
    public function setRfBankDb($rfBankDb)
    {
        $this->rfBankDb = $rfBankDb;

        return $this;
    }

    /**
     * Get rfBankDb
     *
     * @return string
     */
    public function getRfBankDb()
    {
        return $this->rfBankDb;
    }

    /**
     * Set rfBankId
     *
     * @param integer $rfBankId
     *
     * @return RfBank
     */
    public function setRfBankId($rfBankId)
    {
        $this->rfBankId = $rfBankId;

        return $this;
    }

    /**
     * Get rfBankId
     *
     * @return integer
     */
    public function getRfBankId()
    {
        return $this->rfBankId;
    }

    /**
     * Set rfBankAbbrev
     *
     * @param string $rfBankAbbrev
     *
     * @return RfBank
     */
    public function setRfBankAbbrev($rfBankAbbrev)
    {
        $this->rfBankAbbrev = $rfBankAbbrev;

        return $this;
    }

    /**
     * Get rfBankAbbrev
     *
     * @return string
     */
    public function getRfBankAbbrev()
    {
        return $this->rfBankAbbrev;
    }

    /**
     * Set rfBankAccName
     *
     * @param string $rfBankAccName
     *
     * @return RfBank
     */
    public function setRfBankAccName($rfBankAccName)
    {
        $this->rfBankAccName = $rfBankAccName;

        return $this;
    }

    /**
     * Get rfBankAccName
     *
     * @return string
     */
    public function getRfBankAccName()
    {
        return $this->rfBankAccName;
    }

    /**
     * Set rfBankAccNo
     *
     * @param string $rfBankAccNo
     *
     * @return RfBank
     */
    public function setRfBankAccNo($rfBankAccNo)
    {
        $this->rfBankAccNo = $rfBankAccNo;

        return $this;
    }

    /**
     * Get rfBankAccNo
     *
     * @return string
     */
    public function getRfBankAccNo()
    {
        return $this->rfBankAccNo;
    }

    /**
     * Set rfBankDetail1
     *
     * @param string $rfBankDetail1
     *
     * @return RfBank
     */
    public function setRfBankDetail1($rfBankDetail1)
    {
        $this->rfBankDetail1 = $rfBankDetail1;

        return $this;
    }

    /**
     * Get rfBankDetail1
     *
     * @return string
     */
    public function getRfBankDetail1()
    {
        return $this->rfBankDetail1;
    }

    /**
     * Set rfBankDetail2
     *
     * @param string $rfBankDetail2
     *
     * @return RfBank
     */
    public function setRfBankDetail2($rfBankDetail2)
    {
        $this->rfBankDetail2 = $rfBankDetail2;

        return $this;
    }

    /**
     * Get rfBankDetail2
     *
     * @return string
     */
    public function getRfBankDetail2()
    {
        return $this->rfBankDetail2;
    }

    /**
     * Set rfBankDetail3
     *
     * @param string $rfBankDetail3
     *
     * @return RfBank
     */
    public function setRfBankDetail3($rfBankDetail3)
    {
        $this->rfBankDetail3 = $rfBankDetail3;

        return $this;
    }

    /**
     * Get rfBankDetail3
     *
     * @return string
     */
    public function getRfBankDetail3()
    {
        return $this->rfBankDetail3;
    }

    /**
     * Set rfBankInd
     *
     * @param boolean $rfBankInd
     *
     * @return RfBank
     */
    public function setRfBankInd($rfBankInd)
    {
        $this->rfBankInd = $rfBankInd;

        return $this;
    }

    /**
     * Get rfBankInd
     *
     * @return boolean
     */
    public function getRfBankInd()
    {
        return $this->rfBankInd;
    }

    /**
     * Set rfBankName
     *
     * @param string $rfBankName
     *
     * @return RfBank
     */
    public function setRfBankName($rfBankName)
    {
        $this->rfBankName = $rfBankName;

        return $this;
    }

    /**
     * Get rfBankName
     *
     * @return string
     */
    public function getRfBankName()
    {
        return $this->rfBankName;
    }

    /**
     * Set rfBankSysCode
     *
     * @param boolean $rfBankSysCode
     *
     * @return RfBank
     */
    public function setRfBankSysCode($rfBankSysCode)
    {
        $this->rfBankSysCode = $rfBankSysCode;

        return $this;
    }

    /**
     * Get rfBankSysCode
     *
     * @return boolean
     */
    public function getRfBankSysCode()
    {
        return $this->rfBankSysCode;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return RfBank
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RfBank
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set rfBankInactiveYn
     *
     * @param boolean $rfBankInactiveYn
     *
     * @return RfBank
     */
    public function setRfBankInactiveYn($rfBankInactiveYn)
    {
        $this->rfBankInactiveYn = $rfBankInactiveYn;

        return $this;
    }

    /**
     * Get rfBankInactiveYn
     *
     * @return boolean
     */
    public function getRfBankInactiveYn()
    {
        return $this->rfBankInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfBank
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfBankTrfYn
     *
     * @param boolean $rfBankTrfYn
     *
     * @return RfBank
     */
    public function setRfBankTrfYn($rfBankTrfYn)
    {
        $this->rfBankTrfYn = $rfBankTrfYn;

        return $this;
    }

    /**
     * Get rfBankTrfYn
     *
     * @return boolean
     */
    public function getRfBankTrfYn()
    {
        return $this->rfBankTrfYn;
    }
}
