<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfBankEnv
 *
 * @ORM\Table(name="rf_bank_env", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_bank_env_trf_yn", columns={"rf_bank_env_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfBankEnv
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_env_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfBankEnvIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_env_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfBankEnvDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_bank_env_id", type="integer", nullable=false)
     */
    private $rfBankEnvId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_bank_env_default_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfBankEnvDefaultYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_id", type="string", length=36, nullable=true)
     */
    private $rfBankId;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_database_id", type="smallint", nullable=true)
     */
    private $rfDatabaseId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_bank_env_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfBankEnvTrfYn;



    /**
     * Get rfBankEnvIx
     *
     * @return string
     */
    public function getRfBankEnvIx()
    {
        return $this->rfBankEnvIx;
    }

    /**
     * Set rfBankEnvDb
     *
     * @param string $rfBankEnvDb
     *
     * @return RfBankEnv
     */
    public function setRfBankEnvDb($rfBankEnvDb)
    {
        $this->rfBankEnvDb = $rfBankEnvDb;

        return $this;
    }

    /**
     * Get rfBankEnvDb
     *
     * @return string
     */
    public function getRfBankEnvDb()
    {
        return $this->rfBankEnvDb;
    }

    /**
     * Set rfBankEnvId
     *
     * @param integer $rfBankEnvId
     *
     * @return RfBankEnv
     */
    public function setRfBankEnvId($rfBankEnvId)
    {
        $this->rfBankEnvId = $rfBankEnvId;

        return $this;
    }

    /**
     * Get rfBankEnvId
     *
     * @return integer
     */
    public function getRfBankEnvId()
    {
        return $this->rfBankEnvId;
    }

    /**
     * Set rfBankEnvDefaultYn
     *
     * @param boolean $rfBankEnvDefaultYn
     *
     * @return RfBankEnv
     */
    public function setRfBankEnvDefaultYn($rfBankEnvDefaultYn)
    {
        $this->rfBankEnvDefaultYn = $rfBankEnvDefaultYn;

        return $this;
    }

    /**
     * Get rfBankEnvDefaultYn
     *
     * @return boolean
     */
    public function getRfBankEnvDefaultYn()
    {
        return $this->rfBankEnvDefaultYn;
    }

    /**
     * Set rfBankId
     *
     * @param string $rfBankId
     *
     * @return RfBankEnv
     */
    public function setRfBankId($rfBankId)
    {
        $this->rfBankId = $rfBankId;

        return $this;
    }

    /**
     * Get rfBankId
     *
     * @return string
     */
    public function getRfBankId()
    {
        return $this->rfBankId;
    }

    /**
     * Set rfDatabaseId
     *
     * @param integer $rfDatabaseId
     *
     * @return RfBankEnv
     */
    public function setRfDatabaseId($rfDatabaseId)
    {
        $this->rfDatabaseId = $rfDatabaseId;

        return $this;
    }

    /**
     * Get rfDatabaseId
     *
     * @return integer
     */
    public function getRfDatabaseId()
    {
        return $this->rfDatabaseId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfBankEnv
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfBankEnvTrfYn
     *
     * @param boolean $rfBankEnvTrfYn
     *
     * @return RfBankEnv
     */
    public function setRfBankEnvTrfYn($rfBankEnvTrfYn)
    {
        $this->rfBankEnvTrfYn = $rfBankEnvTrfYn;

        return $this;
    }

    /**
     * Get rfBankEnvTrfYn
     *
     * @return boolean
     */
    public function getRfBankEnvTrfYn()
    {
        return $this->rfBankEnvTrfYn;
    }
}
