<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfBankInv
 *
 * @ORM\Table(name="rf_bank_inv", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_bank_inv_trf_yn", columns={"rf_bank_inv_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfBankInv
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_inv_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfBankInvIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_inv_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfBankInvDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_bank_inv_id", type="integer", nullable=false)
     */
    private $rfBankInvId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_id", type="string", length=36, nullable=true)
     */
    private $rfBankId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id_account", type="string", length=36, nullable=true)
     */
    private $fnLedgerIdAccount;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id_deposit", type="string", length=36, nullable=true)
     */
    private $fnLedgerIdDeposit;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_bank_inv_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfBankInvTrfYn;



    /**
     * Get rfBankInvIx
     *
     * @return string
     */
    public function getRfBankInvIx()
    {
        return $this->rfBankInvIx;
    }

    /**
     * Set rfBankInvDb
     *
     * @param string $rfBankInvDb
     *
     * @return RfBankInv
     */
    public function setRfBankInvDb($rfBankInvDb)
    {
        $this->rfBankInvDb = $rfBankInvDb;

        return $this;
    }

    /**
     * Get rfBankInvDb
     *
     * @return string
     */
    public function getRfBankInvDb()
    {
        return $this->rfBankInvDb;
    }

    /**
     * Set rfBankInvId
     *
     * @param integer $rfBankInvId
     *
     * @return RfBankInv
     */
    public function setRfBankInvId($rfBankInvId)
    {
        $this->rfBankInvId = $rfBankInvId;

        return $this;
    }

    /**
     * Get rfBankInvId
     *
     * @return integer
     */
    public function getRfBankInvId()
    {
        return $this->rfBankInvId;
    }

    /**
     * Set rfBankId
     *
     * @param string $rfBankId
     *
     * @return RfBankInv
     */
    public function setRfBankId($rfBankId)
    {
        $this->rfBankId = $rfBankId;

        return $this;
    }

    /**
     * Get rfBankId
     *
     * @return string
     */
    public function getRfBankId()
    {
        return $this->rfBankId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RfBankInv
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set fnLedgerIdAccount
     *
     * @param string $fnLedgerIdAccount
     *
     * @return RfBankInv
     */
    public function setFnLedgerIdAccount($fnLedgerIdAccount)
    {
        $this->fnLedgerIdAccount = $fnLedgerIdAccount;

        return $this;
    }

    /**
     * Get fnLedgerIdAccount
     *
     * @return string
     */
    public function getFnLedgerIdAccount()
    {
        return $this->fnLedgerIdAccount;
    }

    /**
     * Set fnLedgerIdDeposit
     *
     * @param string $fnLedgerIdDeposit
     *
     * @return RfBankInv
     */
    public function setFnLedgerIdDeposit($fnLedgerIdDeposit)
    {
        $this->fnLedgerIdDeposit = $fnLedgerIdDeposit;

        return $this;
    }

    /**
     * Get fnLedgerIdDeposit
     *
     * @return string
     */
    public function getFnLedgerIdDeposit()
    {
        return $this->fnLedgerIdDeposit;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfBankInv
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfBankInvTrfYn
     *
     * @param boolean $rfBankInvTrfYn
     *
     * @return RfBankInv
     */
    public function setRfBankInvTrfYn($rfBankInvTrfYn)
    {
        $this->rfBankInvTrfYn = $rfBankInvTrfYn;

        return $this;
    }

    /**
     * Get rfBankInvTrfYn
     *
     * @return boolean
     */
    public function getRfBankInvTrfYn()
    {
        return $this->rfBankInvTrfYn;
    }
}
