<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfBankLedger
 *
 * @ORM\Table(name="rf_bank_ledger", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"})
 * @ORM\Entity
 */
class RfBankLedger
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_ledger_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfBankLedgerIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_ledger_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfBankLedgerDb = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_bank_ledger_id", type="integer", nullable=false)
     */
    private $rfBankLedgerId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_id", type="string", length=36, nullable=true)
     */
    private $rfBankId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id_account", type="string", length=36, nullable=true)
     */
    private $fnLedgerIdAccount;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id_deposit", type="string", length=36, nullable=true)
     */
    private $fnLedgerIdDeposit;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_bank_ledger_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfBankLedgerTrfYn = '0';



    /**
     * Set rfBankLedgerIx
     *
     * @param string $rfBankLedgerIx
     *
     * @return RfBankLedger
     */
    public function setRfBankLedgerIx($rfBankLedgerIx)
    {
        $this->rfBankLedgerIx = $rfBankLedgerIx;

        return $this;
    }

    /**
     * Get rfBankLedgerIx
     *
     * @return string
     */
    public function getRfBankLedgerIx()
    {
        return $this->rfBankLedgerIx;
    }

    /**
     * Set rfBankLedgerDb
     *
     * @param string $rfBankLedgerDb
     *
     * @return RfBankLedger
     */
    public function setRfBankLedgerDb($rfBankLedgerDb)
    {
        $this->rfBankLedgerDb = $rfBankLedgerDb;

        return $this;
    }

    /**
     * Get rfBankLedgerDb
     *
     * @return string
     */
    public function getRfBankLedgerDb()
    {
        return $this->rfBankLedgerDb;
    }

    /**
     * Set rfBankLedgerId
     *
     * @param integer $rfBankLedgerId
     *
     * @return RfBankLedger
     */
    public function setRfBankLedgerId($rfBankLedgerId)
    {
        $this->rfBankLedgerId = $rfBankLedgerId;

        return $this;
    }

    /**
     * Get rfBankLedgerId
     *
     * @return integer
     */
    public function getRfBankLedgerId()
    {
        return $this->rfBankLedgerId;
    }

    /**
     * Set rfBankId
     *
     * @param string $rfBankId
     *
     * @return RfBankLedger
     */
    public function setRfBankId($rfBankId)
    {
        $this->rfBankId = $rfBankId;

        return $this;
    }

    /**
     * Get rfBankId
     *
     * @return string
     */
    public function getRfBankId()
    {
        return $this->rfBankId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RfBankLedger
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set fnLedgerIdAccount
     *
     * @param string $fnLedgerIdAccount
     *
     * @return RfBankLedger
     */
    public function setFnLedgerIdAccount($fnLedgerIdAccount)
    {
        $this->fnLedgerIdAccount = $fnLedgerIdAccount;

        return $this;
    }

    /**
     * Get fnLedgerIdAccount
     *
     * @return string
     */
    public function getFnLedgerIdAccount()
    {
        return $this->fnLedgerIdAccount;
    }

    /**
     * Set fnLedgerIdDeposit
     *
     * @param string $fnLedgerIdDeposit
     *
     * @return RfBankLedger
     */
    public function setFnLedgerIdDeposit($fnLedgerIdDeposit)
    {
        $this->fnLedgerIdDeposit = $fnLedgerIdDeposit;

        return $this;
    }

    /**
     * Get fnLedgerIdDeposit
     *
     * @return string
     */
    public function getFnLedgerIdDeposit()
    {
        return $this->fnLedgerIdDeposit;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfBankLedger
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfBankLedgerTrfYn
     *
     * @param boolean $rfBankLedgerTrfYn
     *
     * @return RfBankLedger
     */
    public function setRfBankLedgerTrfYn($rfBankLedgerTrfYn)
    {
        $this->rfBankLedgerTrfYn = $rfBankLedgerTrfYn;

        return $this;
    }

    /**
     * Get rfBankLedgerTrfYn
     *
     * @return boolean
     */
    public function getRfBankLedgerTrfYn()
    {
        return $this->rfBankLedgerTrfYn;
    }
}
