<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfCommsPreference
 *
 * @ORM\Table(name="rf_comms_preference", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_comms_preference_trf_yn", columns={"rf_comms_preference_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfCommsPreference
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_comms_preference_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfCommsPreferenceIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_comms_preference_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfCommsPreferenceDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_comms_preference_id", type="integer", nullable=true)
     */
    private $rfCommsPreferenceId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_comms_desc", type="string", length=50, nullable=true)
     */
    private $rfCommsDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_comms_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfCommsInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_comms_preference_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfCommsPreferenceTrfYn;



    /**
     * Get rfCommsPreferenceIx
     *
     * @return string
     */
    public function getRfCommsPreferenceIx()
    {
        return $this->rfCommsPreferenceIx;
    }

    /**
     * Set rfCommsPreferenceDb
     *
     * @param string $rfCommsPreferenceDb
     *
     * @return RfCommsPreference
     */
    public function setRfCommsPreferenceDb($rfCommsPreferenceDb)
    {
        $this->rfCommsPreferenceDb = $rfCommsPreferenceDb;

        return $this;
    }

    /**
     * Get rfCommsPreferenceDb
     *
     * @return string
     */
    public function getRfCommsPreferenceDb()
    {
        return $this->rfCommsPreferenceDb;
    }

    /**
     * Set rfCommsPreferenceId
     *
     * @param integer $rfCommsPreferenceId
     *
     * @return RfCommsPreference
     */
    public function setRfCommsPreferenceId($rfCommsPreferenceId)
    {
        $this->rfCommsPreferenceId = $rfCommsPreferenceId;

        return $this;
    }

    /**
     * Get rfCommsPreferenceId
     *
     * @return integer
     */
    public function getRfCommsPreferenceId()
    {
        return $this->rfCommsPreferenceId;
    }

    /**
     * Set rfCommsDesc
     *
     * @param string $rfCommsDesc
     *
     * @return RfCommsPreference
     */
    public function setRfCommsDesc($rfCommsDesc)
    {
        $this->rfCommsDesc = $rfCommsDesc;

        return $this;
    }

    /**
     * Get rfCommsDesc
     *
     * @return string
     */
    public function getRfCommsDesc()
    {
        return $this->rfCommsDesc;
    }

    /**
     * Set rfCommsInactiveYn
     *
     * @param boolean $rfCommsInactiveYn
     *
     * @return RfCommsPreference
     */
    public function setRfCommsInactiveYn($rfCommsInactiveYn)
    {
        $this->rfCommsInactiveYn = $rfCommsInactiveYn;

        return $this;
    }

    /**
     * Get rfCommsInactiveYn
     *
     * @return boolean
     */
    public function getRfCommsInactiveYn()
    {
        return $this->rfCommsInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfCommsPreference
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfCommsPreferenceTrfYn
     *
     * @param boolean $rfCommsPreferenceTrfYn
     *
     * @return RfCommsPreference
     */
    public function setRfCommsPreferenceTrfYn($rfCommsPreferenceTrfYn)
    {
        $this->rfCommsPreferenceTrfYn = $rfCommsPreferenceTrfYn;

        return $this;
    }

    /**
     * Get rfCommsPreferenceTrfYn
     *
     * @return boolean
     */
    public function getRfCommsPreferenceTrfYn()
    {
        return $this->rfCommsPreferenceTrfYn;
    }
}
