<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfCountry
 *
 * @ORM\Table(name="rf_country", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_country_trf_yn", columns={"rf_country_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="rf_country_name", columns={"rf_country_name"})})
 * @ORM\Entity
 */
class RfCountry
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_country_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfCountryIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_country_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rfCountryDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_country_id", type="integer", nullable=false)
     */
    private $rfCountryId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_country_code", type="string", length=5, nullable=true)
     */
    private $rfCountryCode;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_country_colour", type="string", length=6, nullable=true)
     */
    private $rfCountryColour;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_country_dialcode", type="string", length=20, nullable=true)
     */
    private $rfCountryDialcode;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_country_name", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $rfCountryName;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true)
     */
    private $rfCurrencyId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_country_inactive", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfCountryInactive;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_country_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfCountryTrfYn;

    /**
     * Get rfCountryIx
     *
     * @return string
     */
    public function getRfCountryIx()
    {
        return $this->rfCountryIx;
    }

    /**
     * Set rfCountryDb
     *
     * @param string $rfCountryDb
     *
     * @return RfCountry
     */
    public function setRfCountryDb($rfCountryDb)
    {
        $this->rfCountryDb = $rfCountryDb;

        return $this;
    }

    /**
     * Get rfCountryDb
     *
     * @return string
     */
    public function getRfCountryDb()
    {
        return $this->rfCountryDb;
    }

    /**
     * Set rfCountryId
     *
     * @param integer $rfCountryId
     *
     * @return RfCountry
     */
    public function setRfCountryId($rfCountryId)
    {
        $this->rfCountryId = $rfCountryId;

        return $this;
    }

    /**
     * Get rfCountryId
     *
     * @return integer
     */
    public function getRfCountryId()
    {
        return $this->rfCountryId;
    }

    /**
     * Set rfCountryCode
     *
     * @param string $rfCountryCode
     *
     * @return RfCountry
     */
    public function setRfCountryCode($rfCountryCode)
    {
        $this->rfCountryCode = $rfCountryCode;

        return $this;
    }

    /**
     * Get rfCountryCode
     *
     * @return string
     */
    public function getRfCountryCode()
    {
        return $this->rfCountryCode;
    }

    /**
     * Set rfCountryColour
     *
     * @param string $rfCountryColour
     *
     * @return RfCountry
     */
    public function setRfCountryColour($rfCountryColour)
    {
        $this->rfCountryColour = $rfCountryColour;

        return $this;
    }

    /**
     * Get rfCountryColour
     *
     * @return string
     */
    public function getRfCountryColour()
    {
        return $this->rfCountryColour;
    }

    /**
     * Set rfCountryDialcode
     *
     * @param string $rfCountryDialcode
     *
     * @return RfCountry
     */
    public function setRfCountryDialcode($rfCountryDialcode)
    {
        $this->rfCountryDialcode = $rfCountryDialcode;

        return $this;
    }

    /**
     * Get rfCountryDialcode
     *
     * @return string
     */
    public function getRfCountryDialcode()
    {
        return $this->rfCountryDialcode;
    }

    /**
     * Set rfCountryName
     *
     * @param string $rfCountryName
     *
     * @return RfCountry
     */
    public function setRfCountryName($rfCountryName)
    {
        $this->rfCountryName = $rfCountryName;

        return $this;
    }

    /**
     * Get rfCountryName
     *
     * @return string
     */
    public function getRfCountryName()
    {
        return $this->rfCountryName;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return RfCountry
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rfCountryInactive
     *
     * @param boolean $rfCountryInactive
     *
     * @return RfCountry
     */
    public function setRfCountryInactive($rfCountryInactive)
    {
        $this->rfCountryInactive = $rfCountryInactive;

        return $this;
    }

    /**
     * Get rfCountryInactive
     *
     * @return boolean
     */
    public function getRfCountryInactive()
    {
        return $this->rfCountryInactive;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfCountry
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfCountryTrfYn
     *
     * @param boolean $rfCountryTrfYn
     *
     * @return RfCountry
     */
    public function setRfCountryTrfYn($rfCountryTrfYn)
    {
        $this->rfCountryTrfYn = $rfCountryTrfYn;

        return $this;
    }

    /**
     * Get rfCountryTrfYn
     *
     * @return boolean
     */
    public function getRfCountryTrfYn()
    {
        return $this->rfCountryTrfYn;
    }

    /**
     * Set rfCountryNicolIsCool
     *
     * @param string $rfCountryNicolIsCool
     *
     * @return RfCountry
     */
    public function setRfCountryNicolIsCool($rfCountryNicolIsCool)
    {
        $this->rfCountryNicolIsCool = $rfCountryNicolIsCool;

        return $this;
    }

    /**
     * Get rfCountryNicolIsCool
     *
     * @return string
     */
    public function getRfCountryNicolIsCool()
    {
        return $this->rfCountryNicolIsCool;
    }
}
