<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfCurrency
 *
 * @ORM\Table(name="rf_currency", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_currency_trf_yn", columns={"rf_currency_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="rf_currency_symbol", columns={"rf_currency_symbol"})})
 * @ORM\Entity
 */
class RfCurrency
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfCurrencyIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfCurrencyDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_currency_id", type="integer", nullable=false)
     */
    private $rfCurrencyId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_currency_exch_op", type="boolean", nullable=false, options={"default"="0", "unsigned"=true})
     */
    private $rfCurrencyExchOp;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_name", type="string", length=50, nullable=false, options={"default"=""})
     */
    private $rfCurrencyName;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_symbol", type="string", length=3, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfCurrencySymbol;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_currency_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfCurrencyInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_currency_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfCurrencyTrfYn;



    /**
     * Get rfCurrencyIx
     *
     * @return string
     */
    public function getRfCurrencyIx()
    {
        return $this->rfCurrencyIx;
    }

    /**
     * Set rfCurrencyDb
     *
     * @param string $rfCurrencyDb
     *
     * @return RfCurrency
     */
    public function setRfCurrencyDb($rfCurrencyDb)
    {
        $this->rfCurrencyDb = $rfCurrencyDb;

        return $this;
    }

    /**
     * Get rfCurrencyDb
     *
     * @return string
     */
    public function getRfCurrencyDb()
    {
        return $this->rfCurrencyDb;
    }

    /**
     * Set rfCurrencyId
     *
     * @param integer $rfCurrencyId
     *
     * @return RfCurrency
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return integer
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set rfCurrencyExchOp
     *
     * @param boolean $rfCurrencyExchOp
     *
     * @return RfCurrency
     */
    public function setRfCurrencyExchOp($rfCurrencyExchOp)
    {
        $this->rfCurrencyExchOp = $rfCurrencyExchOp;

        return $this;
    }

    /**
     * Get rfCurrencyExchOp
     *
     * @return boolean
     */
    public function getRfCurrencyExchOp()
    {
        return $this->rfCurrencyExchOp;
    }

    /**
     * Set rfCurrencyName
     *
     * @param string $rfCurrencyName
     *
     * @return RfCurrency
     */
    public function setRfCurrencyName($rfCurrencyName)
    {
        $this->rfCurrencyName = $rfCurrencyName;

        return $this;
    }

    /**
     * Get rfCurrencyName
     *
     * @return string
     */
    public function getRfCurrencyName()
    {
        return $this->rfCurrencyName;
    }

    /**
     * Set rfCurrencySymbol
     *
     * @param string $rfCurrencySymbol
     *
     * @return RfCurrency
     */
    public function setRfCurrencySymbol($rfCurrencySymbol)
    {
        $this->rfCurrencySymbol = $rfCurrencySymbol;

        return $this;
    }

    /**
     * Get rfCurrencySymbol
     *
     * @return string
     */
    public function getRfCurrencySymbol()
    {
        return $this->rfCurrencySymbol;
    }

    /**
     * Set rfCurrencyInactiveYn
     *
     * @param boolean $rfCurrencyInactiveYn
     *
     * @return RfCurrency
     */
    public function setRfCurrencyInactiveYn($rfCurrencyInactiveYn)
    {
        $this->rfCurrencyInactiveYn = $rfCurrencyInactiveYn;

        return $this;
    }

    /**
     * Get rfCurrencyInactiveYn
     *
     * @return boolean
     */
    public function getRfCurrencyInactiveYn()
    {
        return $this->rfCurrencyInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfCurrency
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfCurrencyTrfYn
     *
     * @param boolean $rfCurrencyTrfYn
     *
     * @return RfCurrency
     */
    public function setRfCurrencyTrfYn($rfCurrencyTrfYn)
    {
        $this->rfCurrencyTrfYn = $rfCurrencyTrfYn;

        return $this;
    }

    /**
     * Get rfCurrencyTrfYn
     *
     * @return boolean
     */
    public function getRfCurrencyTrfYn()
    {
        return $this->rfCurrencyTrfYn;
    }
}
