<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfCurrencyInv
 *
 * @ORM\Table(name="rf_currency_inv", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="pr_business_id", columns={"pr_business_id"}), @ORM\Index(name="rf_currency_inv_trf_yn", columns={"rf_currency_inv_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfCurrencyInv
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_inv_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfCurrencyInvIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_inv_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfCurrencyInvDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_currency_inv_id", type="integer", nullable=false)
     */
    private $rfCurrencyInvId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_inv_code", type="string", length=50, nullable=true)
     */
    private $rfCurrencyInvCode;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_currency_id", type="string", length=36, nullable=true)
     */
    private $rfCurrencyId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id_debtors", type="string", length=36, nullable=true)
     */
    private $fnLedgerIdDebtors;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_currency_inv_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfCurrencyInvTrfYn;



    /**
     * Get rfCurrencyInvIx
     *
     * @return string
     */
    public function getRfCurrencyInvIx()
    {
        return $this->rfCurrencyInvIx;
    }

    /**
     * Set rfCurrencyInvDb
     *
     * @param string $rfCurrencyInvDb
     *
     * @return RfCurrencyInv
     */
    public function setRfCurrencyInvDb($rfCurrencyInvDb)
    {
        $this->rfCurrencyInvDb = $rfCurrencyInvDb;

        return $this;
    }

    /**
     * Get rfCurrencyInvDb
     *
     * @return string
     */
    public function getRfCurrencyInvDb()
    {
        return $this->rfCurrencyInvDb;
    }

    /**
     * Set rfCurrencyInvId
     *
     * @param integer $rfCurrencyInvId
     *
     * @return RfCurrencyInv
     */
    public function setRfCurrencyInvId($rfCurrencyInvId)
    {
        $this->rfCurrencyInvId = $rfCurrencyInvId;

        return $this;
    }

    /**
     * Get rfCurrencyInvId
     *
     * @return integer
     */
    public function getRfCurrencyInvId()
    {
        return $this->rfCurrencyInvId;
    }

    /**
     * Set rfCurrencyInvCode
     *
     * @param string $rfCurrencyInvCode
     *
     * @return RfCurrencyInv
     */
    public function setRfCurrencyInvCode($rfCurrencyInvCode)
    {
        $this->rfCurrencyInvCode = $rfCurrencyInvCode;

        return $this;
    }

    /**
     * Get rfCurrencyInvCode
     *
     * @return string
     */
    public function getRfCurrencyInvCode()
    {
        return $this->rfCurrencyInvCode;
    }

    /**
     * Set rfCurrencyId
     *
     * @param string $rfCurrencyId
     *
     * @return RfCurrencyInv
     */
    public function setRfCurrencyId($rfCurrencyId)
    {
        $this->rfCurrencyId = $rfCurrencyId;

        return $this;
    }

    /**
     * Get rfCurrencyId
     *
     * @return string
     */
    public function getRfCurrencyId()
    {
        return $this->rfCurrencyId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RfCurrencyInv
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set fnLedgerIdDebtors
     *
     * @param string $fnLedgerIdDebtors
     *
     * @return RfCurrencyInv
     */
    public function setFnLedgerIdDebtors($fnLedgerIdDebtors)
    {
        $this->fnLedgerIdDebtors = $fnLedgerIdDebtors;

        return $this;
    }

    /**
     * Get fnLedgerIdDebtors
     *
     * @return string
     */
    public function getFnLedgerIdDebtors()
    {
        return $this->fnLedgerIdDebtors;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfCurrencyInv
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfCurrencyInvTrfYn
     *
     * @param boolean $rfCurrencyInvTrfYn
     *
     * @return RfCurrencyInv
     */
    public function setRfCurrencyInvTrfYn($rfCurrencyInvTrfYn)
    {
        $this->rfCurrencyInvTrfYn = $rfCurrencyInvTrfYn;

        return $this;
    }

    /**
     * Get rfCurrencyInvTrfYn
     *
     * @return boolean
     */
    public function getRfCurrencyInvTrfYn()
    {
        return $this->rfCurrencyInvTrfYn;
    }
}
