<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfCustom
 *
 * @ORM\Table(name="rf_custom", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_custom_trf_yn", columns={"rf_custom_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfCustom
{
    /**
     * @var integer
     *
     * @ORM\Column(name="rf_custom_id", type="integer", nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfCustomId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_booking_info", type="text", length=65535, nullable=true)
     */
    private $rfBookingInfo;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_welcome_note", type="text", length=65535, nullable=true)
     */
    private $rfWelcomeNote;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_logon_text_1", type="text", length=65535, nullable=true)
     */
    private $rfLogonText1;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_logon_text_2", type="text", length=65535, nullable=true)
     */
    private $rfLogonText2;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_logon_text_3", type="text", length=65535, nullable=true)
     */
    private $rfLogonText3;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_custom_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfCustomTrfYn;



    /**
     * Get rfCustomId
     *
     * @return integer
     */
    public function getRfCustomId()
    {
        return $this->rfCustomId;
    }

    /**
     * Set rfBookingInfo
     *
     * @param string $rfBookingInfo
     *
     * @return RfCustom
     */
    public function setRfBookingInfo($rfBookingInfo)
    {
        $this->rfBookingInfo = $rfBookingInfo;

        return $this;
    }

    /**
     * Get rfBookingInfo
     *
     * @return string
     */
    public function getRfBookingInfo()
    {
        return $this->rfBookingInfo;
    }

    /**
     * Set rfWelcomeNote
     *
     * @param string $rfWelcomeNote
     *
     * @return RfCustom
     */
    public function setRfWelcomeNote($rfWelcomeNote)
    {
        $this->rfWelcomeNote = $rfWelcomeNote;

        return $this;
    }

    /**
     * Get rfWelcomeNote
     *
     * @return string
     */
    public function getRfWelcomeNote()
    {
        return $this->rfWelcomeNote;
    }

    /**
     * Set rfLogonText1
     *
     * @param string $rfLogonText1
     *
     * @return RfCustom
     */
    public function setRfLogonText1($rfLogonText1)
    {
        $this->rfLogonText1 = $rfLogonText1;

        return $this;
    }

    /**
     * Get rfLogonText1
     *
     * @return string
     */
    public function getRfLogonText1()
    {
        return $this->rfLogonText1;
    }

    /**
     * Set rfLogonText2
     *
     * @param string $rfLogonText2
     *
     * @return RfCustom
     */
    public function setRfLogonText2($rfLogonText2)
    {
        $this->rfLogonText2 = $rfLogonText2;

        return $this;
    }

    /**
     * Get rfLogonText2
     *
     * @return string
     */
    public function getRfLogonText2()
    {
        return $this->rfLogonText2;
    }

    /**
     * Set rfLogonText3
     *
     * @param string $rfLogonText3
     *
     * @return RfCustom
     */
    public function setRfLogonText3($rfLogonText3)
    {
        $this->rfLogonText3 = $rfLogonText3;

        return $this;
    }

    /**
     * Get rfLogonText3
     *
     * @return string
     */
    public function getRfLogonText3()
    {
        return $this->rfLogonText3;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfCustom
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfCustomTrfYn
     *
     * @param boolean $rfCustomTrfYn
     *
     * @return RfCustom
     */
    public function setRfCustomTrfYn($rfCustomTrfYn)
    {
        $this->rfCustomTrfYn = $rfCustomTrfYn;

        return $this;
    }

    /**
     * Get rfCustomTrfYn
     *
     * @return boolean
     */
    public function getRfCustomTrfYn()
    {
        return $this->rfCustomTrfYn;
    }
}
