<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfDatabase
 *
 * @ORM\Table(name="rf_database", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, uniqueConstraints={@ORM\UniqueConstraint(name="rf_db_code", columns={"rf_db_code"})}, indexes={@ORM\Index(name="rf_database_trf_yn", columns={"rf_database_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfDatabase
{
    /**
     * @var integer
     *
     * @ORM\Column(name="rf_database_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $rfDatabaseId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_code", type="string", length=2, nullable=true, options={"fixed"="true"})
     */
    private $rfDbCode;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_description", type="string", length=50, nullable=true)
     */
    private $rfDbDescription;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_env_type_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDbEnvTypeInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_env_type_name", type="string", length=4, nullable=false, options={"default"=""})
     */
    private $rfDbEnvTypeName;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_env_type_web_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDbEnvTypeWebYn = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_phone_filename", type="string", length=200, nullable=true)
     */
    private $rfDbPhoneFilename;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_phone_frequency", type="boolean", nullable=false, options={"default"="2"})
     */
    private $rfDbPhoneFrequency;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_phone_ignore", type="text", length=65535, nullable=true)
     */
    private $rfDbPhoneIgnore;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_phone_ignore_dept", type="text", length=65535, nullable=true)
     */
    private $rfDbPhoneIgnoreDept;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_pos_folder", type="string", length=200, nullable=true)
     */
    private $rfDbPosFolder;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_pos_frequency", type="boolean", nullable=false, options={"default"="2"})
     */
    private $rfDbPosFrequency;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_db_room_cal_days", type="smallint", nullable=false, options={"default"="7"})
     */
    private $rfDbRoomCalDays;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_smtp_address", type="string", length=64, nullable=true)
     */
    private $rfDbSmtpAddress;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_db_smtp_port", type="integer", nullable=false, options={"default"="25"})
     */
    private $rfDbSmtpPort;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_smtp_auth_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDbSmtpAuthInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_smtp_security_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDbSmtpSecurityInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_smtp_password", type="string", length=30, nullable=true)
     */
    private $rfDbSmtpPassword;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_smtp_username", type="string", length=100, nullable=true)
     */
    private $rfDbSmtpUsername;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_smtp_hostname_override", type="string", length=64, nullable=false, options={"default"=""})
     */
    private $rfDbSmtpHostnameOverride;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rf_db_time_var_amt", type="time", nullable=false, options={"default"="00:00:00"})
     */
    private $rfDbTimeVarAmt;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_time_var_dir", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDbTimeVarDir;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_time_zone", type="string", length=40, nullable=true)
     */
    private $rfDbTimeZone;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_version_db", type="string", length=20, nullable=true)
     */
    private $rfDbVersionDb;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_bank_id", type="string", length=36, nullable=true)
     */
    private $rfBankId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_mail_id", type="string", length=36, nullable=true)
     */
    private $rfMailId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_trf_auto_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDbTrfAutoYn;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_db_trf_max_minutes", type="integer", nullable=false, options={"default"="1440"})
     */
    private $rfDbTrfMaxMinutes;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_trf_auto_note", type="string", length=100, nullable=false, options={"default"=""})
     */
    private $rfDbTrfAutoNote;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_cache_stock_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDbCacheStockYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDbInactiveYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_replicated_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDbReplicatedYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_database_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDatabaseTrfYn;



    /**
     * Get rfDatabaseId
     *
     * @return integer
     */
    public function getRfDatabaseId()
    {
        return $this->rfDatabaseId;
    }

    /**
     * Set rfDbCode
     *
     * @param string $rfDbCode
     *
     * @return RfDatabase
     */
    public function setRfDbCode($rfDbCode)
    {
        $this->rfDbCode = $rfDbCode;

        return $this;
    }

    /**
     * Get rfDbCode
     *
     * @return string
     */
    public function getRfDbCode()
    {
        return $this->rfDbCode;
    }

    /**
     * Set rfDbDescription
     *
     * @param string $rfDbDescription
     *
     * @return RfDatabase
     */
    public function setRfDbDescription($rfDbDescription)
    {
        $this->rfDbDescription = $rfDbDescription;

        return $this;
    }

    /**
     * Get rfDbDescription
     *
     * @return string
     */
    public function getRfDbDescription()
    {
        return $this->rfDbDescription;
    }

    /**
     * Set rfDbEnvTypeInd
     *
     * @param boolean $rfDbEnvTypeInd
     *
     * @return RfDatabase
     */
    public function setRfDbEnvTypeInd($rfDbEnvTypeInd)
    {
        $this->rfDbEnvTypeInd = $rfDbEnvTypeInd;

        return $this;
    }

    /**
     * Get rfDbEnvTypeInd
     *
     * @return boolean
     */
    public function getRfDbEnvTypeInd()
    {
        return $this->rfDbEnvTypeInd;
    }

    /**
     * Set rfDbEnvTypeName
     *
     * @param string $rfDbEnvTypeName
     *
     * @return RfDatabase
     */
    public function setRfDbEnvTypeName($rfDbEnvTypeName)
    {
        $this->rfDbEnvTypeName = $rfDbEnvTypeName;

        return $this;
    }

    /**
     * Get rfDbEnvTypeName
     *
     * @return string
     */
    public function getRfDbEnvTypeName()
    {
        return $this->rfDbEnvTypeName;
    }

    /**
     * Set rfDbEnvTypeWebYn
     *
     * @param boolean $rfDbEnvTypeWebYn
     *
     * @return RfDatabase
     */
    public function setRfDbEnvTypeWebYn($rfDbEnvTypeWebYn)
    {
        $this->rfDbEnvTypeWebYn = $rfDbEnvTypeWebYn;

        return $this;
    }

    /**
     * Get rfDbEnvTypeWebYn
     *
     * @return boolean
     */
    public function getRfDbEnvTypeWebYn()
    {
        return $this->rfDbEnvTypeWebYn;
    }

    /**
     * Set rfDbPhoneFilename
     *
     * @param string $rfDbPhoneFilename
     *
     * @return RfDatabase
     */
    public function setRfDbPhoneFilename($rfDbPhoneFilename)
    {
        $this->rfDbPhoneFilename = $rfDbPhoneFilename;

        return $this;
    }

    /**
     * Get rfDbPhoneFilename
     *
     * @return string
     */
    public function getRfDbPhoneFilename()
    {
        return $this->rfDbPhoneFilename;
    }

    /**
     * Set rfDbPhoneFrequency
     *
     * @param boolean $rfDbPhoneFrequency
     *
     * @return RfDatabase
     */
    public function setRfDbPhoneFrequency($rfDbPhoneFrequency)
    {
        $this->rfDbPhoneFrequency = $rfDbPhoneFrequency;

        return $this;
    }

    /**
     * Get rfDbPhoneFrequency
     *
     * @return boolean
     */
    public function getRfDbPhoneFrequency()
    {
        return $this->rfDbPhoneFrequency;
    }

    /**
     * Set rfDbPhoneIgnore
     *
     * @param string $rfDbPhoneIgnore
     *
     * @return RfDatabase
     */
    public function setRfDbPhoneIgnore($rfDbPhoneIgnore)
    {
        $this->rfDbPhoneIgnore = $rfDbPhoneIgnore;

        return $this;
    }

    /**
     * Get rfDbPhoneIgnore
     *
     * @return string
     */
    public function getRfDbPhoneIgnore()
    {
        return $this->rfDbPhoneIgnore;
    }

    /**
     * Set rfDbPhoneIgnoreDept
     *
     * @param string $rfDbPhoneIgnoreDept
     *
     * @return RfDatabase
     */
    public function setRfDbPhoneIgnoreDept($rfDbPhoneIgnoreDept)
    {
        $this->rfDbPhoneIgnoreDept = $rfDbPhoneIgnoreDept;

        return $this;
    }

    /**
     * Get rfDbPhoneIgnoreDept
     *
     * @return string
     */
    public function getRfDbPhoneIgnoreDept()
    {
        return $this->rfDbPhoneIgnoreDept;
    }

    /**
     * Set rfDbPosFolder
     *
     * @param string $rfDbPosFolder
     *
     * @return RfDatabase
     */
    public function setRfDbPosFolder($rfDbPosFolder)
    {
        $this->rfDbPosFolder = $rfDbPosFolder;

        return $this;
    }

    /**
     * Get rfDbPosFolder
     *
     * @return string
     */
    public function getRfDbPosFolder()
    {
        return $this->rfDbPosFolder;
    }

    /**
     * Set rfDbPosFrequency
     *
     * @param boolean $rfDbPosFrequency
     *
     * @return RfDatabase
     */
    public function setRfDbPosFrequency($rfDbPosFrequency)
    {
        $this->rfDbPosFrequency = $rfDbPosFrequency;

        return $this;
    }

    /**
     * Get rfDbPosFrequency
     *
     * @return boolean
     */
    public function getRfDbPosFrequency()
    {
        return $this->rfDbPosFrequency;
    }

    /**
     * Set rfDbRoomCalDays
     *
     * @param integer $rfDbRoomCalDays
     *
     * @return RfDatabase
     */
    public function setRfDbRoomCalDays($rfDbRoomCalDays)
    {
        $this->rfDbRoomCalDays = $rfDbRoomCalDays;

        return $this;
    }

    /**
     * Get rfDbRoomCalDays
     *
     * @return integer
     */
    public function getRfDbRoomCalDays()
    {
        return $this->rfDbRoomCalDays;
    }

    /**
     * Set rfDbSmtpAddress
     *
     * @param string $rfDbSmtpAddress
     *
     * @return RfDatabase
     */
    public function setRfDbSmtpAddress($rfDbSmtpAddress)
    {
        $this->rfDbSmtpAddress = $rfDbSmtpAddress;

        return $this;
    }

    /**
     * Get rfDbSmtpAddress
     *
     * @return string
     */
    public function getRfDbSmtpAddress()
    {
        return $this->rfDbSmtpAddress;
    }

    /**
     * Set rfDbSmtpPort
     *
     * @param integer $rfDbSmtpPort
     *
     * @return RfDatabase
     */
    public function setRfDbSmtpPort($rfDbSmtpPort)
    {
        $this->rfDbSmtpPort = $rfDbSmtpPort;

        return $this;
    }

    /**
     * Get rfDbSmtpPort
     *
     * @return integer
     */
    public function getRfDbSmtpPort()
    {
        return $this->rfDbSmtpPort;
    }

    /**
     * Set rfDbSmtpAuthInd
     *
     * @param boolean $rfDbSmtpAuthInd
     *
     * @return RfDatabase
     */
    public function setRfDbSmtpAuthInd($rfDbSmtpAuthInd)
    {
        $this->rfDbSmtpAuthInd = $rfDbSmtpAuthInd;

        return $this;
    }

    /**
     * Get rfDbSmtpAuthInd
     *
     * @return boolean
     */
    public function getRfDbSmtpAuthInd()
    {
        return $this->rfDbSmtpAuthInd;
    }

    /**
     * Set rfDbSmtpSecurityInd
     *
     * @param boolean $rfDbSmtpSecurityInd
     *
     * @return RfDatabase
     */
    public function setRfDbSmtpSecurityInd($rfDbSmtpSecurityInd)
    {
        $this->rfDbSmtpSecurityInd = $rfDbSmtpSecurityInd;

        return $this;
    }

    /**
     * Get rfDbSmtpSecurityInd
     *
     * @return boolean
     */
    public function getRfDbSmtpSecurityInd()
    {
        return $this->rfDbSmtpSecurityInd;
    }

    /**
     * Set rfDbSmtpPassword
     *
     * @param string $rfDbSmtpPassword
     *
     * @return RfDatabase
     */
    public function setRfDbSmtpPassword($rfDbSmtpPassword)
    {
        $this->rfDbSmtpPassword = $rfDbSmtpPassword;

        return $this;
    }

    /**
     * Get rfDbSmtpPassword
     *
     * @return string
     */
    public function getRfDbSmtpPassword()
    {
        return $this->rfDbSmtpPassword;
    }

    /**
     * Set rfDbSmtpUsername
     *
     * @param string $rfDbSmtpUsername
     *
     * @return RfDatabase
     */
    public function setRfDbSmtpUsername($rfDbSmtpUsername)
    {
        $this->rfDbSmtpUsername = $rfDbSmtpUsername;

        return $this;
    }

    /**
     * Get rfDbSmtpUsername
     *
     * @return string
     */
    public function getRfDbSmtpUsername()
    {
        return $this->rfDbSmtpUsername;
    }

    /**
     * Set rfDbSmtpHostnameOverride
     *
     * @param string $rfDbSmtpHostnameOverride
     *
     * @return RfDatabase
     */
    public function setRfDbSmtpHostnameOverride($rfDbSmtpHostnameOverride)
    {
        $this->rfDbSmtpHostnameOverride = $rfDbSmtpHostnameOverride;

        return $this;
    }

    /**
     * Get rfDbSmtpHostnameOverride
     *
     * @return string
     */
    public function getRfDbSmtpHostnameOverride()
    {
        return $this->rfDbSmtpHostnameOverride;
    }

    /**
     * Set rfDbTimeVarAmt
     *
     * @param \DateTime $rfDbTimeVarAmt
     *
     * @return RfDatabase
     */
    public function setRfDbTimeVarAmt($rfDbTimeVarAmt)
    {
        $this->rfDbTimeVarAmt = $rfDbTimeVarAmt;

        return $this;
    }

    /**
     * Get rfDbTimeVarAmt
     *
     * @return \DateTime
     */
    public function getRfDbTimeVarAmt()
    {
        return $this->rfDbTimeVarAmt;
    }

    /**
     * Set rfDbTimeVarDir
     *
     * @param boolean $rfDbTimeVarDir
     *
     * @return RfDatabase
     */
    public function setRfDbTimeVarDir($rfDbTimeVarDir)
    {
        $this->rfDbTimeVarDir = $rfDbTimeVarDir;

        return $this;
    }

    /**
     * Get rfDbTimeVarDir
     *
     * @return boolean
     */
    public function getRfDbTimeVarDir()
    {
        return $this->rfDbTimeVarDir;
    }

    /**
     * Set rfDbTimeZone
     *
     * @param string $rfDbTimeZone
     *
     * @return RfDatabase
     */
    public function setRfDbTimeZone($rfDbTimeZone)
    {
        $this->rfDbTimeZone = $rfDbTimeZone;

        return $this;
    }

    /**
     * Get rfDbTimeZone
     *
     * @return string
     */
    public function getRfDbTimeZone()
    {
        return $this->rfDbTimeZone;
    }

    /**
     * Set rfDbVersionDb
     *
     * @param string $rfDbVersionDb
     *
     * @return RfDatabase
     */
    public function setRfDbVersionDb($rfDbVersionDb)
    {
        $this->rfDbVersionDb = $rfDbVersionDb;

        return $this;
    }

    /**
     * Get rfDbVersionDb
     *
     * @return string
     */
    public function getRfDbVersionDb()
    {
        return $this->rfDbVersionDb;
    }

    /**
     * Set rfBankId
     *
     * @param string $rfBankId
     *
     * @return RfDatabase
     */
    public function setRfBankId($rfBankId)
    {
        $this->rfBankId = $rfBankId;

        return $this;
    }

    /**
     * Get rfBankId
     *
     * @return string
     */
    public function getRfBankId()
    {
        return $this->rfBankId;
    }

    /**
     * Set rfMailId
     *
     * @param string $rfMailId
     *
     * @return RfDatabase
     */
    public function setRfMailId($rfMailId)
    {
        $this->rfMailId = $rfMailId;

        return $this;
    }

    /**
     * Get rfMailId
     *
     * @return string
     */
    public function getRfMailId()
    {
        return $this->rfMailId;
    }

    /**
     * Set rfDbTrfAutoYn
     *
     * @param boolean $rfDbTrfAutoYn
     *
     * @return RfDatabase
     */
    public function setRfDbTrfAutoYn($rfDbTrfAutoYn)
    {
        $this->rfDbTrfAutoYn = $rfDbTrfAutoYn;

        return $this;
    }

    /**
     * Get rfDbTrfAutoYn
     *
     * @return boolean
     */
    public function getRfDbTrfAutoYn()
    {
        return $this->rfDbTrfAutoYn;
    }

    /**
     * Set rfDbTrfMaxMinutes
     *
     * @param integer $rfDbTrfMaxMinutes
     *
     * @return RfDatabase
     */
    public function setRfDbTrfMaxMinutes($rfDbTrfMaxMinutes)
    {
        $this->rfDbTrfMaxMinutes = $rfDbTrfMaxMinutes;

        return $this;
    }

    /**
     * Get rfDbTrfMaxMinutes
     *
     * @return integer
     */
    public function getRfDbTrfMaxMinutes()
    {
        return $this->rfDbTrfMaxMinutes;
    }

    /**
     * Set rfDbTrfAutoNote
     *
     * @param string $rfDbTrfAutoNote
     *
     * @return RfDatabase
     */
    public function setRfDbTrfAutoNote($rfDbTrfAutoNote)
    {
        $this->rfDbTrfAutoNote = $rfDbTrfAutoNote;

        return $this;
    }

    /**
     * Get rfDbTrfAutoNote
     *
     * @return string
     */
    public function getRfDbTrfAutoNote()
    {
        return $this->rfDbTrfAutoNote;
    }

    /**
     * Set rfDbCacheStockYn
     *
     * @param boolean $rfDbCacheStockYn
     *
     * @return RfDatabase
     */
    public function setRfDbCacheStockYn($rfDbCacheStockYn)
    {
        $this->rfDbCacheStockYn = $rfDbCacheStockYn;

        return $this;
    }

    /**
     * Get rfDbCacheStockYn
     *
     * @return boolean
     */
    public function getRfDbCacheStockYn()
    {
        return $this->rfDbCacheStockYn;
    }

    /**
     * Set rfDbInactiveYn
     *
     * @param boolean $rfDbInactiveYn
     *
     * @return RfDatabase
     */
    public function setRfDbInactiveYn($rfDbInactiveYn)
    {
        $this->rfDbInactiveYn = $rfDbInactiveYn;

        return $this;
    }

    /**
     * Get rfDbInactiveYn
     *
     * @return boolean
     */
    public function getRfDbInactiveYn()
    {
        return $this->rfDbInactiveYn;
    }

    /**
     * Set rfDbReplicatedYn
     *
     * @param boolean $rfDbReplicatedYn
     *
     * @return RfDatabase
     */
    public function setRfDbReplicatedYn($rfDbReplicatedYn)
    {
        $this->rfDbReplicatedYn = $rfDbReplicatedYn;

        return $this;
    }

    /**
     * Get rfDbReplicatedYn
     *
     * @return boolean
     */
    public function getRfDbReplicatedYn()
    {
        return $this->rfDbReplicatedYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfDatabase
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfDatabaseTrfYn
     *
     * @param boolean $rfDatabaseTrfYn
     *
     * @return RfDatabase
     */
    public function setRfDatabaseTrfYn($rfDatabaseTrfYn)
    {
        $this->rfDatabaseTrfYn = $rfDatabaseTrfYn;

        return $this;
    }

    /**
     * Get rfDatabaseTrfYn
     *
     * @return boolean
     */
    public function getRfDatabaseTrfYn()
    {
        return $this->rfDatabaseTrfYn;
    }
}
