<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfDbBusiness
 *
 * @ORM\Table(name="rf_db_business", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_db_business_trf_yn", columns={"rf_db_business_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfDbBusiness
{
    /**
     * @var integer
     *
     * @ORM\Column(name="rf_db_business_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $rfDbBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=50, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_db_code", type="string", length=2, nullable=true, options={"fixed"="true"})
     */
    private $rfDbCode;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_db_business_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDbBusinessTrfYn;



    /**
     * Get rfDbBusinessId
     *
     * @return integer
     */
    public function getRfDbBusinessId()
    {
        return $this->rfDbBusinessId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RfDbBusiness
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set rfDbCode
     *
     * @param string $rfDbCode
     *
     * @return RfDbBusiness
     */
    public function setRfDbCode($rfDbCode)
    {
        $this->rfDbCode = $rfDbCode;

        return $this;
    }

    /**
     * Get rfDbCode
     *
     * @return string
     */
    public function getRfDbCode()
    {
        return $this->rfDbCode;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfDbBusiness
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfDbBusinessTrfYn
     *
     * @param boolean $rfDbBusinessTrfYn
     *
     * @return RfDbBusiness
     */
    public function setRfDbBusinessTrfYn($rfDbBusinessTrfYn)
    {
        $this->rfDbBusinessTrfYn = $rfDbBusinessTrfYn;

        return $this;
    }

    /**
     * Get rfDbBusinessTrfYn
     *
     * @return boolean
     */
    public function getRfDbBusinessTrfYn()
    {
        return $this->rfDbBusinessTrfYn;
    }
}
