<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfDefault
 *
 * @ORM\Table(name="rf_default", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_default_trf_yn", columns={"rf_default_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfDefault
{
    /**
     * @var integer
     *
     * @ORM\Column(name="rf_default_id", type="integer", nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfDefaultId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_pay_plan_id", type="string", length=36, nullable=true)
     */
    private $acPayPlanId;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="rf_auth_https_yn", type="boolean", nullable=false, options={"default"="0"})
	 */
	private $rfAuthHttpsYn;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="rf_auth_previous_password_yn", type="boolean", nullable=false, options={"default"="0"})
	 */
	private $rfAuthPreviousPasswordYn;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="rf_auth_previous_password_limit", type="boolean", nullable=false, options={"default"="4"})
	 */
	private $rfAuthPreviousPasswordLimit;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="rf_auth_minimum_length_yn", type="boolean", nullable=false, options={"default"="0"})
	 */
	private $rfAuthMinimumLengthYn;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="rf_auth_minimum_length_limit", type="boolean", nullable=false, options={"default"="7"})
	 */
	private $rfAuthMinimumLengthLimit;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="rf_auth_uppercase_yn", type="boolean", nullable=false, options={"default"="0"})
	 */
	private $rfAuthUppercaseYn;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="rf_auth_lowercase_yn", type="boolean", nullable=false, options={"default"="0"})
	 */
	private $rfAuthLowercaseYn;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="rf_auth_numeric_yn", type="boolean", nullable=false, options={"default"="0"})
	 */
	private $rfAuthNumericYn;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="rf_auth_special_yn", type="boolean", nullable=false, options={"default"="0"})
	 */
	private $rfAuthSpecialYn;

	/**
	 * @var boolean
	 *
	 * @ORM\Column(name="rf_auth_force_change_yn", type="boolean", nullable=false, options={"default"="0"})
	 */
	private $rfAuthForceChangeYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_avail_limit", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfAvailLimit;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_exch_expiry_days", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfExchExpiryDays;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_exch_save_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rfExchSaveYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_exch_allow_update_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfExchAllowUpdateYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_exch_show_past_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfExchShowPastYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_exch_master_db_ind", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rfExchMasterDbInd;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_exch_master_db_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $rfExchMasterDbId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_book_limit", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rfBookLimit;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_accomm_sort_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfAccommSortInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_cancel_warn_note", type="string", length=255, nullable=true, options={"default"="This action will cancel the reservation."})
     */
    private $rfCancelWarnNote;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_cancel_warn_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfCancelWarnYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_cc_res_summ_persona_id", type="string", length=36, nullable=true)
     */
    private $rfCcResSummPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_cc_proforma_persona_id", type="string", length=36, nullable=true)
     */
    private $rfCcProformaPersonaId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_cc_invoice_persona_id", type="string", length=36, nullable=true)
     */
    private $rfCcInvoicePersonaId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rf_date_import", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $rfDateImport;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_date_import_tz", type="string", length=40, nullable=false)
     */
    private $rfDateImportTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rf_date_res_limit", type="date", nullable=false, options={"default"="2014-12-31"})
     */
    private $rfDateResLimit;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rf_date_transfer", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $rfDateTransfer;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_date_transfer_tz", type="string", length=40, nullable=false)
     */
    private $rfDateTransferTz;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_room_cal_days", type="boolean", nullable=false, options={"default"="8"})
     */
    private $rfRoomCalDays;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_share_notes_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfShareNotesYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_site_title", type="string", length=100, nullable=false, options={"default"=""})
     */
    private $rfSiteTitle;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_site_description", type="text", length=65535, nullable=false)
     */
    private $rfSiteDescription;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_site_keywords", type="text", length=65535, nullable=false)
     */
    private $rfSiteKeywords;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_analytics_code", type="string", length=20, nullable=false, options={"default"=""})
     */
    private $rfAnalyticsCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_analytics_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfAnalyticsYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_analytics_internal_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfAnalyticsInternalYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_analytics_external_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfAnalyticsExternalYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_analytics_public_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfAnalyticsPublicYn;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_doc_settings", type="integer", nullable=false, options={"default"="0"})
     */
    private $rfDocSettings;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_doc_header_res_office_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rfDocHeaderResOfficeYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_doc_header_res_office_type_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDocHeaderResOfficeTypeInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_doc_header_res_office_url_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rfDocHeaderResOfficeUrlYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_doc_header_logo_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rfDocHeaderLogoYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_doc_header_logo_type_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDocHeaderLogoTypeInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_doc_header_invoice_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rfDocHeaderInvoiceYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_doc_tax_table_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDocTaxTableYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_doc_tax_table_rate_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDocTaxTableRateYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_doc_tax_table_total_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDocTaxTableTotalYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_doc_summary_comp_group_label", type="string", length=50, nullable=false, options={"default"="Accommodation"})
     */
    private $rfDocSummaryCompGroupLabel;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_doc_proforma_comp_group_label", type="string", length=50, nullable=false, options={"default"="Accommodation"})
     */
    private $rfDocProformaCompGroupLabel;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_doc_invoice_comp_group_label", type="string", length=50, nullable=false, options={"default"="Accommodation"})
     */
    private $rfDocInvoiceCompGroupLabel;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_invoice_date", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rfInvoiceDate;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_invoice_future_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfInvoiceFutureYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_invoice_title", type="string", length=50, nullable=false, options={"default"="Invoice"})
     */
    private $rfInvoiceTitle;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_itinerary_title", type="string", length=50, nullable=false, options={"default"="Itinerary"})
     */
    private $rfItineraryTitle;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_pay_plan_upd_auto_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPayPlanUpdAutoYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_period_split", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rfPeriodSplit;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_proforma_note", type="string", length=250, nullable=true)
     */
    private $rfProformaNote;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_proforma_title", type="string", length=50, nullable=false, options={"default"="Proforma Invoice"})
     */
    private $rfProformaTitle;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_prov_expiry_auto_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfProvExpiryAutoYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_prov_expiry_days", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfProvExpiryDays;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_sys_admin_id", type="string", length=36, nullable=true)
     */
    private $rfSysAdminId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_phone_type_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfPhoneTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rtRateTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfTaxRateId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_show_agent_note_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfShowAgentNoteYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_show_allocs_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfShowAllocsYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_check_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaCheckYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_first_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaFirstYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_first_soundex_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaFirstSoundexYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_first_exact_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaFirstExactYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_first_match_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaFirstMatchYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_first_match_limit", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaFirstMatchLimit;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_last_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaLastYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_last_soundex_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaLastSoundexYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_last_exact_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaLastExactYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_last_match_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaLastMatchYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_persona_last_match_limit", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPersonaLastMatchLimit;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_prn_web_site", type="text", length=65535, nullable=true)
     */
    private $rfPrnWebSite;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_res_create_expiry_mins", type="integer", nullable=false, options={"default"="3"})
     */
    private $rfResCreateExpiryMins;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_res_create_expiry_internal", type="integer", nullable=false, options={"default"="15"})
     */
    private $rfResCreateExpiryInternal;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_payment_gateway_expiry_mins", type="integer", nullable=false, options={"default"="5"})
     */
    private $rfPaymentGatewayExpiryMins;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_payment_gateway_email_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPaymentGatewayEmailYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_per_stay_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPerStayYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_per_stay_auto_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPerStayAutoYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_principal_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfPrincipalId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_res_office_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfResOfficeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_statutory_label_1", type="string", length=50, nullable=false)
     */
    private $rfStatutoryLabel1;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_statutory_label_2", type="string", length=50, nullable=false)
     */
    private $rfStatutoryLabel2;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_statutory_label_3", type="string", length=50, nullable=false)
     */
    private $rfStatutoryLabel3;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_guest_indemnity_message", type="text", nullable=false, options={"default"=""})
     */
    private $rfGuestIndemnityMessage;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_default_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDefaultTrfYn;



    /**
     * Get rfDefaultId
     *
     * @return integer
     */
    public function getRfDefaultId()
    {
        return $this->rfDefaultId;
    }

    /**
     * Set acPayPlanId
     *
     * @param string $acPayPlanId
     *
     * @return RfDefault
     */
    public function setAcPayPlanId($acPayPlanId)
    {
        $this->acPayPlanId = $acPayPlanId;

        return $this;
    }

    /**
     * Get acPayPlanId
     *
     * @return string
     */
    public function getAcPayPlanId()
    {
        return $this->acPayPlanId;
    }

	/**
	 * Set rfAuthHttpsYn
	 *
	 * @param boolean $rfAuthHttpsYn
	 *
	 * @return RfDefault
	 */
	public function setRfAuthHttpsYn($rfAuthHttpsYn)
	{
		$this->rfAuthHttpsYn = $rfAuthHttpsYn;

		return $this;
	}

	/**
	 * Get rfAuthHttpsYn
	 *
	 * @return boolean
	 */
	public function getRfAuthHttpsYn()
	{
		return $this->rfAuthHttpsYn;
	}

	/**
	 * Set rfAuthPreviousPasswordYn
	 *
	 * @param boolean $rfAuthPreviousPasswordYn
	 *
	 * @return RfDefault
	 */
	public function setRfAuthPreviousPasswordYn($rfAuthPreviousPasswordYn)
	{
		$this->rfAuthPreviousPasswordYn = $rfAuthPreviousPasswordYn;

		return $this;
	}

	/**
	 * Get rfAuthPreviousPasswordYn
	 *
	 * @return boolean
	 */
	public function getRfAuthPreviousPasswordYn()
	{
		return $this->rfAuthPreviousPasswordYn;
	}

	/**
	 * Set rfAuthPreviousPasswordLimit
	 *
	 * @param boolean $rfAuthPreviousPasswordLimit
	 *
	 * @return RfDefault
	 */
	public function setRfAuthPreviousPasswordLimit($rfAuthPreviousPasswordLimit)
	{
		$this->rfAuthPreviousPasswordLimit = $rfAuthPreviousPasswordLimit;

		return $this;
	}

	/**
	 * Get rfAuthPreviousPasswordLimit
	 *
	 * @return boolean
	 */
	public function getRfAuthPreviousPasswordLimit()
	{
		return $this->rfAuthPreviousPasswordLimit;
	}

	/**
	 * Set rfAuthMinimumLengthYn
	 *
	 * @param boolean $rfAuthMinimumLengthYn
	 *
	 * @return RfDefault
	 */
	public function setRfAuthMinimumLengthYn($rfAuthMinimumLengthYn)
	{
		$this->rfAuthMinimumLengthYn = $rfAuthMinimumLengthYn;

		return $this;
	}

	/**
	 * Get rfAuthMinimumLengthYn
	 *
	 * @return boolean
	 */
	public function getRfAuthMinimumLengthYn()
	{
		return $this->rfAuthMinimumLengthYn;
	}

	/**
	 * Set rfAuthMinimumLengthLimit
	 *
	 * @param boolean $rfAuthMinimumLengthLimit
	 *
	 * @return RfDefault
	 */
	public function setRfAuthMinimumLengthLimit($rfAuthMinimumLengthLimit)
	{
		$this->rfAuthMinimumLengthLimit = $rfAuthMinimumLengthLimit;

		return $this;
	}

	/**
	 * Get rfAuthMinimumLengthLimit
	 *
	 * @return boolean
	 */
	public function getRfAuthMinimumLengthLimit()
	{
		return $this->rfAuthMinimumLengthLimit;
	}

	/**
	 * Set rfAuthUppercaseYn
	 *
	 * @param boolean $rfAuthUppercaseYn
	 *
	 * @return RfDefault
	 */
	public function setRfAuthUppercaseYn($rfAuthUppercaseYn)
	{
		$this->rfAuthUppercaseYn = $rfAuthUppercaseYn;

		return $this;
	}

	/**
	 * Get rfAuthUppercaseYn
	 *
	 * @return boolean
	 */
	public function getRfAuthUppercaseYn()
	{
		return $this->rfAuthUppercaseYn;
	}

	/**
	 * Set rfAuthLowercaseYn
	 *
	 * @param boolean $rfAuthLowercaseYn
	 *
	 * @return RfDefault
	 */
	public function setRfAuthLowercaseYn($rfAuthLowercaseYn)
	{
		$this->rfAuthLowercaseYn = $rfAuthLowercaseYn;

		return $this;
	}

	/**
	 * Get rfAuthLowercaseYn
	 *
	 * @return boolean
	 */
	public function getRfAuthLowercaseYn()
	{
		return $this->rfAuthLowercaseYn;
	}

	/**
	 * Set rfAuthNumericYn
	 *
	 * @param boolean $rfAuthNumericYn
	 *
	 * @return RfDefault
	 */
	public function setRfAuthNumericYn($rfAuthNumericYn)
	{
		$this->rfAuthNumericYn = $rfAuthNumericYn;

		return $this;
	}

	/**
	 * Get rfAuthNumericYn
	 *
	 * @return boolean
	 */
	public function getRfAuthNumericYn()
	{
		return $this->rfAuthNumericYn;
	}

	/**
	 * Set rfAuthSpecialYn
	 *
	 * @param boolean $rfAuthSpecialYn
	 *
	 * @return RfDefault
	 */
	public function setRfAuthSpecialYn($rfAuthSpecialYn)
	{
		$this->rfAuthSpecialYn = $rfAuthSpecialYn;

		return $this;
	}

	/**
	 * Get rfAuthSpecialYn
	 *
	 * @return boolean
	 */
	public function getRfAuthSpecialYn()
	{
		return $this->rfAuthSpecialYn;
	}

	/**
	 * Set rfAuthForceChangeYn
	 *
	 * @param boolean $rfAuthForceChangeYn
	 *
	 * @return RfDefault
	 */
	public function setRfAuthForceChangeYn($rfAuthForceChangeYn)
	{
		$this->rfAuthForceChangeYn = $rfAuthForceChangeYn;

		return $this;
	}

	/**
	 * Get rfAuthForceChangeYn
	 *
	 * @return boolean
	 */
	public function getRfAuthForceChangeYn()
	{
		return $this->rfAuthForceChangeYn;
	}

    /**
     * Set rfAvailLimit
     *
     * @param boolean $rfAvailLimit
     *
     * @return RfDefault
     */
    public function setRfAvailLimit($rfAvailLimit)
    {
        $this->rfAvailLimit = $rfAvailLimit;

        return $this;
    }

    /**
     * Get rfAvailLimit
     *
     * @return boolean
     */
    public function getRfAvailLimit()
    {
        return $this->rfAvailLimit;
    }

    /**
     * Set rfExchExpiryDays
     *
     * @param boolean $rfExchExpiryDays
     *
     * @return RfDefault
     */
    public function setRfExchExpiryDays($rfExchExpiryDays)
    {
        $this->rfExchExpiryDays = $rfExchExpiryDays;

        return $this;
    }

    /**
     * Get rfExchExpiryDays
     *
     * @return boolean
     */
    public function getRfExchExpiryDays()
    {
        return $this->rfExchExpiryDays;
    }

    /**
     * Set rfExchSaveYn
     *
     * @param boolean $rfExchSaveYn
     *
     * @return RfDefault
     */
    public function setRfExchSaveYn($rfExchSaveYn)
    {
        $this->rfExchSaveYn = $rfExchSaveYn;

        return $this;
    }

    /**
     * Get rfExchSaveYn
     *
     * @return boolean
     */
    public function getRfExchSaveYn()
    {
        return $this->rfExchSaveYn;
    }

    /**
     * Set rfExchAllowUpdateYn
     *
     * @param boolean $rfExchAllowUpdateYn
     *
     * @return RfDefault
     */
    public function setRfExchAllowUpdateYn($rfExchAllowUpdateYn)
    {
        $this->rfExchAllowUpdateYn = $rfExchAllowUpdateYn;

        return $this;
    }

    /**
     * Get rfExchAllowUpdateYn
     *
     * @return boolean
     */
    public function getRfExchAllowUpdateYn()
    {
        return $this->rfExchAllowUpdateYn;
    }

    /**
     * Set rfExchShowPastYn
     *
     * @param boolean $rfExchShowPastYn
     *
     * @return RfDefault
     */
    public function setRfExchShowPastYn($rfExchShowPastYn)
    {
        $this->rfExchShowPastYn = $rfExchShowPastYn;

        return $this;
    }

    /**
     * Get rfExchShowPastYn
     *
     * @return boolean
     */
    public function getRfExchShowPastYn()
    {
        return $this->rfExchShowPastYn;
    }

    /**
     * Set rfExchMasterDbInd
     *
     * @param boolean $rfExchMasterDbInd
     *
     * @return RfDefault
     */
    public function setRfExchMasterDbInd($rfExchMasterDbInd)
    {
        $this->rfExchMasterDbInd = $rfExchMasterDbInd;

        return $this;
    }

    /**
     * Get rfExchMasterDbInd
     *
     * @return boolean
     */
    public function getRfExchMasterDbInd()
    {
        return $this->rfExchMasterDbInd;
    }

    /**
     * Set rfExchMasterDbId
     *
     * @param integer $rfExchMasterDbId
     *
     * @return RfDefault
     */
    public function setRfExchMasterDbId($rfExchMasterDbId)
    {
        $this->rfExchMasterDbId = $rfExchMasterDbId;

        return $this;
    }

    /**
     * Get rfExchMasterDbId
     *
     * @return integer
     */
    public function getRfExchMasterDbId()
    {
        return $this->rfExchMasterDbId;
    }

    /**
     * Set rfBookLimit
     *
     * @param boolean $rfBookLimit
     *
     * @return RfDefault
     */
    public function setRfBookLimit($rfBookLimit)
    {
        $this->rfBookLimit = $rfBookLimit;

        return $this;
    }

    /**
     * Get rfBookLimit
     *
     * @return boolean
     */
    public function getRfBookLimit()
    {
        return $this->rfBookLimit;
    }

    /**
     * Set rfAccommSortInd
     *
     * @param boolean $rfAccommSortInd
     *
     * @return RfDefault
     */
    public function setRfAccommSortInd($rfAccommSortInd)
    {
        $this->rfAccommSortInd = $rfAccommSortInd;

        return $this;
    }

    /**
     * Get rfAccommSortInd
     *
     * @return boolean
     */
    public function getRfAccommSortInd()
    {
        return $this->rfAccommSortInd;
    }

    /**
     * Set rfCancelWarnNote
     *
     * @param string $rfCancelWarnNote
     *
     * @return RfDefault
     */
    public function setRfCancelWarnNote($rfCancelWarnNote)
    {
        $this->rfCancelWarnNote = $rfCancelWarnNote;

        return $this;
    }

    /**
     * Get rfCancelWarnNote
     *
     * @return string
     */
    public function getRfCancelWarnNote()
    {
        return $this->rfCancelWarnNote;
    }

    /**
     * Set rfCancelWarnYn
     *
     * @param boolean $rfCancelWarnYn
     *
     * @return RfDefault
     */
    public function setRfCancelWarnYn($rfCancelWarnYn)
    {
        $this->rfCancelWarnYn = $rfCancelWarnYn;

        return $this;
    }

    /**
     * Get rfCancelWarnYn
     *
     * @return boolean
     */
    public function getRfCancelWarnYn()
    {
        return $this->rfCancelWarnYn;
    }

    /**
     * Set rfCcResSummPersonaId
     *
     * @param string $rfCcResSummPersonaId
     *
     * @return RfDefault
     */
    public function setRfCcResSummPersonaId($rfCcResSummPersonaId)
    {
        $this->rfCcResSummPersonaId = $rfCcResSummPersonaId;

        return $this;
    }

    /**
     * Get rfCcResSummPersonaId
     *
     * @return string
     */
    public function getRfCcResSummPersonaId()
    {
        return $this->rfCcResSummPersonaId;
    }

    /**
     * Set rfCcProformaPersonaId
     *
     * @param string $rfCcProformaPersonaId
     *
     * @return RfDefault
     */
    public function setRfCcProformaPersonaId($rfCcProformaPersonaId)
    {
        $this->rfCcProformaPersonaId = $rfCcProformaPersonaId;

        return $this;
    }

    /**
     * Get rfCcProformaPersonaId
     *
     * @return string
     */
    public function getRfCcProformaPersonaId()
    {
        return $this->rfCcProformaPersonaId;
    }

    /**
     * Set rfCcInvoicePersonaId
     *
     * @param string $rfCcInvoicePersonaId
     *
     * @return RfDefault
     */
    public function setRfCcInvoicePersonaId($rfCcInvoicePersonaId)
    {
        $this->rfCcInvoicePersonaId = $rfCcInvoicePersonaId;

        return $this;
    }

    /**
     * Get rfCcInvoicePersonaId
     *
     * @return string
     */
    public function getRfCcInvoicePersonaId()
    {
        return $this->rfCcInvoicePersonaId;
    }

    /**
     * Set rfDateImport
     *
     * @param \DateTime $rfDateImport
     *
     * @return RfDefault
     */
    public function setRfDateImport($rfDateImport)
    {
        $this->rfDateImport = $rfDateImport;

        return $this;
    }

    /**
     * Get rfDateImport
     *
     * @return \DateTime
     */
    public function getRfDateImport()
    {
        return $this->rfDateImport;
    }

    /**
     * Set rfDateImportTz
     *
     * @param string $rfDateImportTz
     *
     * @return RfDefault
     */
    public function setRfDateImportTz($rfDateImportTz)
    {
        $this->rfDateImportTz = $rfDateImportTz;

        return $this;
    }

    /**
     * Get rfDateImportTz
     *
     * @return string
     */
    public function getRfDateImportTz()
    {
        return $this->rfDateImportTz;
    }

    /**
     * Set rfDateResLimit
     *
     * @param \DateTime $rfDateResLimit
     *
     * @return RfDefault
     */
    public function setRfDateResLimit($rfDateResLimit)
    {
        $this->rfDateResLimit = $rfDateResLimit;

        return $this;
    }

    /**
     * Get rfDateResLimit
     *
     * @return \DateTime
     */
    public function getRfDateResLimit()
    {
        return $this->rfDateResLimit;
    }

    /**
     * Set rfDateTransfer
     *
     * @param \DateTime $rfDateTransfer
     *
     * @return RfDefault
     */
    public function setRfDateTransfer($rfDateTransfer)
    {
        $this->rfDateTransfer = $rfDateTransfer;

        return $this;
    }

    /**
     * Get rfDateTransfer
     *
     * @return \DateTime
     */
    public function getRfDateTransfer()
    {
        return $this->rfDateTransfer;
    }

    /**
     * Set rfDateTransferTz
     *
     * @param string $rfDateTransferTz
     *
     * @return RfDefault
     */
    public function setRfDateTransferTz($rfDateTransferTz)
    {
        $this->rfDateTransferTz = $rfDateTransferTz;

        return $this;
    }

    /**
     * Get rfDateTransferTz
     *
     * @return string
     */
    public function getRfDateTransferTz()
    {
        return $this->rfDateTransferTz;
    }

    /**
     * Set rfRoomCalDays
     *
     * @param boolean $rfRoomCalDays
     *
     * @return RfDefault
     */
    public function setRfRoomCalDays($rfRoomCalDays)
    {
        $this->rfRoomCalDays = $rfRoomCalDays;

        return $this;
    }

    /**
     * Get rfRoomCalDays
     *
     * @return boolean
     */
    public function getRfRoomCalDays()
    {
        return $this->rfRoomCalDays;
    }

    /**
     * Set rfShareNotesYn
     *
     * @param boolean $rfShareNotesYn
     *
     * @return RfDefault
     */
    public function setRfShareNotesYn($rfShareNotesYn)
    {
        $this->rfShareNotesYn = $rfShareNotesYn;

        return $this;
    }

    /**
     * Get rfShareNotesYn
     *
     * @return boolean
     */
    public function getRfShareNotesYn()
    {
        return $this->rfShareNotesYn;
    }

    /**
     * Set rfSiteTitle
     *
     * @param string $rfSiteTitle
     *
     * @return RfDefault
     */
    public function setRfSiteTitle($rfSiteTitle)
    {
        $this->rfSiteTitle = $rfSiteTitle;

        return $this;
    }

    /**
     * Get rfSiteTitle
     *
     * @return string
     */
    public function getRfSiteTitle()
    {
        return $this->rfSiteTitle;
    }

    /**
     * Set rfSiteDescription
     *
     * @param string $rfSiteDescription
     *
     * @return RfDefault
     */
    public function setRfSiteDescription($rfSiteDescription)
    {
        $this->rfSiteDescription = $rfSiteDescription;

        return $this;
    }

    /**
     * Get rfSiteDescription
     *
     * @return string
     */
    public function getRfSiteDescription()
    {
        return $this->rfSiteDescription;
    }

    /**
     * Set rfSiteKeywords
     *
     * @param string $rfSiteKeywords
     *
     * @return RfDefault
     */
    public function setRfSiteKeywords($rfSiteKeywords)
    {
        $this->rfSiteKeywords = $rfSiteKeywords;

        return $this;
    }

    /**
     * Get rfSiteKeywords
     *
     * @return string
     */
    public function getRfSiteKeywords()
    {
        return $this->rfSiteKeywords;
    }

    /**
     * Set rfAnalyticsCode
     *
     * @param string $rfAnalyticsCode
     *
     * @return RfDefault
     */
    public function setRfAnalyticsCode($rfAnalyticsCode)
    {
        $this->rfAnalyticsCode = $rfAnalyticsCode;

        return $this;
    }

    /**
     * Get rfAnalyticsCode
     *
     * @return string
     */
    public function getRfAnalyticsCode()
    {
        return $this->rfAnalyticsCode;
    }

    /**
     * Set rfAnalyticsYn
     *
     * @param boolean $rfAnalyticsYn
     *
     * @return RfDefault
     */
    public function setRfAnalyticsYn($rfAnalyticsYn)
    {
        $this->rfAnalyticsYn = $rfAnalyticsYn;

        return $this;
    }

    /**
     * Get rfAnalyticsYn
     *
     * @return boolean
     */
    public function getRfAnalyticsYn()
    {
        return $this->rfAnalyticsYn;
    }

    /**
     * Set rfAnalyticsInternalYn
     *
     * @param boolean $rfAnalyticsInternalYn
     *
     * @return RfDefault
     */
    public function setRfAnalyticsInternalYn($rfAnalyticsInternalYn)
    {
        $this->rfAnalyticsInternalYn = $rfAnalyticsInternalYn;

        return $this;
    }

    /**
     * Get rfAnalyticsInternalYn
     *
     * @return boolean
     */
    public function getRfAnalyticsInternalYn()
    {
        return $this->rfAnalyticsInternalYn;
    }

    /**
     * Set rfAnalyticsExternalYn
     *
     * @param boolean $rfAnalyticsExternalYn
     *
     * @return RfDefault
     */
    public function setRfAnalyticsExternalYn($rfAnalyticsExternalYn)
    {
        $this->rfAnalyticsExternalYn = $rfAnalyticsExternalYn;

        return $this;
    }

    /**
     * Get rfAnalyticsExternalYn
     *
     * @return boolean
     */
    public function getRfAnalyticsExternalYn()
    {
        return $this->rfAnalyticsExternalYn;
    }

    /**
     * Set rfAnalyticsPublicYn
     *
     * @param boolean $rfAnalyticsPublicYn
     *
     * @return RfDefault
     */
    public function setRfAnalyticsPublicYn($rfAnalyticsPublicYn)
    {
        $this->rfAnalyticsPublicYn = $rfAnalyticsPublicYn;

        return $this;
    }

    /**
     * Get rfAnalyticsPublicYn
     *
     * @return boolean
     */
    public function getRfAnalyticsPublicYn()
    {
        return $this->rfAnalyticsPublicYn;
    }

    /**
     * Set rfDocSettings
     *
     * @param integer $rfDocSettings
     *
     * @return RfDefault
     */
    public function setRfDocSettings($rfDocSettings)
    {
        $this->rfDocSettings = $rfDocSettings;

        return $this;
    }

    /**
     * Get rfDocSettings
     *
     * @return integer
     */
    public function getRfDocSettings()
    {
        return $this->rfDocSettings;
    }

    /**
     * Set rfDocHeaderResOfficeYn
     *
     * @param boolean $rfDocHeaderResOfficeYn
     *
     * @return RfDefault
     */
    public function setRfDocHeaderResOfficeYn($rfDocHeaderResOfficeYn)
    {
        $this->rfDocHeaderResOfficeYn = $rfDocHeaderResOfficeYn;

        return $this;
    }

    /**
     * Get rfDocHeaderResOfficeYn
     *
     * @return boolean
     */
    public function getRfDocHeaderResOfficeYn()
    {
        return $this->rfDocHeaderResOfficeYn;
    }

    /**
     * Set rfDocHeaderResOfficeTypeInd
     *
     * @param boolean $rfDocHeaderResOfficeTypeInd
     *
     * @return RfDefault
     */
    public function setRfDocHeaderResOfficeTypeInd($rfDocHeaderResOfficeTypeInd)
    {
        $this->rfDocHeaderResOfficeTypeInd = $rfDocHeaderResOfficeTypeInd;

        return $this;
    }

    /**
     * Get rfDocHeaderResOfficeTypeInd
     *
     * @return boolean
     */
    public function getRfDocHeaderResOfficeTypeInd()
    {
        return $this->rfDocHeaderResOfficeTypeInd;
    }

    /**
     * Set rfDocHeaderResOfficeUrlYn
     *
     * @param boolean $rfDocHeaderResOfficeUrlYn
     *
     * @return RfDefault
     */
    public function setRfDocHeaderResOfficeUrlYn($rfDocHeaderResOfficeUrlYn)
    {
        $this->rfDocHeaderResOfficeUrlYn = $rfDocHeaderResOfficeUrlYn;

        return $this;
    }

    /**
     * Get rfDocHeaderResOfficeUrlYn
     *
     * @return boolean
     */
    public function getRfDocHeaderResOfficeUrlYn()
    {
        return $this->rfDocHeaderResOfficeUrlYn;
    }

    /**
     * Set rfDocHeaderLogoYn
     *
     * @param boolean $rfDocHeaderLogoYn
     *
     * @return RfDefault
     */
    public function setRfDocHeaderLogoYn($rfDocHeaderLogoYn)
    {
        $this->rfDocHeaderLogoYn = $rfDocHeaderLogoYn;

        return $this;
    }

    /**
     * Get rfDocHeaderLogoYn
     *
     * @return boolean
     */
    public function getRfDocHeaderLogoYn()
    {
        return $this->rfDocHeaderLogoYn;
    }

    /**
     * Set rfDocHeaderLogoTypeInd
     *
     * @param boolean $rfDocHeaderLogoTypeInd
     *
     * @return RfDefault
     */
    public function setRfDocHeaderLogoTypeInd($rfDocHeaderLogoTypeInd)
    {
        $this->rfDocHeaderLogoTypeInd = $rfDocHeaderLogoTypeInd;

        return $this;
    }

    /**
     * Get rfDocHeaderLogoTypeInd
     *
     * @return boolean
     */
    public function getRfDocHeaderLogoTypeInd()
    {
        return $this->rfDocHeaderLogoTypeInd;
    }

    /**
     * Set rfDocHeaderInvoiceYn
     *
     * @param boolean $rfDocHeaderInvoiceYn
     *
     * @return RfDefault
     */
    public function setRfDocHeaderInvoiceYn($rfDocHeaderInvoiceYn)
    {
        $this->rfDocHeaderInvoiceYn = $rfDocHeaderInvoiceYn;

        return $this;
    }

    /**
     * Get rfDocHeaderInvoiceYn
     *
     * @return boolean
     */
    public function getRfDocHeaderInvoiceYn()
    {
        return $this->rfDocHeaderInvoiceYn;
    }

    /**
     * Set rfDocTaxTableYn
     *
     * @param boolean $rfDocTaxTableYn
     *
     * @return RfDefault
     */
    public function setRfDocTaxTableYn($rfDocTaxTableYn)
    {
        $this->rfDocTaxTableYn = $rfDocTaxTableYn;

        return $this;
    }

    /**
     * Get rfDocTaxTableYn
     *
     * @return boolean
     */
    public function getRfDocTaxTableYn()
    {
        return $this->rfDocTaxTableYn;
    }

    /**
     * Set rfDocTaxTableRateYn
     *
     * @param boolean $rfDocTaxTableRateYn
     *
     * @return RfDefault
     */
    public function setRfDocTaxTableRateYn($rfDocTaxTableRateYn)
    {
        $this->rfDocTaxTableRateYn = $rfDocTaxTableRateYn;

        return $this;
    }

    /**
     * Get rfDocTaxTableRateYn
     *
     * @return boolean
     */
    public function getRfDocTaxTableRateYn()
    {
        return $this->rfDocTaxTableRateYn;
    }

    /**
     * Set rfDocTaxTableTotalYn
     *
     * @param boolean $rfDocTaxTableTotalYn
     *
     * @return RfDefault
     */
    public function setRfDocTaxTableTotalYn($rfDocTaxTableTotalYn)
    {
        $this->rfDocTaxTableTotalYn = $rfDocTaxTableTotalYn;

        return $this;
    }

    /**
     * Get rfDocTaxTableTotalYn
     *
     * @return boolean
     */
    public function getRfDocTaxTableTotalYn()
    {
        return $this->rfDocTaxTableTotalYn;
    }

    /**
     * Set rfDocSummaryCompGroupLabel
     *
     * @param string $rfDocSummaryCompGroupLabel
     *
     * @return RfDefault
     */
    public function setRfDocSummaryCompGroupLabel($rfDocSummaryCompGroupLabel)
    {
        $this->rfDocSummaryCompGroupLabel = $rfDocSummaryCompGroupLabel;

        return $this;
    }

    /**
     * Get rfDocSummaryCompGroupLabel
     *
     * @return string
     */
    public function getRfDocSummaryCompGroupLabel()
    {
        return $this->rfDocSummaryCompGroupLabel;
    }

    /**
     * Set rfDocProformaCompGroupLabel
     *
     * @param string $rfDocProformaCompGroupLabel
     *
     * @return RfDefault
     */
    public function setRfDocProformaCompGroupLabel($rfDocProformaCompGroupLabel)
    {
        $this->rfDocProformaCompGroupLabel = $rfDocProformaCompGroupLabel;

        return $this;
    }

    /**
     * Get rfDocProformaCompGroupLabel
     *
     * @return string
     */
    public function getRfDocProformaCompGroupLabel()
    {
        return $this->rfDocProformaCompGroupLabel;
    }

    /**
     * Set rfDocInvoiceCompGroupLabel
     *
     * @param string $rfDocInvoiceCompGroupLabel
     *
     * @return RfDefault
     */
    public function setRfDocInvoiceCompGroupLabel($rfDocInvoiceCompGroupLabel)
    {
        $this->rfDocInvoiceCompGroupLabel = $rfDocInvoiceCompGroupLabel;

        return $this;
    }

    /**
     * Get rfDocInvoiceCompGroupLabel
     *
     * @return string
     */
    public function getRfDocInvoiceCompGroupLabel()
    {
        return $this->rfDocInvoiceCompGroupLabel;
    }

    /**
     * Set rfInvoiceDate
     *
     * @param boolean $rfInvoiceDate
     *
     * @return RfDefault
     */
    public function setRfInvoiceDate($rfInvoiceDate)
    {
        $this->rfInvoiceDate = $rfInvoiceDate;

        return $this;
    }

    /**
     * Get rfInvoiceDate
     *
     * @return boolean
     */
    public function getRfInvoiceDate()
    {
        return $this->rfInvoiceDate;
    }

    /**
     * Set rfInvoiceFutureYn
     *
     * @param boolean $rfInvoiceFutureYn
     *
     * @return RfDefault
     */
    public function setRfInvoiceFutureYn($rfInvoiceFutureYn)
    {
        $this->rfInvoiceFutureYn = $rfInvoiceFutureYn;

        return $this;
    }

    /**
     * Get rfInvoiceFutureYn
     *
     * @return boolean
     */
    public function getRfInvoiceFutureYn()
    {
        return $this->rfInvoiceFutureYn;
    }

    /**
     * Set rfInvoiceTitle
     *
     * @param string $rfInvoiceTitle
     *
     * @return RfDefault
     */
    public function setRfInvoiceTitle($rfInvoiceTitle)
    {
        $this->rfInvoiceTitle = $rfInvoiceTitle;

        return $this;
    }

    /**
     * Get rfInvoiceTitle
     *
     * @return string
     */
    public function getRfInvoiceTitle()
    {
        return $this->rfInvoiceTitle;
    }

    /**
     * Set rfItineraryTitle
     *
     * @param string $rfItineraryTitle
     *
     * @return RfDefault
     */
    public function setRfItineraryTitle($rfItineraryTitle)
    {
        $this->rfItineraryTitle = $rfItineraryTitle;

        return $this;
    }

    /**
     * Get rfItineraryTitle
     *
     * @return string
     */
    public function getRfItineraryTitle()
    {
        return $this->rfItineraryTitle;
    }

    /**
     * Set rfPayPlanUpdAutoYn
     *
     * @param boolean $rfPayPlanUpdAutoYn
     *
     * @return RfDefault
     */
    public function setRfPayPlanUpdAutoYn($rfPayPlanUpdAutoYn)
    {
        $this->rfPayPlanUpdAutoYn = $rfPayPlanUpdAutoYn;

        return $this;
    }

    /**
     * Get rfPayPlanUpdAutoYn
     *
     * @return boolean
     */
    public function getRfPayPlanUpdAutoYn()
    {
        return $this->rfPayPlanUpdAutoYn;
    }

    /**
     * Set rfPeriodSplit
     *
     * @param boolean $rfPeriodSplit
     *
     * @return RfDefault
     */
    public function setRfPeriodSplit($rfPeriodSplit)
    {
        $this->rfPeriodSplit = $rfPeriodSplit;

        return $this;
    }

    /**
     * Get rfPeriodSplit
     *
     * @return boolean
     */
    public function getRfPeriodSplit()
    {
        return $this->rfPeriodSplit;
    }

    /**
     * Set rfProformaNote
     *
     * @param string $rfProformaNote
     *
     * @return RfDefault
     */
    public function setRfProformaNote($rfProformaNote)
    {
        $this->rfProformaNote = $rfProformaNote;

        return $this;
    }

    /**
     * Get rfProformaNote
     *
     * @return string
     */
    public function getRfProformaNote()
    {
        return $this->rfProformaNote;
    }

    /**
     * Set rfProformaTitle
     *
     * @param string $rfProformaTitle
     *
     * @return RfDefault
     */
    public function setRfProformaTitle($rfProformaTitle)
    {
        $this->rfProformaTitle = $rfProformaTitle;

        return $this;
    }

    /**
     * Get rfProformaTitle
     *
     * @return string
     */
    public function getRfProformaTitle()
    {
        return $this->rfProformaTitle;
    }

    /**
     * Set rfProvExpiryAutoYn
     *
     * @param boolean $rfProvExpiryAutoYn
     *
     * @return RfDefault
     */
    public function setRfProvExpiryAutoYn($rfProvExpiryAutoYn)
    {
        $this->rfProvExpiryAutoYn = $rfProvExpiryAutoYn;

        return $this;
    }

    /**
     * Get rfProvExpiryAutoYn
     *
     * @return boolean
     */
    public function getRfProvExpiryAutoYn()
    {
        return $this->rfProvExpiryAutoYn;
    }

    /**
     * Set rfProvExpiryDays
     *
     * @param boolean $rfProvExpiryDays
     *
     * @return RfDefault
     */
    public function setRfProvExpiryDays($rfProvExpiryDays)
    {
        $this->rfProvExpiryDays = $rfProvExpiryDays;

        return $this;
    }

    /**
     * Get rfProvExpiryDays
     *
     * @return boolean
     */
    public function getRfProvExpiryDays()
    {
        return $this->rfProvExpiryDays;
    }

    /**
     * Set rfSysAdminId
     *
     * @param string $rfSysAdminId
     *
     * @return RfDefault
     */
    public function setRfSysAdminId($rfSysAdminId)
    {
        $this->rfSysAdminId = $rfSysAdminId;

        return $this;
    }

    /**
     * Get rfSysAdminId
     *
     * @return string
     */
    public function getRfSysAdminId()
    {
        return $this->rfSysAdminId;
    }

    /**
     * Set rfPhoneTypeId
     *
     * @param string $rfPhoneTypeId
     *
     * @return RfDefault
     */
    public function setRfPhoneTypeId($rfPhoneTypeId)
    {
        $this->rfPhoneTypeId = $rfPhoneTypeId;

        return $this;
    }

    /**
     * Get rfPhoneTypeId
     *
     * @return string
     */
    public function getRfPhoneTypeId()
    {
        return $this->rfPhoneTypeId;
    }

    /**
     * Set rtRateTypeId
     *
     * @param string $rtRateTypeId
     *
     * @return RfDefault
     */
    public function setRtRateTypeId($rtRateTypeId)
    {
        $this->rtRateTypeId = $rtRateTypeId;

        return $this;
    }

    /**
     * Get rtRateTypeId
     *
     * @return string
     */
    public function getRtRateTypeId()
    {
        return $this->rtRateTypeId;
    }

    /**
     * Set rfTaxRateId
     *
     * @param string $rfTaxRateId
     *
     * @return RfDefault
     */
    public function setRfTaxRateId($rfTaxRateId)
    {
        $this->rfTaxRateId = $rfTaxRateId;

        return $this;
    }

    /**
     * Get rfTaxRateId
     *
     * @return string
     */
    public function getRfTaxRateId()
    {
        return $this->rfTaxRateId;
    }

    /**
     * Set rfShowAgentNoteYn
     *
     * @param boolean $rfShowAgentNoteYn
     *
     * @return RfDefault
     */
    public function setRfShowAgentNoteYn($rfShowAgentNoteYn)
    {
        $this->rfShowAgentNoteYn = $rfShowAgentNoteYn;

        return $this;
    }

    /**
     * Get rfShowAgentNoteYn
     *
     * @return boolean
     */
    public function getRfShowAgentNoteYn()
    {
        return $this->rfShowAgentNoteYn;
    }

    /**
     * Set rfShowAllocsYn
     *
     * @param boolean $rfShowAllocsYn
     *
     * @return RfDefault
     */
    public function setRfShowAllocsYn($rfShowAllocsYn)
    {
        $this->rfShowAllocsYn = $rfShowAllocsYn;

        return $this;
    }

    /**
     * Get rfShowAllocsYn
     *
     * @return boolean
     */
    public function getRfShowAllocsYn()
    {
        return $this->rfShowAllocsYn;
    }

    /**
     * Set rfPersonaCheckYn
     *
     * @param boolean $rfPersonaCheckYn
     *
     * @return RfDefault
     */
    public function setRfPersonaCheckYn($rfPersonaCheckYn)
    {
        $this->rfPersonaCheckYn = $rfPersonaCheckYn;

        return $this;
    }

    /**
     * Get rfPersonaCheckYn
     *
     * @return boolean
     */
    public function getRfPersonaCheckYn()
    {
        return $this->rfPersonaCheckYn;
    }

    /**
     * Set rfPersonaFirstYn
     *
     * @param boolean $rfPersonaFirstYn
     *
     * @return RfDefault
     */
    public function setRfPersonaFirstYn($rfPersonaFirstYn)
    {
        $this->rfPersonaFirstYn = $rfPersonaFirstYn;

        return $this;
    }

    /**
     * Get rfPersonaFirstYn
     *
     * @return boolean
     */
    public function getRfPersonaFirstYn()
    {
        return $this->rfPersonaFirstYn;
    }

    /**
     * Set rfPersonaFirstSoundexYn
     *
     * @param boolean $rfPersonaFirstSoundexYn
     *
     * @return RfDefault
     */
    public function setRfPersonaFirstSoundexYn($rfPersonaFirstSoundexYn)
    {
        $this->rfPersonaFirstSoundexYn = $rfPersonaFirstSoundexYn;

        return $this;
    }

    /**
     * Get rfPersonaFirstSoundexYn
     *
     * @return boolean
     */
    public function getRfPersonaFirstSoundexYn()
    {
        return $this->rfPersonaFirstSoundexYn;
    }

    /**
     * Set rfPersonaFirstExactYn
     *
     * @param boolean $rfPersonaFirstExactYn
     *
     * @return RfDefault
     */
    public function setRfPersonaFirstExactYn($rfPersonaFirstExactYn)
    {
        $this->rfPersonaFirstExactYn = $rfPersonaFirstExactYn;

        return $this;
    }

    /**
     * Get rfPersonaFirstExactYn
     *
     * @return boolean
     */
    public function getRfPersonaFirstExactYn()
    {
        return $this->rfPersonaFirstExactYn;
    }

    /**
     * Set rfPersonaFirstMatchYn
     *
     * @param boolean $rfPersonaFirstMatchYn
     *
     * @return RfDefault
     */
    public function setRfPersonaFirstMatchYn($rfPersonaFirstMatchYn)
    {
        $this->rfPersonaFirstMatchYn = $rfPersonaFirstMatchYn;

        return $this;
    }

    /**
     * Get rfPersonaFirstMatchYn
     *
     * @return boolean
     */
    public function getRfPersonaFirstMatchYn()
    {
        return $this->rfPersonaFirstMatchYn;
    }

    /**
     * Set rfPersonaFirstMatchLimit
     *
     * @param boolean $rfPersonaFirstMatchLimit
     *
     * @return RfDefault
     */
    public function setRfPersonaFirstMatchLimit($rfPersonaFirstMatchLimit)
    {
        $this->rfPersonaFirstMatchLimit = $rfPersonaFirstMatchLimit;

        return $this;
    }

    /**
     * Get rfPersonaFirstMatchLimit
     *
     * @return boolean
     */
    public function getRfPersonaFirstMatchLimit()
    {
        return $this->rfPersonaFirstMatchLimit;
    }

    /**
     * Set rfPersonaLastYn
     *
     * @param boolean $rfPersonaLastYn
     *
     * @return RfDefault
     */
    public function setRfPersonaLastYn($rfPersonaLastYn)
    {
        $this->rfPersonaLastYn = $rfPersonaLastYn;

        return $this;
    }

    /**
     * Get rfPersonaLastYn
     *
     * @return boolean
     */
    public function getRfPersonaLastYn()
    {
        return $this->rfPersonaLastYn;
    }

    /**
     * Set rfPersonaLastSoundexYn
     *
     * @param boolean $rfPersonaLastSoundexYn
     *
     * @return RfDefault
     */
    public function setRfPersonaLastSoundexYn($rfPersonaLastSoundexYn)
    {
        $this->rfPersonaLastSoundexYn = $rfPersonaLastSoundexYn;

        return $this;
    }

    /**
     * Get rfPersonaLastSoundexYn
     *
     * @return boolean
     */
    public function getRfPersonaLastSoundexYn()
    {
        return $this->rfPersonaLastSoundexYn;
    }

    /**
     * Set rfPersonaLastExactYn
     *
     * @param boolean $rfPersonaLastExactYn
     *
     * @return RfDefault
     */
    public function setRfPersonaLastExactYn($rfPersonaLastExactYn)
    {
        $this->rfPersonaLastExactYn = $rfPersonaLastExactYn;

        return $this;
    }

    /**
     * Get rfPersonaLastExactYn
     *
     * @return boolean
     */
    public function getRfPersonaLastExactYn()
    {
        return $this->rfPersonaLastExactYn;
    }

    /**
     * Set rfPersonaLastMatchYn
     *
     * @param boolean $rfPersonaLastMatchYn
     *
     * @return RfDefault
     */
    public function setRfPersonaLastMatchYn($rfPersonaLastMatchYn)
    {
        $this->rfPersonaLastMatchYn = $rfPersonaLastMatchYn;

        return $this;
    }

    /**
     * Get rfPersonaLastMatchYn
     *
     * @return boolean
     */
    public function getRfPersonaLastMatchYn()
    {
        return $this->rfPersonaLastMatchYn;
    }

    /**
     * Set rfPersonaLastMatchLimit
     *
     * @param boolean $rfPersonaLastMatchLimit
     *
     * @return RfDefault
     */
    public function setRfPersonaLastMatchLimit($rfPersonaLastMatchLimit)
    {
        $this->rfPersonaLastMatchLimit = $rfPersonaLastMatchLimit;

        return $this;
    }

    /**
     * Get rfPersonaLastMatchLimit
     *
     * @return boolean
     */
    public function getRfPersonaLastMatchLimit()
    {
        return $this->rfPersonaLastMatchLimit;
    }

    /**
     * Set rfPrnWebSite
     *
     * @param string $rfPrnWebSite
     *
     * @return RfDefault
     */
    public function setRfPrnWebSite($rfPrnWebSite)
    {
        $this->rfPrnWebSite = $rfPrnWebSite;

        return $this;
    }

    /**
     * Get rfPrnWebSite
     *
     * @return string
     */
    public function getRfPrnWebSite()
    {
        return $this->rfPrnWebSite;
    }

    /**
     * Set rfResCreateExpiryMins
     *
     * @param integer $rfResCreateExpiryMins
     *
     * @return RfDefault
     */
    public function setRfResCreateExpiryMins($rfResCreateExpiryMins)
    {
        $this->rfResCreateExpiryMins = $rfResCreateExpiryMins;

        return $this;
    }

    /**
     * Get rfResCreateExpiryMins
     *
     * @return integer
     */
    public function getRfResCreateExpiryMins()
    {
        return $this->rfResCreateExpiryMins;
    }

    /**
     * Set rfResCreateExpiryInternal
     *
     * @param integer $rfResCreateExpiryInternal
     *
     * @return RfDefault
     */
    public function setRfResCreateExpiryInternal($rfResCreateExpiryInternal)
    {
        $this->rfResCreateExpiryInternal = $rfResCreateExpiryInternal;

        return $this;
    }

    /**
     * Get rfResCreateExpiryInternal
     *
     * @return integer
     */
    public function getRfResCreateExpiryInternal()
    {
        return $this->rfResCreateExpiryInternal;
    }

    /**
     * Set rfPaymentGatewayExpiryMins
     *
     * @param integer $rfPaymentGatewayExpiryMins
     *
     * @return RfDefault
     */
    public function setRfPaymentGatewayExpiryMins($rfPaymentGatewayExpiryMins)
    {
        $this->rfPaymentGatewayExpiryMins = $rfPaymentGatewayExpiryMins;

        return $this;
    }

    /**
     * Get rfPaymentGatewayExpiryMins
     *
     * @return integer
     */
    public function getRfPaymentGatewayExpiryMins()
    {
        return $this->rfPaymentGatewayExpiryMins;
    }

    /**
     * Set rfPaymentGatewayEmailYn
     *
     * @param boolean $rfPaymentGatewayEmailYn
     *
     * @return RfDefault
     */
    public function setRfPaymentGatewayEmailYn($rfPaymentGatewayEmailYn)
    {
        $this->rfPaymentGatewayEmailYn = $rfPaymentGatewayEmailYn;

        return $this;
    }

    /**
     * Get rfPaymentGatewayEmailYn
     *
     * @return boolean
     */
    public function getRfPaymentGatewayEmailYn()
    {
        return $this->rfPaymentGatewayEmailYn;
    }

    /**
     * Set rfPerStayYn
     *
     * @param boolean $rfPerStayYn
     *
     * @return RfDefault
     */
    public function setRfPerStayYn($rfPerStayYn)
    {
        $this->rfPerStayYn = $rfPerStayYn;

        return $this;
    }

    /**
     * Get rfPerStayYn
     *
     * @return boolean
     */
    public function getRfPerStayYn()
    {
        return $this->rfPerStayYn;
    }

    /**
     * Set rfPerStayAutoYn
     *
     * @param boolean $rfPerStayAutoYn
     *
     * @return RfDefault
     */
    public function setRfPerStayAutoYn($rfPerStayAutoYn)
    {
        $this->rfPerStayAutoYn = $rfPerStayAutoYn;

        return $this;
    }

    /**
     * Get rfPerStayAutoYn
     *
     * @return boolean
     */
    public function getRfPerStayAutoYn()
    {
        return $this->rfPerStayAutoYn;
    }

    /**
     * Set rfPrincipalId
     *
     * @param string $rfPrincipalId
     *
     * @return RfDefault
     */
    public function setRfPrincipalId($rfPrincipalId)
    {
        $this->rfPrincipalId = $rfPrincipalId;

        return $this;
    }

    /**
     * Get rfPrincipalId
     *
     * @return string
     */
    public function getRfPrincipalId()
    {
        return $this->rfPrincipalId;
    }

    /**
     * Set rfResOfficeId
     *
     * @param string $rfResOfficeId
     *
     * @return RfDefault
     */
    public function setRfResOfficeId($rfResOfficeId)
    {
        $this->rfResOfficeId = $rfResOfficeId;

        return $this;
    }

    /**
     * Get rfResOfficeId
     *
     * @return string
     */
    public function getRfResOfficeId()
    {
        return $this->rfResOfficeId;
    }

    /**
     * Set rfStatutoryLabel1
     *
     * @param string $rfStatutoryLabel1
     *
     * @return RfDefault
     */
    public function setRfStatutoryLabel1($rfStatutoryLabel1)
    {
        $this->rfStatutoryLabel1 = $rfStatutoryLabel1;

        return $this;
    }

    /**
     * Get rfStatutoryLabel1
     *
     * @return string
     */
    public function getRfStatutoryLabel1()
    {
        return $this->rfStatutoryLabel1;
    }

    /**
     * Set rfStatutoryLabel2
     *
     * @param string $rfStatutoryLabel2
     *
     * @return RfDefault
     */
    public function setRfStatutoryLabel2($rfStatutoryLabel2)
    {
        $this->rfStatutoryLabel2 = $rfStatutoryLabel2;

        return $this;
    }

    /**
     * Get rfStatutoryLabel2
     *
     * @return string
     */
    public function getRfStatutoryLabel2()
    {
        return $this->rfStatutoryLabel2;
    }

    /**
     * Set rfStatutoryLabel3
     *
     * @param string $rfStatutoryLabel3
     *
     * @return RfDefault
     */
    public function setRfStatutoryLabel3($rfStatutoryLabel3)
    {
        $this->rfStatutoryLabel3 = $rfStatutoryLabel3;

        return $this;
    }

    /**
     * Get rfStatutoryLabel3
     *
     * @return string
     */
    public function getRfStatutoryLabel3()
    {
        return $this->rfStatutoryLabel3;
    }

    /**
     * Set rfGuestIndemnityMessage
     *
     * @param string $rfGuestIndemnityMessage
     *
     * @return RfDefault
     */
    public function setRfGuestIndemnityMessage($rfGuestIndemnityMessage)
    {
        $this->rfGuestIndemnityMessage = $rfGuestIndemnityMessage;

        return $this;
    }

    /**
     * Get rfGuestIndemnityMessage
     *
     * @return string
     */
    public function getRfGuestIndemnityMessage()
    {
        return $this->rfGuestIndemnityMessage;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfDefault
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfDefaultTrfYn
     *
     * @param boolean $rfDefaultTrfYn
     *
     * @return RfDefault
     */
    public function setRfDefaultTrfYn($rfDefaultTrfYn)
    {
        $this->rfDefaultTrfYn = $rfDefaultTrfYn;

        return $this;
    }

    /**
     * Get rfDefaultTrfYn
     *
     * @return boolean
     */
    public function getRfDefaultTrfYn()
    {
        return $this->rfDefaultTrfYn;
    }
}
