<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfDefaultRate
 *
 * @ORM\Table(name="rf_default_rate", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_default_rate_trf_yn", columns={"rf_default_rate_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfDefaultRate
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_default_rate_id", type="string", length=36, nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfDefaultRateId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_default_rate_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfDefaultRateTrfYn;



    /**
     * Get rfDefaultRateId
     *
     * @return string
     */
    public function getRfDefaultRateId()
    {
        return $this->rfDefaultRateId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfDefaultRate
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfDefaultRateTrfYn
     *
     * @param boolean $rfDefaultRateTrfYn
     *
     * @return RfDefaultRate
     */
    public function setRfDefaultRateTrfYn($rfDefaultRateTrfYn)
    {
        $this->rfDefaultRateTrfYn = $rfDefaultRateTrfYn;

        return $this;
    }

    /**
     * Get rfDefaultRateTrfYn
     *
     * @return boolean
     */
    public function getRfDefaultRateTrfYn()
    {
        return $this->rfDefaultRateTrfYn;
    }
}
