<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfExchangeRate
 *
 * @ORM\Table(name="rf_exchange_rate", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_exchange_rate_trf_yn", columns={"rf_exchange_rate_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rf_exch_date", columns={"rf_exch_date"})})
 * @ORM\Entity
 */
class RfExchangeRate
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_exchange_rate_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfExchangeRateIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_exchange_rate_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rfExchangeRateDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_exchange_rate_id", type="integer", nullable=false)
     */
    private $rfExchangeRateId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rf_exch_date", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rfExchDate;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_exch_rate", type="decimal", precision=16, scale=6, nullable=false, options={"default"="0.000000"})
     */
    private $rfExchRate;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_exch_curr_from_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfExchCurrFromId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_exch_curr_to_id", type="string", length=36, nullable=true, options={"default"="0"})
     */
    private $rfExchCurrToId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_exchange_rate_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfExchangeRateTrfYn;



    /**
     * Get rfExchangeRateIx
     *
     * @return string
     */
    public function getRfExchangeRateIx()
    {
        return $this->rfExchangeRateIx;
    }

    /**
     * Set rfExchangeRateDb
     *
     * @param string $rfExchangeRateDb
     *
     * @return RfExchangeRate
     */
    public function setRfExchangeRateDb($rfExchangeRateDb)
    {
        $this->rfExchangeRateDb = $rfExchangeRateDb;

        return $this;
    }

    /**
     * Get rfExchangeRateDb
     *
     * @return string
     */
    public function getRfExchangeRateDb()
    {
        return $this->rfExchangeRateDb;
    }

    /**
     * Set rfExchangeRateId
     *
     * @param integer $rfExchangeRateId
     *
     * @return RfExchangeRate
     */
    public function setRfExchangeRateId($rfExchangeRateId)
    {
        $this->rfExchangeRateId = $rfExchangeRateId;

        return $this;
    }

    /**
     * Get rfExchangeRateId
     *
     * @return integer
     */
    public function getRfExchangeRateId()
    {
        return $this->rfExchangeRateId;
    }

    /**
     * Set rfExchDate
     *
     * @param \DateTime $rfExchDate
     *
     * @return RfExchangeRate
     */
    public function setRfExchDate($rfExchDate)
    {
        $this->rfExchDate = $rfExchDate;

        return $this;
    }

    /**
     * Get rfExchDate
     *
     * @return \DateTime
     */
    public function getRfExchDate()
    {
        return $this->rfExchDate;
    }

    /**
     * Set rfExchRate
     *
     * @param string $rfExchRate
     *
     * @return RfExchangeRate
     */
    public function setRfExchRate($rfExchRate)
    {
        $this->rfExchRate = $rfExchRate;

        return $this;
    }

    /**
     * Get rfExchRate
     *
     * @return string
     */
    public function getRfExchRate()
    {
        return $this->rfExchRate;
    }

    /**
     * Set rfExchCurrFromId
     *
     * @param string $rfExchCurrFromId
     *
     * @return RfExchangeRate
     */
    public function setRfExchCurrFromId($rfExchCurrFromId)
    {
        $this->rfExchCurrFromId = $rfExchCurrFromId;

        return $this;
    }

    /**
     * Get rfExchCurrFromId
     *
     * @return string
     */
    public function getRfExchCurrFromId()
    {
        return $this->rfExchCurrFromId;
    }

    /**
     * Set rfExchCurrToId
     *
     * @param string $rfExchCurrToId
     *
     * @return RfExchangeRate
     */
    public function setRfExchCurrToId($rfExchCurrToId)
    {
        $this->rfExchCurrToId = $rfExchCurrToId;

        return $this;
    }

    /**
     * Get rfExchCurrToId
     *
     * @return string
     */
    public function getRfExchCurrToId()
    {
        return $this->rfExchCurrToId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfExchangeRate
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfExchangeRateTrfYn
     *
     * @param boolean $rfExchangeRateTrfYn
     *
     * @return RfExchangeRate
     */
    public function setRfExchangeRateTrfYn($rfExchangeRateTrfYn)
    {
        $this->rfExchangeRateTrfYn = $rfExchangeRateTrfYn;

        return $this;
    }

    /**
     * Get rfExchangeRateTrfYn
     *
     * @return boolean
     */
    public function getRfExchangeRateTrfYn()
    {
        return $this->rfExchangeRateTrfYn;
    }
}
