<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfGuestField
 *
 * @ORM\Table(name="rf_guest_field")
 * @ORM\Entity
 */
class RfGuestField
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_guest_field_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfGuestFieldIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_guest_field_name", type="string", length=50, nullable=false)
     */
    private $rfGuestFieldName;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_guest_field_compulsory_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfGuestFieldCompulsoryYn;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_guest_field_sys_code", type="integer", length=4, nullable=false, options={"default"="0"})
     */
    private $rfGuestFieldSysCode;



    /**
     * Get rfGuestFieldIx
     *
     * @return string
     */
    public function getRfGuestFieldIx()
    {
        return $this->rfGuestFieldIx;
    }

    /**
     * Get rfGuestFieldName
     *
     * @return string
     */
    public function getRfGuestFieldName()
    {
        return $this->rfGuestFieldName;
    }

    /**
     * Set rfGuestFieldName
     *
     * @param string $rfGuestFieldName
     *
     * @return RfGuestField
     */
    public function setFfGuestFieldName($rfGuestFieldName)
    {
        $this->rfGuestFieldName = $rfGuestFieldName;

        return $this;
    }

    /**
     * Get rfGuestFieldCompulsoryYn
     *
     * @return boolean
     */
    public function getRfGuestFieldCompulsoryYn()
    {
        return $this->rfGuestFieldCompulsoryYn;
    }
    
    /**
     * Set rfGuestFieldCompulsoryYn
     *
     * @param string $rfGuestFieldName
     *
     * @return RfGuestField
     */
    public function setRfGuestFieldCompulsoryYn($rfGuestFieldCompulsoryYn)
    {
        $this->rfGuestFieldCompulsoryYn = $rfGuestFieldCompulsoryYn;

        return $this;
    }

    /**
     * Get rfGuestFieldSysCode
     *
     * @return integer
     */
    public function getRfGuestFieldSysCode()
    {
        return $this->rfGuestFieldSysCode;
    }

    /**
     * Set rfGuestFieldSysCode
     *
     * @param integer $rfGuestFieldSysCode
     *
     * @return RfGuestField
     */
    public function setRfGuestFieldSysCode($rfGuestFieldSysCode)
    {
        $this->rfGuestFieldSysCode = $rfGuestFieldSysCode;

        return $this;
    }

}

