<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfGuestType
 *
 * @ORM\Table(name="rf_guest_type", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_guest_type_trf_yn", columns={"rf_guest_type_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="rf_guest_type_name", columns={"rf_guest_type_name"})})
 * @ORM\Entity
 */
class RfGuestType
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_guest_type_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfGuestTypeIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_guest_type_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfGuestTypeDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_guest_type_id", type="integer", nullable=true)
     */
    private $rfGuestTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_guest_type_name", type="string", length=20, nullable=false, options={"default"=""})
     */
    private $rfGuestTypeName;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_guest_type_abbrv", type="string", length=4, nullable=false, options={"default"=""})
     */
    private $rfGuestTypeAbbrv;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_guest_type_desc", type="text", length=65535, nullable=false)
     */
    private $rfGuestTypeDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_guest_type_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfGuestTypeInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_guest_type_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfGuestTypeTrfYn;



    /**
     * Get rfGuestTypeIx
     *
     * @return string
     */
    public function getRfGuestTypeIx()
    {
        return $this->rfGuestTypeIx;
    }

    /**
     * Set rfGuestTypeDb
     *
     * @param string $rfGuestTypeDb
     *
     * @return RfGuestType
     */
    public function setRfGuestTypeDb($rfGuestTypeDb)
    {
        $this->rfGuestTypeDb = $rfGuestTypeDb;

        return $this;
    }

    /**
     * Get rfGuestTypeDb
     *
     * @return string
     */
    public function getRfGuestTypeDb()
    {
        return $this->rfGuestTypeDb;
    }

    /**
     * Set rfGuestTypeId
     *
     * @param integer $rfGuestTypeId
     *
     * @return RfGuestType
     */
    public function setRfGuestTypeId($rfGuestTypeId)
    {
        $this->rfGuestTypeId = $rfGuestTypeId;

        return $this;
    }

    /**
     * Get rfGuestTypeId
     *
     * @return integer
     */
    public function getRfGuestTypeId()
    {
        return $this->rfGuestTypeId;
    }

    /**
     * Set rfGuestTypeName
     *
     * @param string $rfGuestTypeName
     *
     * @return RfGuestType
     */
    public function setRfGuestTypeName($rfGuestTypeName)
    {
        $this->rfGuestTypeName = $rfGuestTypeName;

        return $this;
    }

    /**
     * Get rfGuestTypeName
     *
     * @return string
     */
    public function getRfGuestTypeName()
    {
        return $this->rfGuestTypeName;
    }

    /**
     * Set rfGuestTypeAbbrv
     *
     * @param string $rfGuestTypeAbbrv
     *
     * @return RfGuestType
     */
    public function setRfGuestTypeAbbrv($rfGuestTypeAbbrv)
    {
        $this->rfGuestTypeAbbrv = $rfGuestTypeAbbrv;

        return $this;
    }

    /**
     * Get rfGuestTypeAbbrv
     *
     * @return string
     */
    public function getRfGuestTypeAbbrv()
    {
        return $this->rfGuestTypeAbbrv;
    }

    /**
     * Set rfGuestTypeDesc
     *
     * @param string $rfGuestTypeDesc
     *
     * @return RfGuestType
     */
    public function setRfGuestTypeDesc($rfGuestTypeDesc)
    {
        $this->rfGuestTypeDesc = $rfGuestTypeDesc;

        return $this;
    }

    /**
     * Get rfGuestTypeDesc
     *
     * @return string
     */
    public function getRfGuestTypeDesc()
    {
        return $this->rfGuestTypeDesc;
    }

    /**
     * Set rfGuestTypeInactiveYn
     *
     * @param boolean $rfGuestTypeInactiveYn
     *
     * @return RfGuestType
     */
    public function setRfGuestTypeInactiveYn($rfGuestTypeInactiveYn)
    {
        $this->rfGuestTypeInactiveYn = $rfGuestTypeInactiveYn;

        return $this;
    }

    /**
     * Get rfGuestTypeInactiveYn
     *
     * @return boolean
     */
    public function getRfGuestTypeInactiveYn()
    {
        return $this->rfGuestTypeInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfGuestType
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfGuestTypeTrfYn
     *
     * @param boolean $rfGuestTypeTrfYn
     *
     * @return RfGuestType
     */
    public function setRfGuestTypeTrfYn($rfGuestTypeTrfYn)
    {
        $this->rfGuestTypeTrfYn = $rfGuestTypeTrfYn;

        return $this;
    }

    /**
     * Get rfGuestTypeTrfYn
     *
     * @return boolean
     */
    public function getRfGuestTypeTrfYn()
    {
        return $this->rfGuestTypeTrfYn;
    }
}
