<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfLinkType
 *
 * @ORM\Table(name="rf_link_type", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_link_type_trf_yn", columns={"rf_link_type_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfLinkType
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_link_type_db", type="string", length=2, nullable=false, options={"default"="0", "fixed"="true"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfLinkTypeDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_link_type_id", type="integer", nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfLinkTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_link_type_desc", type="text", length=65535, nullable=true)
     */
    private $rfLinkTypeDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_link_type_lock_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfLinkTypeLockYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_link_type_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfLinkTypeTrfYn;



    /**
     * Set rfLinkTypeDb
     *
     * @param string $rfLinkTypeDb
     *
     * @return RfLinkType
     */
    public function setRfLinkTypeDb($rfLinkTypeDb)
    {
        $this->rfLinkTypeDb = $rfLinkTypeDb;

        return $this;
    }

    /**
     * Get rfLinkTypeDb
     *
     * @return string
     */
    public function getRfLinkTypeDb()
    {
        return $this->rfLinkTypeDb;
    }

    /**
     * Set rfLinkTypeId
     *
     * @param integer $rfLinkTypeId
     *
     * @return RfLinkType
     */
    public function setRfLinkTypeId($rfLinkTypeId)
    {
        $this->rfLinkTypeId = $rfLinkTypeId;

        return $this;
    }

    /**
     * Get rfLinkTypeId
     *
     * @return integer
     */
    public function getRfLinkTypeId()
    {
        return $this->rfLinkTypeId;
    }

    /**
     * Set rfLinkTypeDesc
     *
     * @param string $rfLinkTypeDesc
     *
     * @return RfLinkType
     */
    public function setRfLinkTypeDesc($rfLinkTypeDesc)
    {
        $this->rfLinkTypeDesc = $rfLinkTypeDesc;

        return $this;
    }

    /**
     * Get rfLinkTypeDesc
     *
     * @return string
     */
    public function getRfLinkTypeDesc()
    {
        return $this->rfLinkTypeDesc;
    }

    /**
     * Set rfLinkTypeLockYn
     *
     * @param boolean $rfLinkTypeLockYn
     *
     * @return RfLinkType
     */
    public function setRfLinkTypeLockYn($rfLinkTypeLockYn)
    {
        $this->rfLinkTypeLockYn = $rfLinkTypeLockYn;

        return $this;
    }

    /**
     * Get rfLinkTypeLockYn
     *
     * @return boolean
     */
    public function getRfLinkTypeLockYn()
    {
        return $this->rfLinkTypeLockYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfLinkType
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfLinkTypeTrfYn
     *
     * @param boolean $rfLinkTypeTrfYn
     *
     * @return RfLinkType
     */
    public function setRfLinkTypeTrfYn($rfLinkTypeTrfYn)
    {
        $this->rfLinkTypeTrfYn = $rfLinkTypeTrfYn;

        return $this;
    }

    /**
     * Get rfLinkTypeTrfYn
     *
     * @return boolean
     */
    public function getRfLinkTypeTrfYn()
    {
        return $this->rfLinkTypeTrfYn;
    }
}
