<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfMail
 *
 * @ORM\Table(name="rf_mail", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_mail_trf_yn", columns={"rf_mail_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfMail
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_mail_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfMailDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_mail_id", type="integer", nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfMailId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_mail_desc", type="string", length=50, nullable=true)
     */
    private $rfMailDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_mail_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfMailTrfYn;



    /**
     * Set rfMailDb
     *
     * @param string $rfMailDb
     *
     * @return RfMail
     */
    public function setRfMailDb($rfMailDb)
    {
        $this->rfMailDb = $rfMailDb;

        return $this;
    }

    /**
     * Get rfMailDb
     *
     * @return string
     */
    public function getRfMailDb()
    {
        return $this->rfMailDb;
    }

    /**
     * Set rfMailId
     *
     * @param integer $rfMailId
     *
     * @return RfMail
     */
    public function setRfMailId($rfMailId)
    {
        $this->rfMailId = $rfMailId;

        return $this;
    }

    /**
     * Get rfMailId
     *
     * @return integer
     */
    public function getRfMailId()
    {
        return $this->rfMailId;
    }

    /**
     * Set rfMailDesc
     *
     * @param string $rfMailDesc
     *
     * @return RfMail
     */
    public function setRfMailDesc($rfMailDesc)
    {
        $this->rfMailDesc = $rfMailDesc;

        return $this;
    }

    /**
     * Get rfMailDesc
     *
     * @return string
     */
    public function getRfMailDesc()
    {
        return $this->rfMailDesc;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfMail
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfMailTrfYn
     *
     * @param boolean $rfMailTrfYn
     *
     * @return RfMail
     */
    public function setRfMailTrfYn($rfMailTrfYn)
    {
        $this->rfMailTrfYn = $rfMailTrfYn;

        return $this;
    }

    /**
     * Get rfMailTrfYn
     *
     * @return boolean
     */
    public function getRfMailTrfYn()
    {
        return $this->rfMailTrfYn;
    }
}
