<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfMessage
 *
 * @ORM\Table(name="rf_message", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"})
 * @ORM\Entity
 */
class RfMessage
{
    /**
     * @var integer
     *
     * @ORM\Column(name="rf_message_id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue
     */
    private $rfMessageId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_msg_text", type="string", length=150, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfMsgText = '';



    /**
     * Set rfMessageId
     *
     * @param integer $rfMessageId
     *
     * @return RfMessage
     */
    public function setRfMessageId($rfMessageId)
    {
        $this->rfMessageId = $rfMessageId;

        return $this;
    }

    /**
     * Get rfMessageId
     *
     * @return integer
     */
    public function getRfMessageId()
    {
        return $this->rfMessageId;
    }

    /**
     * Set rfMsgText
     *
     * @param string $rfMsgText
     *
     * @return RfMessage
     */
    public function setRfMsgText($rfMsgText)
    {
        $this->rfMsgText = $rfMsgText;

        return $this;
    }

    /**
     * Get rfMsgText
     *
     * @return string
     */
    public function getRfMsgText()
    {
        return $this->rfMsgText;
    }
}
