<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfNameSuffix
 *
 * @ORM\Table(name="rf_name_suffix", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_name_suffix_trf_yn", columns={"rf_name_suffix_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfNameSuffix
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_name_suffix_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfNameSuffixIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_name_suffix_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfNameSuffixDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_name_suffix_id", type="integer", nullable=false)
     */
    private $rfNameSuffixId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_suffix_desc", type="string", length=10, nullable=true)
     */
    private $rfSuffixDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_suffix_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfSuffixInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_name_suffix_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfNameSuffixTrfYn;



    /**
     * Get rfNameSuffixIx
     *
     * @return string
     */
    public function getRfNameSuffixIx()
    {
        return $this->rfNameSuffixIx;
    }

    /**
     * Set rfNameSuffixDb
     *
     * @param string $rfNameSuffixDb
     *
     * @return RfNameSuffix
     */
    public function setRfNameSuffixDb($rfNameSuffixDb)
    {
        $this->rfNameSuffixDb = $rfNameSuffixDb;

        return $this;
    }

    /**
     * Get rfNameSuffixDb
     *
     * @return string
     */
    public function getRfNameSuffixDb()
    {
        return $this->rfNameSuffixDb;
    }

    /**
     * Set rfNameSuffixId
     *
     * @param integer $rfNameSuffixId
     *
     * @return RfNameSuffix
     */
    public function setRfNameSuffixId($rfNameSuffixId)
    {
        $this->rfNameSuffixId = $rfNameSuffixId;

        return $this;
    }

    /**
     * Get rfNameSuffixId
     *
     * @return integer
     */
    public function getRfNameSuffixId()
    {
        return $this->rfNameSuffixId;
    }

    /**
     * Set rfSuffixDesc
     *
     * @param string $rfSuffixDesc
     *
     * @return RfNameSuffix
     */
    public function setRfSuffixDesc($rfSuffixDesc)
    {
        $this->rfSuffixDesc = $rfSuffixDesc;

        return $this;
    }

    /**
     * Get rfSuffixDesc
     *
     * @return string
     */
    public function getRfSuffixDesc()
    {
        return $this->rfSuffixDesc;
    }

    /**
     * Set rfSuffixInactiveYn
     *
     * @param boolean $rfSuffixInactiveYn
     *
     * @return RfNameSuffix
     */
    public function setRfSuffixInactiveYn($rfSuffixInactiveYn)
    {
        $this->rfSuffixInactiveYn = $rfSuffixInactiveYn;

        return $this;
    }

    /**
     * Get rfSuffixInactiveYn
     *
     * @return boolean
     */
    public function getRfSuffixInactiveYn()
    {
        return $this->rfSuffixInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfNameSuffix
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfNameSuffixTrfYn
     *
     * @param boolean $rfNameSuffixTrfYn
     *
     * @return RfNameSuffix
     */
    public function setRfNameSuffixTrfYn($rfNameSuffixTrfYn)
    {
        $this->rfNameSuffixTrfYn = $rfNameSuffixTrfYn;

        return $this;
    }

    /**
     * Get rfNameSuffixTrfYn
     *
     * @return boolean
     */
    public function getRfNameSuffixTrfYn()
    {
        return $this->rfNameSuffixTrfYn;
    }
}
