<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfNote
 *
 * @ORM\Table(name="rf_note", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_note_trf_yn", columns={"rf_note_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})}, uniqueConstraints={@ORM\UniqueConstraint(name="rf_note_desc", columns={"rf_note_desc"})})
 * @ORM\Entity
 */
class RfNote
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfNoteIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rfNoteDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_note_id", type="integer", nullable=true)
     */
    private $rfNoteId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_desc", type="string", length=40, nullable=true)
     */
    private $rfNoteDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_external", type="text", length=65535, nullable=false)
     */
    private $rfNoteExternal;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_internal", type="text", length=65535, nullable=false)
     */
    private $rfNoteInternal;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_xref", type="string", length=10, nullable=false, options={"default"=""})
     */
    private $rfNoteXref;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_note_guest_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfNoteGuestYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_note_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfNoteTrfYn;



    /**
     * Get rfNoteIx
     *
     * @return string
     */
    public function getRfNoteIx()
    {
        return $this->rfNoteIx;
    }

    /**
     * Set rfNoteDb
     *
     * @param string $rfNoteDb
     *
     * @return RfNote
     */
    public function setRfNoteDb($rfNoteDb)
    {
        $this->rfNoteDb = $rfNoteDb;

        return $this;
    }

    /**
     * Get rfNoteDb
     *
     * @return string
     */
    public function getRfNoteDb()
    {
        return $this->rfNoteDb;
    }

    /**
     * Set rfNoteId
     *
     * @param integer $rfNoteId
     *
     * @return RfNote
     */
    public function setRfNoteId($rfNoteId)
    {
        $this->rfNoteId = $rfNoteId;

        return $this;
    }

    /**
     * Get rfNoteId
     *
     * @return integer
     */
    public function getRfNoteId()
    {
        return $this->rfNoteId;
    }

    /**
     * Set rfNoteDesc
     *
     * @param string $rfNoteDesc
     *
     * @return RfNote
     */
    public function setRfNoteDesc($rfNoteDesc)
    {
        $this->rfNoteDesc = $rfNoteDesc;

        return $this;
    }

    /**
     * Get rfNoteDesc
     *
     * @return string
     */
    public function getRfNoteDesc()
    {
        return $this->rfNoteDesc;
    }

    /**
     * Set rfNoteExternal
     *
     * @param string $rfNoteExternal
     *
     * @return RfNote
     */
    public function setRfNoteExternal($rfNoteExternal)
    {
        $this->rfNoteExternal = $rfNoteExternal;

        return $this;
    }

    /**
     * Get rfNoteExternal
     *
     * @return string
     */
    public function getRfNoteExternal()
    {
        return $this->rfNoteExternal;
    }

    /**
     * Set rfNoteInternal
     *
     * @param string $rfNoteInternal
     *
     * @return RfNote
     */
    public function setRfNoteInternal($rfNoteInternal)
    {
        $this->rfNoteInternal = $rfNoteInternal;

        return $this;
    }

    /**
     * Get rfNoteInternal
     *
     * @return string
     */
    public function getRfNoteInternal()
    {
        return $this->rfNoteInternal;
    }

    /**
     * Set rfNoteXref
     *
     * @param string $rfNoteXref
     *
     * @return RfNote
     */
    public function setRfNoteXref($rfNoteXref)
    {
        $this->rfNoteXref = $rfNoteXref;

        return $this;
    }

    /**
     * Get rfNoteXref
     *
     * @return string
     */
    public function getRfNoteXref()
    {
        return $this->rfNoteXref;
    }

    /**
     * Set rfNoteGuestYn
     *
     * @param boolean $rfNoteGuestYn
     *
     * @return RfNote
     */
    public function setRfNoteGuestYn($rfNoteGuestYn)
    {
        $this->rfNoteGuestYn = $rfNoteGuestYn;

        return $this;
    }

    /**
     * Get rfNoteGuestYn
     *
     * @return boolean
     */
    public function getRfNoteGuestYn()
    {
        return $this->rfNoteGuestYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfNote
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfNoteTrfYn
     *
     * @param boolean $rfNoteTrfYn
     *
     * @return RfNote
     */
    public function setRfNoteTrfYn($rfNoteTrfYn)
    {
        $this->rfNoteTrfYn = $rfNoteTrfYn;

        return $this;
    }

    /**
     * Get rfNoteTrfYn
     *
     * @return boolean
     */
    public function getRfNoteTrfYn()
    {
        return $this->rfNoteTrfYn;
    }
}
