<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfNoteCustItem
 *
 * @ORM\Table(name="rf_note_cust_item", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_note_cust_item_trf_yn", columns={"rf_note_cust_item_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rf_note_custom_id", columns={"rf_note_custom_id"})})
 * @ORM\Entity
 */
class RfNoteCustItem
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_cust_item_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfNoteCustItemIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_cust_item_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfNoteCustItemDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_note_cust_item_id", type="integer", nullable=false)
     */
    private $rfNoteCustItemId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_cust_item_path", type="string", length=100, nullable=true)
     */
    private $rfNoteCustItemPath;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_note_cust_item_seq", type="boolean", nullable=true)
     */
    private $rfNoteCustItemSeq;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_cust_item_text", type="text", length=65535, nullable=true)
     */
    private $rfNoteCustItemText;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_note_cust_pg_brk_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfNoteCustPgBrkYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_custom_id", type="string", length=36, nullable=true)
     */
    private $rfNoteCustomId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_note_cust_item_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfNoteCustItemTrfYn;



    /**
     * Get rfNoteCustItemIx
     *
     * @return string
     */
    public function getRfNoteCustItemIx()
    {
        return $this->rfNoteCustItemIx;
    }

    /**
     * Set rfNoteCustItemDb
     *
     * @param string $rfNoteCustItemDb
     *
     * @return RfNoteCustItem
     */
    public function setRfNoteCustItemDb($rfNoteCustItemDb)
    {
        $this->rfNoteCustItemDb = $rfNoteCustItemDb;

        return $this;
    }

    /**
     * Get rfNoteCustItemDb
     *
     * @return string
     */
    public function getRfNoteCustItemDb()
    {
        return $this->rfNoteCustItemDb;
    }

    /**
     * Set rfNoteCustItemId
     *
     * @param integer $rfNoteCustItemId
     *
     * @return RfNoteCustItem
     */
    public function setRfNoteCustItemId($rfNoteCustItemId)
    {
        $this->rfNoteCustItemId = $rfNoteCustItemId;

        return $this;
    }

    /**
     * Get rfNoteCustItemId
     *
     * @return integer
     */
    public function getRfNoteCustItemId()
    {
        return $this->rfNoteCustItemId;
    }

    /**
     * Set rfNoteCustItemPath
     *
     * @param string $rfNoteCustItemPath
     *
     * @return RfNoteCustItem
     */
    public function setRfNoteCustItemPath($rfNoteCustItemPath)
    {
        $this->rfNoteCustItemPath = $rfNoteCustItemPath;

        return $this;
    }

    /**
     * Get rfNoteCustItemPath
     *
     * @return string
     */
    public function getRfNoteCustItemPath()
    {
        return $this->rfNoteCustItemPath;
    }

    /**
     * Set rfNoteCustItemSeq
     *
     * @param boolean $rfNoteCustItemSeq
     *
     * @return RfNoteCustItem
     */
    public function setRfNoteCustItemSeq($rfNoteCustItemSeq)
    {
        $this->rfNoteCustItemSeq = $rfNoteCustItemSeq;

        return $this;
    }

    /**
     * Get rfNoteCustItemSeq
     *
     * @return boolean
     */
    public function getRfNoteCustItemSeq()
    {
        return $this->rfNoteCustItemSeq;
    }

    /**
     * Set rfNoteCustItemText
     *
     * @param string $rfNoteCustItemText
     *
     * @return RfNoteCustItem
     */
    public function setRfNoteCustItemText($rfNoteCustItemText)
    {
        $this->rfNoteCustItemText = $rfNoteCustItemText;

        return $this;
    }

    /**
     * Get rfNoteCustItemText
     *
     * @return string
     */
    public function getRfNoteCustItemText()
    {
        return $this->rfNoteCustItemText;
    }

    /**
     * Set rfNoteCustPgBrkYn
     *
     * @param boolean $rfNoteCustPgBrkYn
     *
     * @return RfNoteCustItem
     */
    public function setRfNoteCustPgBrkYn($rfNoteCustPgBrkYn)
    {
        $this->rfNoteCustPgBrkYn = $rfNoteCustPgBrkYn;

        return $this;
    }

    /**
     * Get rfNoteCustPgBrkYn
     *
     * @return boolean
     */
    public function getRfNoteCustPgBrkYn()
    {
        return $this->rfNoteCustPgBrkYn;
    }

    /**
     * Set rfNoteCustomId
     *
     * @param string $rfNoteCustomId
     *
     * @return RfNoteCustItem
     */
    public function setRfNoteCustomId($rfNoteCustomId)
    {
        $this->rfNoteCustomId = $rfNoteCustomId;

        return $this;
    }

    /**
     * Get rfNoteCustomId
     *
     * @return string
     */
    public function getRfNoteCustomId()
    {
        return $this->rfNoteCustomId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfNoteCustItem
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfNoteCustItemTrfYn
     *
     * @param boolean $rfNoteCustItemTrfYn
     *
     * @return RfNoteCustItem
     */
    public function setRfNoteCustItemTrfYn($rfNoteCustItemTrfYn)
    {
        $this->rfNoteCustItemTrfYn = $rfNoteCustItemTrfYn;

        return $this;
    }

    /**
     * Get rfNoteCustItemTrfYn
     *
     * @return boolean
     */
    public function getRfNoteCustItemTrfYn()
    {
        return $this->rfNoteCustItemTrfYn;
    }
}
