<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfNoteCustom
 *
 * @ORM\Table(name="rf_note_custom", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_note_custom_trf_yn", columns={"rf_note_custom_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfNoteCustom
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_custom_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfNoteCustomIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_custom_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfNoteCustomDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_note_custom_id", type="integer", nullable=false)
     */
    private $rfNoteCustomId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_custom_desc", type="string", length=30, nullable=true)
     */
    private $rfNoteCustomDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_note_custom_hdg", type="string", length=30, nullable=true)
     */
    private $rfNoteCustomHdg;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_note_custom_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfNoteCustomTrfYn;



    /**
     * Get rfNoteCustomIx
     *
     * @return string
     */
    public function getRfNoteCustomIx()
    {
        return $this->rfNoteCustomIx;
    }

    /**
     * Set rfNoteCustomDb
     *
     * @param string $rfNoteCustomDb
     *
     * @return RfNoteCustom
     */
    public function setRfNoteCustomDb($rfNoteCustomDb)
    {
        $this->rfNoteCustomDb = $rfNoteCustomDb;

        return $this;
    }

    /**
     * Get rfNoteCustomDb
     *
     * @return string
     */
    public function getRfNoteCustomDb()
    {
        return $this->rfNoteCustomDb;
    }

    /**
     * Set rfNoteCustomId
     *
     * @param integer $rfNoteCustomId
     *
     * @return RfNoteCustom
     */
    public function setRfNoteCustomId($rfNoteCustomId)
    {
        $this->rfNoteCustomId = $rfNoteCustomId;

        return $this;
    }

    /**
     * Get rfNoteCustomId
     *
     * @return integer
     */
    public function getRfNoteCustomId()
    {
        return $this->rfNoteCustomId;
    }

    /**
     * Set rfNoteCustomDesc
     *
     * @param string $rfNoteCustomDesc
     *
     * @return RfNoteCustom
     */
    public function setRfNoteCustomDesc($rfNoteCustomDesc)
    {
        $this->rfNoteCustomDesc = $rfNoteCustomDesc;

        return $this;
    }

    /**
     * Get rfNoteCustomDesc
     *
     * @return string
     */
    public function getRfNoteCustomDesc()
    {
        return $this->rfNoteCustomDesc;
    }

    /**
     * Set rfNoteCustomHdg
     *
     * @param string $rfNoteCustomHdg
     *
     * @return RfNoteCustom
     */
    public function setRfNoteCustomHdg($rfNoteCustomHdg)
    {
        $this->rfNoteCustomHdg = $rfNoteCustomHdg;

        return $this;
    }

    /**
     * Get rfNoteCustomHdg
     *
     * @return string
     */
    public function getRfNoteCustomHdg()
    {
        return $this->rfNoteCustomHdg;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfNoteCustom
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfNoteCustomTrfYn
     *
     * @param boolean $rfNoteCustomTrfYn
     *
     * @return RfNoteCustom
     */
    public function setRfNoteCustomTrfYn($rfNoteCustomTrfYn)
    {
        $this->rfNoteCustomTrfYn = $rfNoteCustomTrfYn;

        return $this;
    }

    /**
     * Get rfNoteCustomTrfYn
     *
     * @return boolean
     */
    public function getRfNoteCustomTrfYn()
    {
        return $this->rfNoteCustomTrfYn;
    }
}
