<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfObjGuest
 *
 * @ORM\Table(name="rf_obj_guest", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_obj_guest_trf_yn", columns={"rf_obj_guest_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfObjGuest
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_guest_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfObjGuestIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_guest_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfObjGuestDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_obj_guest_id", type="integer", nullable=false)
     */
    private $rfObjGuestId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_guest_label", type="string", length=30, nullable=true)
     */
    private $rfObjGuestLabel;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_guest_sort_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjGuestSortSeq;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_obj_guest_type_ind", type="integer", nullable=true)
     */
    private $rfObjGuestTypeInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_guest_mandatory_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjGuestMandatoryYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_guest_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjGuestSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_guest_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rfObjGuestInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_guest_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjGuestTrfYn;



    /**
     * Get rfObjGuestIx
     *
     * @return string
     */
    public function getRfObjGuestIx()
    {
        return $this->rfObjGuestIx;
    }

    /**
     * Set rfObjGuestDb
     *
     * @param string $rfObjGuestDb
     *
     * @return RfObjGuest
     */
    public function setRfObjGuestDb($rfObjGuestDb)
    {
        $this->rfObjGuestDb = $rfObjGuestDb;

        return $this;
    }

    /**
     * Get rfObjGuestDb
     *
     * @return string
     */
    public function getRfObjGuestDb()
    {
        return $this->rfObjGuestDb;
    }

    /**
     * Set rfObjGuestId
     *
     * @param integer $rfObjGuestId
     *
     * @return RfObjGuest
     */
    public function setRfObjGuestId($rfObjGuestId)
    {
        $this->rfObjGuestId = $rfObjGuestId;

        return $this;
    }

    /**
     * Get rfObjGuestId
     *
     * @return integer
     */
    public function getRfObjGuestId()
    {
        return $this->rfObjGuestId;
    }

    /**
     * Set rfObjGuestLabel
     *
     * @param string $rfObjGuestLabel
     *
     * @return RfObjGuest
     */
    public function setRfObjGuestLabel($rfObjGuestLabel)
    {
        $this->rfObjGuestLabel = $rfObjGuestLabel;

        return $this;
    }

    /**
     * Get rfObjGuestLabel
     *
     * @return string
     */
    public function getRfObjGuestLabel()
    {
        return $this->rfObjGuestLabel;
    }

    /**
     * Set rfObjGuestSortSeq
     *
     * @param boolean $rfObjGuestSortSeq
     *
     * @return RfObjGuest
     */
    public function setRfObjGuestSortSeq($rfObjGuestSortSeq)
    {
        $this->rfObjGuestSortSeq = $rfObjGuestSortSeq;

        return $this;
    }

    /**
     * Get rfObjGuestSortSeq
     *
     * @return boolean
     */
    public function getRfObjGuestSortSeq()
    {
        return $this->rfObjGuestSortSeq;
    }

    /**
     * Set rfObjGuestTypeInd
     *
     * @param integer $rfObjGuestTypeInd
     *
     * @return RfObjGuest
     */
    public function setRfObjGuestTypeInd($rfObjGuestTypeInd)
    {
        $this->rfObjGuestTypeInd = $rfObjGuestTypeInd;

        return $this;
    }

    /**
     * Get rfObjGuestTypeInd
     *
     * @return integer
     */
    public function getRfObjGuestTypeInd()
    {
        return $this->rfObjGuestTypeInd;
    }

    /**
     * Set rfObjGuestMandatoryYn
     *
     * @param boolean $rfObjGuestMandatoryYn
     *
     * @return RfObjGuest
     */
    public function setRfObjGuestMandatoryYn($rfObjGuestMandatoryYn)
    {
        $this->rfObjGuestMandatoryYn = $rfObjGuestMandatoryYn;

        return $this;
    }

    /**
     * Get rfObjGuestMandatoryYn
     *
     * @return boolean
     */
    public function getRfObjGuestMandatoryYn()
    {
        return $this->rfObjGuestMandatoryYn;
    }

    /**
     * Set rfObjGuestSysCode
     *
     * @param boolean $rfObjGuestSysCode
     *
     * @return RfObjGuest
     */
    public function setRfObjGuestSysCode($rfObjGuestSysCode)
    {
        $this->rfObjGuestSysCode = $rfObjGuestSysCode;

        return $this;
    }

    /**
     * Get rfObjGuestSysCode
     *
     * @return boolean
     */
    public function getRfObjGuestSysCode()
    {
        return $this->rfObjGuestSysCode;
    }

    /**
     * Set rfObjGuestInactiveYn
     *
     * @param boolean $rfObjGuestInactiveYn
     *
     * @return RfObjGuest
     */
    public function setRfObjGuestInactiveYn($rfObjGuestInactiveYn)
    {
        $this->rfObjGuestInactiveYn = $rfObjGuestInactiveYn;

        return $this;
    }

    /**
     * Get rfObjGuestInactiveYn
     *
     * @return boolean
     */
    public function getRfObjGuestInactiveYn()
    {
        return $this->rfObjGuestInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfObjGuest
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfObjGuestTrfYn
     *
     * @param boolean $rfObjGuestTrfYn
     *
     * @return RfObjGuest
     */
    public function setRfObjGuestTrfYn($rfObjGuestTrfYn)
    {
        $this->rfObjGuestTrfYn = $rfObjGuestTrfYn;

        return $this;
    }

    /**
     * Get rfObjGuestTrfYn
     *
     * @return boolean
     */
    public function getRfObjGuestTrfYn()
    {
        return $this->rfObjGuestTrfYn;
    }
}
