<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfObjGuestData
 *
 * @ORM\Table(name="rf_obj_guest_data", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_obj_guest_data_trf_yn", columns={"rf_obj_guest_data_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rf_obj_guest_id", columns={"rf_obj_guest_id"})})
 * @ORM\Entity
 */
class RfObjGuestData
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_guest_data_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfObjGuestDataIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_guest_data_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfObjGuestDataDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_obj_guest_data_id", type="integer", nullable=false)
     */
    private $rfObjGuestDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_guest_data_content", type="string", length=30, nullable=true)
     */
    private $rfObjGuestDataContent;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_guest_data_sort_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjGuestDataSortSeq;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_guest_id", type="string", length=36, nullable=true)
     */
    private $rfObjGuestId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_guest_data_default_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjGuestDataDefaultYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_guest_data_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rfObjGuestDataInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_guest_data_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjGuestDataTrfYn;



    /**
     * Get rfObjGuestDataIx
     *
     * @return string
     */
    public function getRfObjGuestDataIx()
    {
        return $this->rfObjGuestDataIx;
    }

    /**
     * Set rfObjGuestDataDb
     *
     * @param string $rfObjGuestDataDb
     *
     * @return RfObjGuestData
     */
    public function setRfObjGuestDataDb($rfObjGuestDataDb)
    {
        $this->rfObjGuestDataDb = $rfObjGuestDataDb;

        return $this;
    }

    /**
     * Get rfObjGuestDataDb
     *
     * @return string
     */
    public function getRfObjGuestDataDb()
    {
        return $this->rfObjGuestDataDb;
    }

    /**
     * Set rfObjGuestDataId
     *
     * @param integer $rfObjGuestDataId
     *
     * @return RfObjGuestData
     */
    public function setRfObjGuestDataId($rfObjGuestDataId)
    {
        $this->rfObjGuestDataId = $rfObjGuestDataId;

        return $this;
    }

    /**
     * Get rfObjGuestDataId
     *
     * @return integer
     */
    public function getRfObjGuestDataId()
    {
        return $this->rfObjGuestDataId;
    }

    /**
     * Set rfObjGuestDataContent
     *
     * @param string $rfObjGuestDataContent
     *
     * @return RfObjGuestData
     */
    public function setRfObjGuestDataContent($rfObjGuestDataContent)
    {
        $this->rfObjGuestDataContent = $rfObjGuestDataContent;

        return $this;
    }

    /**
     * Get rfObjGuestDataContent
     *
     * @return string
     */
    public function getRfObjGuestDataContent()
    {
        return $this->rfObjGuestDataContent;
    }

    /**
     * Set rfObjGuestDataSortSeq
     *
     * @param boolean $rfObjGuestDataSortSeq
     *
     * @return RfObjGuestData
     */
    public function setRfObjGuestDataSortSeq($rfObjGuestDataSortSeq)
    {
        $this->rfObjGuestDataSortSeq = $rfObjGuestDataSortSeq;

        return $this;
    }

    /**
     * Get rfObjGuestDataSortSeq
     *
     * @return boolean
     */
    public function getRfObjGuestDataSortSeq()
    {
        return $this->rfObjGuestDataSortSeq;
    }

    /**
     * Set rfObjGuestId
     *
     * @param string $rfObjGuestId
     *
     * @return RfObjGuestData
     */
    public function setRfObjGuestId($rfObjGuestId)
    {
        $this->rfObjGuestId = $rfObjGuestId;

        return $this;
    }

    /**
     * Get rfObjGuestId
     *
     * @return string
     */
    public function getRfObjGuestId()
    {
        return $this->rfObjGuestId;
    }

    /**
     * Set rfObjGuestDataDefaultYn
     *
     * @param boolean $rfObjGuestDataDefaultYn
     *
     * @return RfObjGuestData
     */
    public function setRfObjGuestDataDefaultYn($rfObjGuestDataDefaultYn)
    {
        $this->rfObjGuestDataDefaultYn = $rfObjGuestDataDefaultYn;

        return $this;
    }

    /**
     * Get rfObjGuestDataDefaultYn
     *
     * @return boolean
     */
    public function getRfObjGuestDataDefaultYn()
    {
        return $this->rfObjGuestDataDefaultYn;
    }

    /**
     * Set rfObjGuestDataInactiveYn
     *
     * @param boolean $rfObjGuestDataInactiveYn
     *
     * @return RfObjGuestData
     */
    public function setRfObjGuestDataInactiveYn($rfObjGuestDataInactiveYn)
    {
        $this->rfObjGuestDataInactiveYn = $rfObjGuestDataInactiveYn;

        return $this;
    }

    /**
     * Get rfObjGuestDataInactiveYn
     *
     * @return boolean
     */
    public function getRfObjGuestDataInactiveYn()
    {
        return $this->rfObjGuestDataInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfObjGuestData
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfObjGuestDataTrfYn
     *
     * @param boolean $rfObjGuestDataTrfYn
     *
     * @return RfObjGuestData
     */
    public function setRfObjGuestDataTrfYn($rfObjGuestDataTrfYn)
    {
        $this->rfObjGuestDataTrfYn = $rfObjGuestDataTrfYn;

        return $this;
    }

    /**
     * Get rfObjGuestDataTrfYn
     *
     * @return boolean
     */
    public function getRfObjGuestDataTrfYn()
    {
        return $this->rfObjGuestDataTrfYn;
    }
}
