<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfObjRegistrationCard
 *
 * @ORM\Table(name="rf_obj_registration_card", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_obj_registration_card_trf_yn", columns={"rf_obj_registration_card_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfObjRegistrationCard
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_registration_card_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfObjRegistrationCardIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_registration_card_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfObjRegistrationCardDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_obj_registration_card_id", type="integer", nullable=false)
     */
    private $rfObjRegistrationCardId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_registration_card_name", type="string", length=30, nullable=true)
     */
    private $rfObjRegistrationCardName;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_registration_card_label", type="string", length=30, nullable=true)
     */
    private $rfObjRegistrationCardLabel;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_registration_card_sort_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjRegistrationCardSortSeq;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_obj_registration_card_sys_code", type="integer", nullable=true)
     */
    private $rfObjRegistrationCardSysCode;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_obj_registration_card_type_ind", type="integer", nullable=true)
     */
    private $rfObjRegistrationCardTypeInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_registration_card_mandatory_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjRegistrationCardMandatoryYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_registration_card_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rfObjRegistrationCardInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_registration_card_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjRegistrationCardTrfYn;



    /**
     * Get rfObjRegistrationCardIx
     *
     * @return string
     */
    public function getRfObjRegistrationCardIx()
    {
        return $this->rfObjRegistrationCardIx;
    }

    /**
     * Set rfObjRegistrationCardDb
     *
     * @param string $rfObjRegistrationCardDb
     *
     * @return RfObjRegistrationCard
     */
    public function setRfObjRegistrationCardDb($rfObjRegistrationCardDb)
    {
        $this->rfObjRegistrationCardDb = $rfObjRegistrationCardDb;

        return $this;
    }

    /**
     * Get rfObjRegistrationCardDb
     *
     * @return string
     */
    public function getRfObjRegistrationCardDb()
    {
        return $this->rfObjRegistrationCardDb;
    }

    /**
     * Set rfObjRegistrationCardId
     *
     * @param integer $rfObjRegistrationCardId
     *
     * @return RfObjRegistrationCard
     */
    public function setRfObjRegistrationCardId($rfObjRegistrationCardId)
    {
        $this->rfObjRegistrationCardId = $rfObjRegistrationCardId;

        return $this;
    }

    /**
     * Get rfObjRegistrationCardId
     *
     * @return integer
     */
    public function getRfObjRegistrationCardId()
    {
        return $this->rfObjRegistrationCardId;
    }

    /**
     * Set rfObjRegistrationCardLabel
     *
     * @param string $rfObjRegistrationCardLabel
     *
     * @return RfObjRegistrationCard
     */
    public function setRfObjRegistrationCardLabel($rfObjRegistrationCardLabel)
    {
        $this->rfObjRegistrationCardLabel = $rfObjRegistrationCardLabel;

        return $this;
    }

    /**
     * Get rfObjRegistrationCardLabel
     *
     * @return string
     */
    public function getRfObjRegistrationCardLabel()
    {
        return $this->rfObjRegistrationCardLabel;
    }

    /**
     * Set rfObjRegistrationCardName
     *
     * @param string $rfObjRegistrationCardName
     *
     * @return RfObjRegistrationCard
     */
    public function setRfObjRegistrationCardName($rfObjRegistrationCardName)
    {
        $this->rfObjRegistrationCardName = $rfObjRegistrationCardName;

        return $this;
    }

    /**
     * Get rfObjRegistrationCardName
     *
     * @return string
     */
    public function getRfObjRegistrationCardName()
    {
        return $this->rfObjRegistrationCardName;
    }

    /**
     * Set rfObjRegistrationCardSortSeq
     *
     * @param boolean $rfObjRegistrationCardSortSeq
     *
     * @return RfObjRegistrationCard
     */
    public function setRfObjRegistrationCardSortSeq($rfObjRegistrationCardSortSeq)
    {
        $this->rfObjRegistrationCardSortSeq = $rfObjRegistrationCardSortSeq;

        return $this;
    }

    /**
     * Get rfObjRegistrationCardSortSeq
     *
     * @return boolean
     */
    public function getRfObjRegistrationCardSortSeq()
    {
        return $this->rfObjRegistrationCardSortSeq;
    }

    /**
     * Set rfObjRegistrationCardTypeInd
     *
     * @param integer $rfObjRegistrationCardTypeInd
     *
     * @return RfObjRegistrationCard
     */
    public function setRfObjRegistrationCardTypeInd($rfObjRegistrationCardTypeInd)
    {
        $this->rfObjRegistrationCardTypeInd = $rfObjRegistrationCardTypeInd;

        return $this;
    }

    /**
     * Get rfObjRegistrationCardTypeInd
     *
     * @return integer
     */
    public function getRfObjRegistrationCardTypeInd()
    {
        return $this->rfObjRegistrationCardTypeInd;
    }

    /**
     * Set rfObjRegistrationCardMandatoryYn
     *
     * @param boolean $rfObjRegistrationCardMandatoryYn
     *
     * @return RfObjRegistrationCard
     */
    public function setRfObjRegistrationCardMandatoryYn($rfObjRegistrationCardMandatoryYn)
    {
        $this->rfObjRegistrationCardMandatoryYn = $rfObjRegistrationCardMandatoryYn;

        return $this;
    }

    /**
     * Get rfObjRegistrationCardMandatoryYn
     *
     * @return boolean
     */
    public function getRfObjRegistrationCardMandatoryYn()
    {
        return $this->rfObjRegistrationCardMandatoryYn;
    }

    /**
     * Set rfObjRegistrationCardInactiveYn
     *
     * @param boolean $rfObjRegistrationCardInactiveYn
     *
     * @return RfObjRegistrationCard
     */
    public function setRfObjRegistrationCardInactiveYn($rfObjRegistrationCardInactiveYn)
    {
        $this->rfObjRegistrationCardInactiveYn = $rfObjRegistrationCardInactiveYn;

        return $this;
    }

    /**
     * Get rfObjRegistrationCardInactiveYn
     *
     * @return boolean
     */
    public function getRfObjRegistrationCardInactiveYn()
    {
        return $this->rfObjRegistrationCardInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfObjRegistrationCard
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfObjRegistrationCardTrfYn
     *
     * @param boolean $rfObjRegistrationCardTrfYn
     *
     * @return RfObjRegistrationCard
     */
    public function setRfObjRegistrationCardTrfYn($rfObjRegistrationCardTrfYn)
    {
        $this->rfObjRegistrationCardTrfYn = $rfObjRegistrationCardTrfYn;

        return $this;
    }

    /**
     * Get rfObjRegistrationCardTrfYn
     *
     * @return boolean
     */
    public function getRfObjRegistrationCardTrfYn()
    {
        return $this->rfObjRegistrationCardTrfYn;
    }

    /**
     * Set rfObjRegistrationCardSysCode
     *
     * @param integer $rfObjRegistrationCardSysCode
     *
     * @return RfObjRegistrationCard
     */
    public function setRfObjRegistrationCardSysCode($rfObjRegistrationCardSysCode)
    {
        $this->rfObjRegistrationCardSysCode = $rfObjRegistrationCardSysCode;

        return $this;
    }

    /**
     * Get rfObjRegistrationCardSysCode
     *
     * @return integer
     */
    public function getRfObjRegistrationCardSysCode()
    {
        return $this->rfObjRegistrationCardSysCode;
    }
}
