<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfObjTrip
 *
 * @ORM\Table(name="rf_obj_trip", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_obj_trip_trf_yn", columns={"rf_obj_trip_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfObjTrip
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfObjTripIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfObjTripDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_obj_trip_id", type="integer", nullable=false)
     */
    private $rfObjTripId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_label", type="string", length=30, nullable=true)
     */
    private $rfObjTripLabel;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_trip_sort_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjTripSortSeq;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_obj_trip_type_ind", type="integer", nullable=true)
     */
    private $rfObjTripTypeInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_trip_mandatory_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjTripMandatoryYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_trip_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rfObjTripInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_trip_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjTripTrfYn;



    /**
     * Get rfObjTripIx
     *
     * @return string
     */
    public function getRfObjTripIx()
    {
        return $this->rfObjTripIx;
    }

    /**
     * Set rfObjTripDb
     *
     * @param string $rfObjTripDb
     *
     * @return RfObjTrip
     */
    public function setRfObjTripDb($rfObjTripDb)
    {
        $this->rfObjTripDb = $rfObjTripDb;

        return $this;
    }

    /**
     * Get rfObjTripDb
     *
     * @return string
     */
    public function getRfObjTripDb()
    {
        return $this->rfObjTripDb;
    }

    /**
     * Set rfObjTripId
     *
     * @param integer $rfObjTripId
     *
     * @return RfObjTrip
     */
    public function setRfObjTripId($rfObjTripId)
    {
        $this->rfObjTripId = $rfObjTripId;

        return $this;
    }

    /**
     * Get rfObjTripId
     *
     * @return integer
     */
    public function getRfObjTripId()
    {
        return $this->rfObjTripId;
    }

    /**
     * Set rfObjTripLabel
     *
     * @param string $rfObjTripLabel
     *
     * @return RfObjTrip
     */
    public function setRfObjTripLabel($rfObjTripLabel)
    {
        $this->rfObjTripLabel = $rfObjTripLabel;

        return $this;
    }

    /**
     * Get rfObjTripLabel
     *
     * @return string
     */
    public function getRfObjTripLabel()
    {
        return $this->rfObjTripLabel;
    }

    /**
     * Set rfObjTripSortSeq
     *
     * @param boolean $rfObjTripSortSeq
     *
     * @return RfObjTrip
     */
    public function setRfObjTripSortSeq($rfObjTripSortSeq)
    {
        $this->rfObjTripSortSeq = $rfObjTripSortSeq;

        return $this;
    }

    /**
     * Get rfObjTripSortSeq
     *
     * @return boolean
     */
    public function getRfObjTripSortSeq()
    {
        return $this->rfObjTripSortSeq;
    }

    /**
     * Set rfObjTripTypeInd
     *
     * @param integer $rfObjTripTypeInd
     *
     * @return RfObjTrip
     */
    public function setRfObjTripTypeInd($rfObjTripTypeInd)
    {
        $this->rfObjTripTypeInd = $rfObjTripTypeInd;

        return $this;
    }

    /**
     * Get rfObjTripTypeInd
     *
     * @return integer
     */
    public function getRfObjTripTypeInd()
    {
        return $this->rfObjTripTypeInd;
    }

    /**
     * Set rfObjTripMandatoryYn
     *
     * @param boolean $rfObjTripMandatoryYn
     *
     * @return RfObjTrip
     */
    public function setRfObjTripMandatoryYn($rfObjTripMandatoryYn)
    {
        $this->rfObjTripMandatoryYn = $rfObjTripMandatoryYn;

        return $this;
    }

    /**
     * Get rfObjTripMandatoryYn
     *
     * @return boolean
     */
    public function getRfObjTripMandatoryYn()
    {
        return $this->rfObjTripMandatoryYn;
    }

    /**
     * Set rfObjTripInactiveYn
     *
     * @param boolean $rfObjTripInactiveYn
     *
     * @return RfObjTrip
     */
    public function setRfObjTripInactiveYn($rfObjTripInactiveYn)
    {
        $this->rfObjTripInactiveYn = $rfObjTripInactiveYn;

        return $this;
    }

    /**
     * Get rfObjTripInactiveYn
     *
     * @return boolean
     */
    public function getRfObjTripInactiveYn()
    {
        return $this->rfObjTripInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfObjTrip
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfObjTripTrfYn
     *
     * @param boolean $rfObjTripTrfYn
     *
     * @return RfObjTrip
     */
    public function setRfObjTripTrfYn($rfObjTripTrfYn)
    {
        $this->rfObjTripTrfYn = $rfObjTripTrfYn;

        return $this;
    }

    /**
     * Get rfObjTripTrfYn
     *
     * @return boolean
     */
    public function getRfObjTripTrfYn()
    {
        return $this->rfObjTripTrfYn;
    }
}
