<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfObjTripData
 *
 * @ORM\Table(name="rf_obj_trip_data", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_obj_trip_data_trf_yn", columns={"rf_obj_trip_data_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rf_obj_trip_id", columns={"rf_obj_trip_id"})})
 * @ORM\Entity
 */
class RfObjTripData
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_data_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfObjTripDataIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_data_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfObjTripDataDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_obj_trip_data_id", type="integer", nullable=false)
     */
    private $rfObjTripDataId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_data_content", type="string", length=30, nullable=true)
     */
    private $rfObjTripDataContent;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_trip_data_sort_seq", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjTripDataSortSeq;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_id", type="string", length=36, nullable=true)
     */
    private $rfObjTripId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_trip_data_default_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjTripDataDefaultYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_trip_data_inactive_yn", type="boolean", nullable=true, options={"default"="0"})
     */
    private $rfObjTripDataInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_trip_data_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjTripDataTrfYn;



    /**
     * Get rfObjTripDataIx
     *
     * @return string
     */
    public function getRfObjTripDataIx()
    {
        return $this->rfObjTripDataIx;
    }

    /**
     * Set rfObjTripDataDb
     *
     * @param string $rfObjTripDataDb
     *
     * @return RfObjTripData
     */
    public function setRfObjTripDataDb($rfObjTripDataDb)
    {
        $this->rfObjTripDataDb = $rfObjTripDataDb;

        return $this;
    }

    /**
     * Get rfObjTripDataDb
     *
     * @return string
     */
    public function getRfObjTripDataDb()
    {
        return $this->rfObjTripDataDb;
    }

    /**
     * Set rfObjTripDataId
     *
     * @param integer $rfObjTripDataId
     *
     * @return RfObjTripData
     */
    public function setRfObjTripDataId($rfObjTripDataId)
    {
        $this->rfObjTripDataId = $rfObjTripDataId;

        return $this;
    }

    /**
     * Get rfObjTripDataId
     *
     * @return integer
     */
    public function getRfObjTripDataId()
    {
        return $this->rfObjTripDataId;
    }

    /**
     * Set rfObjTripDataContent
     *
     * @param string $rfObjTripDataContent
     *
     * @return RfObjTripData
     */
    public function setRfObjTripDataContent($rfObjTripDataContent)
    {
        $this->rfObjTripDataContent = $rfObjTripDataContent;

        return $this;
    }

    /**
     * Get rfObjTripDataContent
     *
     * @return string
     */
    public function getRfObjTripDataContent()
    {
        return $this->rfObjTripDataContent;
    }

    /**
     * Set rfObjTripDataSortSeq
     *
     * @param boolean $rfObjTripDataSortSeq
     *
     * @return RfObjTripData
     */
    public function setRfObjTripDataSortSeq($rfObjTripDataSortSeq)
    {
        $this->rfObjTripDataSortSeq = $rfObjTripDataSortSeq;

        return $this;
    }

    /**
     * Get rfObjTripDataSortSeq
     *
     * @return boolean
     */
    public function getRfObjTripDataSortSeq()
    {
        return $this->rfObjTripDataSortSeq;
    }

    /**
     * Set rfObjTripId
     *
     * @param string $rfObjTripId
     *
     * @return RfObjTripData
     */
    public function setRfObjTripId($rfObjTripId)
    {
        $this->rfObjTripId = $rfObjTripId;

        return $this;
    }

    /**
     * Get rfObjTripId
     *
     * @return string
     */
    public function getRfObjTripId()
    {
        return $this->rfObjTripId;
    }

    /**
     * Set rfObjTripDataDefaultYn
     *
     * @param boolean $rfObjTripDataDefaultYn
     *
     * @return RfObjTripData
     */
    public function setRfObjTripDataDefaultYn($rfObjTripDataDefaultYn)
    {
        $this->rfObjTripDataDefaultYn = $rfObjTripDataDefaultYn;

        return $this;
    }

    /**
     * Get rfObjTripDataDefaultYn
     *
     * @return boolean
     */
    public function getRfObjTripDataDefaultYn()
    {
        return $this->rfObjTripDataDefaultYn;
    }

    /**
     * Set rfObjTripDataInactiveYn
     *
     * @param boolean $rfObjTripDataInactiveYn
     *
     * @return RfObjTripData
     */
    public function setRfObjTripDataInactiveYn($rfObjTripDataInactiveYn)
    {
        $this->rfObjTripDataInactiveYn = $rfObjTripDataInactiveYn;

        return $this;
    }

    /**
     * Get rfObjTripDataInactiveYn
     *
     * @return boolean
     */
    public function getRfObjTripDataInactiveYn()
    {
        return $this->rfObjTripDataInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfObjTripData
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfObjTripDataTrfYn
     *
     * @param boolean $rfObjTripDataTrfYn
     *
     * @return RfObjTripData
     */
    public function setRfObjTripDataTrfYn($rfObjTripDataTrfYn)
    {
        $this->rfObjTripDataTrfYn = $rfObjTripDataTrfYn;

        return $this;
    }

    /**
     * Get rfObjTripDataTrfYn
     *
     * @return boolean
     */
    public function getRfObjTripDataTrfYn()
    {
        return $this->rfObjTripDataTrfYn;
    }
}
