<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfObjTripProp
 *
 * @ORM\Table(name="rf_obj_trip_prop", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_obj_trip_prop_trf_yn", columns={"rf_obj_trip_prop_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfObjTripProp
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_prop_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfObjTripPropIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_prop_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfObjTripPropDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_obj_trip_prop_id", type="integer", nullable=false)
     */
    private $rfObjTripPropId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_obj_trip_id", type="string", length=36, nullable=true)
     */
    private $rfObjTripId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_obj_trip_prop_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfObjTripPropTrfYn;



    /**
     * Get rfObjTripPropIx
     *
     * @return string
     */
    public function getRfObjTripPropIx()
    {
        return $this->rfObjTripPropIx;
    }

    /**
     * Set rfObjTripPropDb
     *
     * @param string $rfObjTripPropDb
     *
     * @return RfObjTripProp
     */
    public function setRfObjTripPropDb($rfObjTripPropDb)
    {
        $this->rfObjTripPropDb = $rfObjTripPropDb;

        return $this;
    }

    /**
     * Get rfObjTripPropDb
     *
     * @return string
     */
    public function getRfObjTripPropDb()
    {
        return $this->rfObjTripPropDb;
    }

    /**
     * Set rfObjTripPropId
     *
     * @param integer $rfObjTripPropId
     *
     * @return RfObjTripProp
     */
    public function setRfObjTripPropId($rfObjTripPropId)
    {
        $this->rfObjTripPropId = $rfObjTripPropId;

        return $this;
    }

    /**
     * Get rfObjTripPropId
     *
     * @return integer
     */
    public function getRfObjTripPropId()
    {
        return $this->rfObjTripPropId;
    }

    /**
     * Set rfObjTripId
     *
     * @param string $rfObjTripId
     *
     * @return RfObjTripProp
     */
    public function setRfObjTripId($rfObjTripId)
    {
        $this->rfObjTripId = $rfObjTripId;

        return $this;
    }

    /**
     * Get rfObjTripId
     *
     * @return string
     */
    public function getRfObjTripId()
    {
        return $this->rfObjTripId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RfObjTripProp
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfObjTripProp
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfObjTripPropTrfYn
     *
     * @param boolean $rfObjTripPropTrfYn
     *
     * @return RfObjTripProp
     */
    public function setRfObjTripPropTrfYn($rfObjTripPropTrfYn)
    {
        $this->rfObjTripPropTrfYn = $rfObjTripPropTrfYn;

        return $this;
    }

    /**
     * Get rfObjTripPropTrfYn
     *
     * @return boolean
     */
    public function getRfObjTripPropTrfYn()
    {
        return $this->rfObjTripPropTrfYn;
    }
}
