<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfPhoneExtn
 *
 * @ORM\Table(name="rf_phone_extn", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_phone_extn_trf_yn", columns={"rf_phone_extn_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfPhoneExtn
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_phone_extn_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfPhoneExtnIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_phone_extn_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfPhoneExtnDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_phone_extn_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $rfPhoneExtnId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_id", type="string", length=36, nullable=true)
     */
    private $acExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_room_id", type="string", length=36, nullable=true)
     */
    private $acAccommRoomId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="sy_date_rec", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $syDateRec;

    /**
     * @var string
     *
     * @ORM\Column(name="sy_date_rec_tz", type="string", length=40, nullable=false)
     */
    private $syDateRecTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="sy_date_upd", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $syDateUpd;

    /**
     * @var string
     *
     * @ORM\Column(name="sy_date_upd_tz", type="string", length=40, nullable=false)
     */
    private $syDateUpdTz;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_phone_extn_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPhoneExtnInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_phone_extn_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPhoneExtnTrfYn;



    /**
     * Get rfPhoneExtnIx
     *
     * @return string
     */
    public function getRfPhoneExtnIx()
    {
        return $this->rfPhoneExtnIx;
    }

    /**
     * Set rfPhoneExtnDb
     *
     * @param string $rfPhoneExtnDb
     *
     * @return RfPhoneExtn
     */
    public function setRfPhoneExtnDb($rfPhoneExtnDb)
    {
        $this->rfPhoneExtnDb = $rfPhoneExtnDb;

        return $this;
    }

    /**
     * Get rfPhoneExtnDb
     *
     * @return string
     */
    public function getRfPhoneExtnDb()
    {
        return $this->rfPhoneExtnDb;
    }

    /**
     * Set rfPhoneExtnId
     *
     * @param integer $rfPhoneExtnId
     *
     * @return RfPhoneExtn
     */
    public function setRfPhoneExtnId($rfPhoneExtnId)
    {
        $this->rfPhoneExtnId = $rfPhoneExtnId;

        return $this;
    }

    /**
     * Get rfPhoneExtnId
     *
     * @return integer
     */
    public function getRfPhoneExtnId()
    {
        return $this->rfPhoneExtnId;
    }

    /**
     * Set acExtraId
     *
     * @param string $acExtraId
     *
     * @return RfPhoneExtn
     */
    public function setAcExtraId($acExtraId)
    {
        $this->acExtraId = $acExtraId;

        return $this;
    }

    /**
     * Get acExtraId
     *
     * @return string
     */
    public function getAcExtraId()
    {
        return $this->acExtraId;
    }

    /**
     * Set acAccommRoomId
     *
     * @param string $acAccommRoomId
     *
     * @return RfPhoneExtn
     */
    public function setAcAccommRoomId($acAccommRoomId)
    {
        $this->acAccommRoomId = $acAccommRoomId;

        return $this;
    }

    /**
     * Get acAccommRoomId
     *
     * @return string
     */
    public function getAcAccommRoomId()
    {
        return $this->acAccommRoomId;
    }

    /**
     * Set syDateRec
     *
     * @param \DateTime $syDateRec
     *
     * @return RfPhoneExtn
     */
    public function setSyDateRec($syDateRec)
    {
        $this->syDateRec = $syDateRec;

        return $this;
    }

    /**
     * Get syDateRec
     *
     * @return \DateTime
     */
    public function getSyDateRec()
    {
        return $this->syDateRec;
    }

    /**
     * Set syDateRecTz
     *
     * @param string $syDateRecTz
     *
     * @return RfPhoneExtn
     */
    public function setSyDateRecTz($syDateRecTz)
    {
        $this->syDateRecTz = $syDateRecTz;

        return $this;
    }

    /**
     * Get syDateRecTz
     *
     * @return string
     */
    public function getSyDateRecTz()
    {
        return $this->syDateRecTz;
    }

    /**
     * Set syDateUpd
     *
     * @param \DateTime $syDateUpd
     *
     * @return RfPhoneExtn
     */
    public function setSyDateUpd($syDateUpd)
    {
        $this->syDateUpd = $syDateUpd;

        return $this;
    }

    /**
     * Get syDateUpd
     *
     * @return \DateTime
     */
    public function getSyDateUpd()
    {
        return $this->syDateUpd;
    }

    /**
     * Set syDateUpdTz
     *
     * @param string $syDateUpdTz
     *
     * @return RfPhoneExtn
     */
    public function setSyDateUpdTz($syDateUpdTz)
    {
        $this->syDateUpdTz = $syDateUpdTz;

        return $this;
    }

    /**
     * Get syDateUpdTz
     *
     * @return string
     */
    public function getSyDateUpdTz()
    {
        return $this->syDateUpdTz;
    }

    /**
     * Set rfPhoneExtnInactiveYn
     *
     * @param boolean $rfPhoneExtnInactiveYn
     *
     * @return RfPhoneExtn
     */
    public function setRfPhoneExtnInactiveYn($rfPhoneExtnInactiveYn)
    {
        $this->rfPhoneExtnInactiveYn = $rfPhoneExtnInactiveYn;

        return $this;
    }

    /**
     * Get rfPhoneExtnInactiveYn
     *
     * @return boolean
     */
    public function getRfPhoneExtnInactiveYn()
    {
        return $this->rfPhoneExtnInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfPhoneExtn
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfPhoneExtnTrfYn
     *
     * @param boolean $rfPhoneExtnTrfYn
     *
     * @return RfPhoneExtn
     */
    public function setRfPhoneExtnTrfYn($rfPhoneExtnTrfYn)
    {
        $this->rfPhoneExtnTrfYn = $rfPhoneExtnTrfYn;

        return $this;
    }

    /**
     * Get rfPhoneExtnTrfYn
     *
     * @return boolean
     */
    public function getRfPhoneExtnTrfYn()
    {
        return $this->rfPhoneExtnTrfYn;
    }
}
