<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfPhonePropExtra
 *
 * @ORM\Table(name="rf_phone_prop_extra", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_phone_prop_extra_trf_yn", columns={"rf_phone_prop_extra_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfPhonePropExtra
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_phone_prop_extra_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfPhonePropExtraIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_phone_prop_extra_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfPhonePropExtraDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_phone_prop_extra_id", type="integer", nullable=false)
     */
    private $rfPhonePropExtraId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_extra_id", type="string", length=36, nullable=true)
     */
    private $acExtraId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="sy_date_rec", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $syDateRec;

    /**
     * @var string
     *
     * @ORM\Column(name="sy_date_rec_tz", type="string", length=40, nullable=false)
     */
    private $syDateRecTz;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="sy_date_upd", type="datetime", nullable=false, options={"default"="0000-00-00 00:00:00"},  columnDefinition="timestamp NOT NULL DEFAULT '0000-00-00 00:00:00'")
     */
    private $syDateUpd;

    /**
     * @var string
     *
     * @ORM\Column(name="sy_date_upd_tz", type="string", length=40, nullable=false)
     */
    private $syDateUpdTz;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_phone_prop_extra_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPhonePropExtraTrfYn;



    /**
     * Get rfPhonePropExtraIx
     *
     * @return string
     */
    public function getRfPhonePropExtraIx()
    {
        return $this->rfPhonePropExtraIx;
    }

    /**
     * Set rfPhonePropExtraDb
     *
     * @param string $rfPhonePropExtraDb
     *
     * @return RfPhonePropExtra
     */
    public function setRfPhonePropExtraDb($rfPhonePropExtraDb)
    {
        $this->rfPhonePropExtraDb = $rfPhonePropExtraDb;

        return $this;
    }

    /**
     * Get rfPhonePropExtraDb
     *
     * @return string
     */
    public function getRfPhonePropExtraDb()
    {
        return $this->rfPhonePropExtraDb;
    }

    /**
     * Set rfPhonePropExtraId
     *
     * @param integer $rfPhonePropExtraId
     *
     * @return RfPhonePropExtra
     */
    public function setRfPhonePropExtraId($rfPhonePropExtraId)
    {
        $this->rfPhonePropExtraId = $rfPhonePropExtraId;

        return $this;
    }

    /**
     * Get rfPhonePropExtraId
     *
     * @return integer
     */
    public function getRfPhonePropExtraId()
    {
        return $this->rfPhonePropExtraId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RfPhonePropExtra
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set acExtraId
     *
     * @param string $acExtraId
     *
     * @return RfPhonePropExtra
     */
    public function setAcExtraId($acExtraId)
    {
        $this->acExtraId = $acExtraId;

        return $this;
    }

    /**
     * Get acExtraId
     *
     * @return string
     */
    public function getAcExtraId()
    {
        return $this->acExtraId;
    }

    /**
     * Set syDateRec
     *
     * @param \DateTime $syDateRec
     *
     * @return RfPhonePropExtra
     */
    public function setSyDateRec($syDateRec)
    {
        $this->syDateRec = $syDateRec;

        return $this;
    }

    /**
     * Get syDateRec
     *
     * @return \DateTime
     */
    public function getSyDateRec()
    {
        return $this->syDateRec;
    }

    /**
     * Set syDateRecTz
     *
     * @param string $syDateRecTz
     *
     * @return RfPhonePropExtra
     */
    public function setSyDateRecTz($syDateRecTz)
    {
        $this->syDateRecTz = $syDateRecTz;

        return $this;
    }

    /**
     * Get syDateRecTz
     *
     * @return string
     */
    public function getSyDateRecTz()
    {
        return $this->syDateRecTz;
    }

    /**
     * Set syDateUpd
     *
     * @param \DateTime $syDateUpd
     *
     * @return RfPhonePropExtra
     */
    public function setSyDateUpd($syDateUpd)
    {
        $this->syDateUpd = $syDateUpd;

        return $this;
    }

    /**
     * Get syDateUpd
     *
     * @return \DateTime
     */
    public function getSyDateUpd()
    {
        return $this->syDateUpd;
    }

    /**
     * Set syDateUpdTz
     *
     * @param string $syDateUpdTz
     *
     * @return RfPhonePropExtra
     */
    public function setSyDateUpdTz($syDateUpdTz)
    {
        $this->syDateUpdTz = $syDateUpdTz;

        return $this;
    }

    /**
     * Get syDateUpdTz
     *
     * @return string
     */
    public function getSyDateUpdTz()
    {
        return $this->syDateUpdTz;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfPhonePropExtra
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfPhonePropExtraTrfYn
     *
     * @param boolean $rfPhonePropExtraTrfYn
     *
     * @return RfPhonePropExtra
     */
    public function setRfPhonePropExtraTrfYn($rfPhonePropExtraTrfYn)
    {
        $this->rfPhonePropExtraTrfYn = $rfPhonePropExtraTrfYn;

        return $this;
    }

    /**
     * Get rfPhonePropExtraTrfYn
     *
     * @return boolean
     */
    public function getRfPhonePropExtraTrfYn()
    {
        return $this->rfPhonePropExtraTrfYn;
    }
}
