<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfPhoneType
 *
 * @ORM\Table(name="rf_phone_type", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_phone_type_trf_yn", columns={"rf_phone_type_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfPhoneType
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_phone_type_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfPhoneTypeIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_phone_type_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfPhoneTypeDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_phone_type_id", type="integer", nullable=false)
     */
    private $rfPhoneTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_phone_type_desc", type="string", length=50, nullable=true)
     */
    private $rfPhoneTypeDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_phone_type_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPhoneTypeSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_phone_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPhoneInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_phone_type_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfPhoneTypeTrfYn;



    /**
     * Get rfPhoneTypeIx
     *
     * @return string
     */
    public function getRfPhoneTypeIx()
    {
        return $this->rfPhoneTypeIx;
    }

    /**
     * Set rfPhoneTypeDb
     *
     * @param string $rfPhoneTypeDb
     *
     * @return RfPhoneType
     */
    public function setRfPhoneTypeDb($rfPhoneTypeDb)
    {
        $this->rfPhoneTypeDb = $rfPhoneTypeDb;

        return $this;
    }

    /**
     * Get rfPhoneTypeDb
     *
     * @return string
     */
    public function getRfPhoneTypeDb()
    {
        return $this->rfPhoneTypeDb;
    }

    /**
     * Set rfPhoneTypeId
     *
     * @param integer $rfPhoneTypeId
     *
     * @return RfPhoneType
     */
    public function setRfPhoneTypeId($rfPhoneTypeId)
    {
        $this->rfPhoneTypeId = $rfPhoneTypeId;

        return $this;
    }

    /**
     * Get rfPhoneTypeId
     *
     * @return integer
     */
    public function getRfPhoneTypeId()
    {
        return $this->rfPhoneTypeId;
    }

    /**
     * Set rfPhoneTypeDesc
     *
     * @param string $rfPhoneTypeDesc
     *
     * @return RfPhoneType
     */
    public function setRfPhoneTypeDesc($rfPhoneTypeDesc)
    {
        $this->rfPhoneTypeDesc = $rfPhoneTypeDesc;

        return $this;
    }

    /**
     * Get rfPhoneTypeDesc
     *
     * @return string
     */
    public function getRfPhoneTypeDesc()
    {
        return $this->rfPhoneTypeDesc;
    }

    /**
     * Set rfPhoneTypeSysCode
     *
     * @param boolean $rfPhoneTypeSysCode
     *
     * @return RfPhoneType
     */
    public function setRfPhoneTypeSysCode($rfPhoneTypeSysCode)
    {
        $this->rfPhoneTypeSysCode = $rfPhoneTypeSysCode;

        return $this;
    }

    /**
     * Get rfPhoneTypeSysCode
     *
     * @return boolean
     */
    public function getRfPhoneTypeSysCode()
    {
        return $this->rfPhoneTypeSysCode;
    }

    /**
     * Set rfPhoneInactiveYn
     *
     * @param boolean $rfPhoneInactiveYn
     *
     * @return RfPhoneType
     */
    public function setRfPhoneInactiveYn($rfPhoneInactiveYn)
    {
        $this->rfPhoneInactiveYn = $rfPhoneInactiveYn;

        return $this;
    }

    /**
     * Get rfPhoneInactiveYn
     *
     * @return boolean
     */
    public function getRfPhoneInactiveYn()
    {
        return $this->rfPhoneInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfPhoneType
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfPhoneTypeTrfYn
     *
     * @param boolean $rfPhoneTypeTrfYn
     *
     * @return RfPhoneType
     */
    public function setRfPhoneTypeTrfYn($rfPhoneTypeTrfYn)
    {
        $this->rfPhoneTypeTrfYn = $rfPhoneTypeTrfYn;

        return $this;
    }

    /**
     * Get rfPhoneTypeTrfYn
     *
     * @return boolean
     */
    public function getRfPhoneTypeTrfYn()
    {
        return $this->rfPhoneTypeTrfYn;
    }
}
