<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfReservationStatus
 *
 * @ORM\Table(name="rf_reservation_status", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_reservation_status_trf_yn", columns={"rf_reservation_status_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfReservationStatus
{
    /**
     * @var integer
     *
     * @ORM\Column(name="rf_reservation_status_id", type="integer", nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfReservationStatusId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_reservation_status_desc", type="string", length=50, nullable=true)
     */
    private $rfReservationStatusDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_reservation_status_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfReservationStatusTrfYn;



    /**
     * Get rfReservationStatusId
     *
     * @return integer
     */
    public function getRfReservationStatusId()
    {
        return $this->rfReservationStatusId;
    }

    /**
     * Set rfReservationStatusDesc
     *
     * @param string $rfReservationStatusDesc
     *
     * @return RfReservationStatus
     */
    public function setRfReservationStatusDesc($rfReservationStatusDesc)
    {
        $this->rfReservationStatusDesc = $rfReservationStatusDesc;

        return $this;
    }

    /**
     * Get rfReservationStatusDesc
     *
     * @return string
     */
    public function getRfReservationStatusDesc()
    {
        return $this->rfReservationStatusDesc;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfReservationStatus
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfReservationStatusTrfYn
     *
     * @param boolean $rfReservationStatusTrfYn
     *
     * @return RfReservationStatus
     */
    public function setRfReservationStatusTrfYn($rfReservationStatusTrfYn)
    {
        $this->rfReservationStatusTrfYn = $rfReservationStatusTrfYn;

        return $this;
    }

    /**
     * Get rfReservationStatusTrfYn
     *
     * @return boolean
     */
    public function getRfReservationStatusTrfYn()
    {
        return $this->rfReservationStatusTrfYn;
    }
}
