<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfSource
 *
 * @ORM\Table(name="rf_source", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_source_trf_yn", columns={"rf_source_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfSource
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_source_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfSourceIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_source_db", type="string", length=2, nullable=false, options={"default"="RS", "fixed"="true"})
     */
    private $rfSourceDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_source_id", type="integer", nullable=false)
     */
    private $rfSourceId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_source_abbrv", type="string", length=7, nullable=true)
     */
    private $rfSourceAbbrv;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_source_colour", type="string", length=6, nullable=true)
     */
    private $rfSourceColour;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_source_desc", type="string", length=20, nullable=false, options={"default"=""})
     */
    private $rfSourceDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_source_note", type="text", length=65535, nullable=true)
     */
    private $rfSourceNote;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_source_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfSourceSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_source_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfSourceInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_source_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfSourceTrfYn;



    /**
     * Get rfSourceIx
     *
     * @return string
     */
    public function getRfSourceIx()
    {
        return $this->rfSourceIx;
    }

    /**
     * Set rfSourceDb
     *
     * @param string $rfSourceDb
     *
     * @return RfSource
     */
    public function setRfSourceDb($rfSourceDb)
    {
        $this->rfSourceDb = $rfSourceDb;

        return $this;
    }

    /**
     * Get rfSourceDb
     *
     * @return string
     */
    public function getRfSourceDb()
    {
        return $this->rfSourceDb;
    }

    /**
     * Set rfSourceId
     *
     * @param integer $rfSourceId
     *
     * @return RfSource
     */
    public function setRfSourceId($rfSourceId)
    {
        $this->rfSourceId = $rfSourceId;

        return $this;
    }

    /**
     * Get rfSourceId
     *
     * @return integer
     */
    public function getRfSourceId()
    {
        return $this->rfSourceId;
    }

    /**
     * Set rfSourceAbbrv
     *
     * @param string $rfSourceAbbrv
     *
     * @return RfSource
     */
    public function setRfSourceAbbrv($rfSourceAbbrv)
    {
        $this->rfSourceAbbrv = $rfSourceAbbrv;

        return $this;
    }

    /**
     * Get rfSourceAbbrv
     *
     * @return string
     */
    public function getRfSourceAbbrv()
    {
        return $this->rfSourceAbbrv;
    }

    /**
     * Set rfSourceColour
     *
     * @param string $rfSourceColour
     *
     * @return RfSource
     */
    public function setRfSourceColour($rfSourceColour)
    {
        $this->rfSourceColour = $rfSourceColour;

        return $this;
    }

    /**
     * Get rfSourceColour
     *
     * @return string
     */
    public function getRfSourceColour()
    {
        return $this->rfSourceColour;
    }

    /**
     * Set rfSourceDesc
     *
     * @param string $rfSourceDesc
     *
     * @return RfSource
     */
    public function setRfSourceDesc($rfSourceDesc)
    {
        $this->rfSourceDesc = $rfSourceDesc;

        return $this;
    }

    /**
     * Get rfSourceDesc
     *
     * @return string
     */
    public function getRfSourceDesc()
    {
        return $this->rfSourceDesc;
    }

    /**
     * Set rfSourceNote
     *
     * @param string $rfSourceNote
     *
     * @return RfSource
     */
    public function setRfSourceNote($rfSourceNote)
    {
        $this->rfSourceNote = $rfSourceNote;

        return $this;
    }

    /**
     * Get rfSourceNote
     *
     * @return string
     */
    public function getRfSourceNote()
    {
        return $this->rfSourceNote;
    }

    /**
     * Set rfSourceSysCode
     *
     * @param boolean $rfSourceSysCode
     *
     * @return RfSource
     */
    public function setRfSourceSysCode($rfSourceSysCode)
    {
        $this->rfSourceSysCode = $rfSourceSysCode;

        return $this;
    }

    /**
     * Get rfSourceSysCode
     *
     * @return boolean
     */
    public function getRfSourceSysCode()
    {
        return $this->rfSourceSysCode;
    }

    /**
     * Set rfSourceInactiveYn
     *
     * @param boolean $rfSourceInactiveYn
     *
     * @return RfSource
     */
    public function setRfSourceInactiveYn($rfSourceInactiveYn)
    {
        $this->rfSourceInactiveYn = $rfSourceInactiveYn;

        return $this;
    }

    /**
     * Get rfSourceInactiveYn
     *
     * @return boolean
     */
    public function getRfSourceInactiveYn()
    {
        return $this->rfSourceInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfSource
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfSourceTrfYn
     *
     * @param boolean $rfSourceTrfYn
     *
     * @return RfSource
     */
    public function setRfSourceTrfYn($rfSourceTrfYn)
    {
        $this->rfSourceTrfYn = $rfSourceTrfYn;

        return $this;
    }

    /**
     * Get rfSourceTrfYn
     *
     * @return boolean
     */
    public function getRfSourceTrfYn()
    {
        return $this->rfSourceTrfYn;
    }
}
