<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfSystem
 *
 * @ORM\Table(name="rf_system", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"})
 * @ORM\Entity
 */
class RfSystem
{
    /**
     * @var integer
     *
     * @ORM\Column(name="rf_system_id", type="integer", nullable=false, options={"default"="0"})
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfSystemId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_sys_censys_email", type="string", length=50, nullable=true, options={"fixed"="true"})
     */
    private $rfSysCensysEmail;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_sys_db_master_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $rfSysDbMasterId;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_sys_db_web_id", type="integer", nullable=false, options={"default"="0"})
     */
    private $rfSysDbWebId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rf_sys_instal_date", type="date", nullable=true, options={"default"="0000-00-00"})
     */
    private $rfSysInstalDate;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_sys_version", type="string", length=20, nullable=true, options={"fixed"="true"})
     */
    private $rfSysVersion;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_sys_locked_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfSysLockedYn;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_sys_wetu_username", type="string", length=50, nullable=true)
     */
    private $rfSysWetuUsername;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_sys_wetu_password", type="string", length=50, nullable=true)
     */
    private $rfSysWetuPassword;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_sys_wetu_api_key", type="string", length=50, nullable=true)
     */
    private $rfSysWetuApiKey;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_sys_tourism_today_access_ind", type="integer", nullable=false, options={"default"="0"})
     */
    private $rfSysTourismTodayAccessInd;



    /**
     * Get rfSystemId
     *
     * @return integer
     */
    public function getRfSystemId()
    {
        return $this->rfSystemId;
    }

    /**
     * Set rfSysCensysEmail
     *
     * @param string $rfSysCensysEmail
     *
     * @return RfSystem
     */
    public function setRfSysCensysEmail($rfSysCensysEmail)
    {
        $this->rfSysCensysEmail = $rfSysCensysEmail;

        return $this;
    }

    /**
     * Get rfSysCensysEmail
     *
     * @return string
     */
    public function getRfSysCensysEmail()
    {
        return $this->rfSysCensysEmail;
    }

    /**
     * Set rfSysDbMasterId
     *
     * @param integer $rfSysDbMasterId
     *
     * @return RfSystem
     */
    public function setRfSysDbMasterId($rfSysDbMasterId)
    {
        $this->rfSysDbMasterId = $rfSysDbMasterId;

        return $this;
    }

    /**
     * Get rfSysDbMasterId
     *
     * @return integer
     */
    public function getRfSysDbMasterId()
    {
        return $this->rfSysDbMasterId;
    }

    /**
     * Set rfSysDbWebId
     *
     * @param integer $rfSysDbWebId
     *
     * @return RfSystem
     */
    public function setRfSysDbWebId($rfSysDbWebId)
    {
        $this->rfSysDbWebId = $rfSysDbWebId;

        return $this;
    }

    /**
     * Get rfSysDbWebId
     *
     * @return integer
     */
    public function getRfSysDbWebId()
    {
        return $this->rfSysDbWebId;
    }

    /**
     * Set rfSysInstalDate
     *
     * @param \DateTime $rfSysInstalDate
     *
     * @return RfSystem
     */
    public function setRfSysInstalDate($rfSysInstalDate)
    {
        $this->rfSysInstalDate = $rfSysInstalDate;

        return $this;
    }

    /**
     * Get rfSysInstalDate
     *
     * @return \DateTime
     */
    public function getRfSysInstalDate()
    {
        return $this->rfSysInstalDate;
    }

    /**
     * Set rfSysVersion
     *
     * @param string $rfSysVersion
     *
     * @return RfSystem
     */
    public function setRfSysVersion($rfSysVersion)
    {
        $this->rfSysVersion = $rfSysVersion;

        return $this;
    }

    /**
     * Get rfSysVersion
     *
     * @return string
     */
    public function getRfSysVersion()
    {
        return $this->rfSysVersion;
    }

    /**
     * Set rfSysLockedYn
     *
     * @param boolean $rfSysLockedYn
     *
     * @return RfSystem
     */
    public function setRfSysLockedYn($rfSysLockedYn)
    {
        $this->rfSysLockedYn = $rfSysLockedYn;

        return $this;
    }

    /**
     * Get rfSysLockedYn
     *
     * @return boolean
     */
    public function getRfSysLockedYn()
    {
        return $this->rfSysLockedYn;
    }

    /**
     * Set rfSysWetuUsername
     *
     * @param string $rfSysWetuUsername
     *
     * @return RfSystem
     */
    public function setRfSysWetuUsername($rfSysWetuUsername)
    {
        $this->rfSysWetuUsername = $rfSysWetuUsername;

        return $this;
    }

    /**
     * Get rfSysWetuUsername
     *
     * @return string
     */
    public function getRfSysWetuUsername()
    {
        return $this->rfSysWetuUsername;
    }

    /**
     * Set rfSysWetuPassword
     *
     * @param string $rfSysWetuPassword
     *
     * @return RfSystem
     */
    public function setRfSysWetuPassword($rfSysWetuPassword)
    {
        $this->rfSysWetuPassword = $rfSysWetuPassword;

        return $this;
    }

    /**
     * Get rfSysWetuPassword
     *
     * @return string
     */
    public function getRfSysWetuPassword()
    {
        return $this->rfSysWetuPassword;
    }

    /**
     * Set rfSysWetuApiKey
     *
     * @param string $rfSysWetuApiKey
     *
     * @return RfSystem
     */
    public function setRfSysWetuApiKey($rfSysWetuApiKey)
    {
        $this->rfSysWetuApiKey = $rfSysWetuApiKey;

        return $this;
    }

    /**
     * Get rfSysWetuApiKey
     *
     * @return string
     */
    public function getRfSysWetuApiKey()
    {
        return $this->rfSysWetuApiKey;
    }

    /**
     * Get rfSysTourismTodayAccessInd
     *
     * @return string
     */
    public function getRfSysTourismTodayAccessInd()
    {
        return $this->rfSysTourismTodayAccessInd;
    }

    /**
     * Set rfSysTourismTodayAccessInd
     *
     * @param string $rfSysTourismTodayAccessInd
     *
     * @return RfSystem
     */
    public function setRfSysTourismTodayAccessInd($rfSysTourismTodayAccessInd)
    {
        $this->rfSysTourismTodayAccessInd = $rfSysTourismTodayAccessInd;

        return $this;
    }
}
