<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfTaxInv
 *
 * @ORM\Table(name="rf_tax_inv", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_tax_inv_trf_yn", columns={"rf_tax_inv_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfTaxInv
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_inv_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfTaxInvIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_inv_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfTaxInvDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_tax_inv_id", type="integer", nullable=false)
     */
    private $rfTaxInvId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id", type="string", length=36, nullable=true)
     */
    private $fnLedgerId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_id", type="string", length=36, nullable=true)
     */
    private $rfTaxId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_tax_ind", type="boolean", nullable=false, options={"default"="10"})
     */
    private $rfTaxInd;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_tax_inv_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfTaxInvTrfYn;



    /**
     * Get rfTaxInvIx
     *
     * @return string
     */
    public function getRfTaxInvIx()
    {
        return $this->rfTaxInvIx;
    }

    /**
     * Set rfTaxInvDb
     *
     * @param string $rfTaxInvDb
     *
     * @return RfTaxInv
     */
    public function setRfTaxInvDb($rfTaxInvDb)
    {
        $this->rfTaxInvDb = $rfTaxInvDb;

        return $this;
    }

    /**
     * Get rfTaxInvDb
     *
     * @return string
     */
    public function getRfTaxInvDb()
    {
        return $this->rfTaxInvDb;
    }

    /**
     * Set rfTaxInvId
     *
     * @param integer $rfTaxInvId
     *
     * @return RfTaxInv
     */
    public function setRfTaxInvId($rfTaxInvId)
    {
        $this->rfTaxInvId = $rfTaxInvId;

        return $this;
    }

    /**
     * Get rfTaxInvId
     *
     * @return integer
     */
    public function getRfTaxInvId()
    {
        return $this->rfTaxInvId;
    }

    /**
     * Set fnLedgerId
     *
     * @param string $fnLedgerId
     *
     * @return RfTaxInv
     */
    public function setFnLedgerId($fnLedgerId)
    {
        $this->fnLedgerId = $fnLedgerId;

        return $this;
    }

    /**
     * Get fnLedgerId
     *
     * @return string
     */
    public function getFnLedgerId()
    {
        return $this->fnLedgerId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RfTaxInv
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set rfTaxId
     *
     * @param string $rfTaxId
     *
     * @return RfTaxInv
     */
    public function setRfTaxId($rfTaxId)
    {
        $this->rfTaxId = $rfTaxId;

        return $this;
    }

    /**
     * Get rfTaxId
     *
     * @return string
     */
    public function getRfTaxId()
    {
        return $this->rfTaxId;
    }

    /**
     * Set rfTaxInd
     *
     * @param boolean $rfTaxInd
     *
     * @return RfTaxInv
     */
    public function setRfTaxInd($rfTaxInd)
    {
        $this->rfTaxInd = $rfTaxInd;

        return $this;
    }

    /**
     * Get rfTaxInd
     *
     * @return boolean
     */
    public function getRfTaxInd()
    {
        return $this->rfTaxInd;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfTaxInv
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfTaxInvTrfYn
     *
     * @param boolean $rfTaxInvTrfYn
     *
     * @return RfTaxInv
     */
    public function setRfTaxInvTrfYn($rfTaxInvTrfYn)
    {
        $this->rfTaxInvTrfYn = $rfTaxInvTrfYn;

        return $this;
    }

    /**
     * Get rfTaxInvTrfYn
     *
     * @return boolean
     */
    public function getRfTaxInvTrfYn()
    {
        return $this->rfTaxInvTrfYn;
    }
}
