<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfTaxRate
 *
 * @ORM\Table(name="rf_tax_rate", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_tax_rate_trf_yn", columns={"rf_tax_rate_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfTaxRate
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfTaxRateIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfTaxRateDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_tax_rate_id", type="integer", nullable=false)
     */
    private $rfTaxRateId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_tax_rate_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfTaxRateCode;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_desc", type="string", length=50, nullable=true)
     */
    private $rfTaxRateDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rfTaxRatePerc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_tax_rate_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfTaxRateInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_tax_rate_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfTaxRateTrfYn;



    /**
     * Get rfTaxRateIx
     *
     * @return string
     */
    public function getRfTaxRateIx()
    {
        return $this->rfTaxRateIx;
    }

    /**
     * Set rfTaxRateDb
     *
     * @param string $rfTaxRateDb
     *
     * @return RfTaxRate
     */
    public function setRfTaxRateDb($rfTaxRateDb)
    {
        $this->rfTaxRateDb = $rfTaxRateDb;

        return $this;
    }

    /**
     * Get rfTaxRateDb
     *
     * @return string
     */
    public function getRfTaxRateDb()
    {
        return $this->rfTaxRateDb;
    }

    /**
     * Set rfTaxRateId
     *
     * @param integer $rfTaxRateId
     *
     * @return RfTaxRate
     */
    public function setRfTaxRateId($rfTaxRateId)
    {
        $this->rfTaxRateId = $rfTaxRateId;

        return $this;
    }

    /**
     * Get rfTaxRateId
     *
     * @return integer
     */
    public function getRfTaxRateId()
    {
        return $this->rfTaxRateId;
    }

    /**
     * Set rfTaxRateCode
     *
     * @param boolean $rfTaxRateCode
     *
     * @return RfTaxRate
     */
    public function setRfTaxRateCode($rfTaxRateCode)
    {
        $this->rfTaxRateCode = $rfTaxRateCode;

        return $this;
    }

    /**
     * Get rfTaxRateCode
     *
     * @return boolean
     */
    public function getRfTaxRateCode()
    {
        return $this->rfTaxRateCode;
    }

    /**
     * Set rfTaxRateDesc
     *
     * @param string $rfTaxRateDesc
     *
     * @return RfTaxRate
     */
    public function setRfTaxRateDesc($rfTaxRateDesc)
    {
        $this->rfTaxRateDesc = $rfTaxRateDesc;

        return $this;
    }

    /**
     * Get rfTaxRateDesc
     *
     * @return string
     */
    public function getRfTaxRateDesc()
    {
        return $this->rfTaxRateDesc;
    }

    /**
     * Set rfTaxRatePerc
     *
     * @param string $rfTaxRatePerc
     *
     * @return RfTaxRate
     */
    public function setRfTaxRatePerc($rfTaxRatePerc)
    {
        $this->rfTaxRatePerc = $rfTaxRatePerc;

        return $this;
    }

    /**
     * Get rfTaxRatePerc
     *
     * @return string
     */
    public function getRfTaxRatePerc()
    {
        return $this->rfTaxRatePerc;
    }

    /**
     * Set rfTaxRateInactiveYn
     *
     * @param boolean $rfTaxRateInactiveYn
     *
     * @return RfTaxRate
     */
    public function setRfTaxRateInactiveYn($rfTaxRateInactiveYn)
    {
        $this->rfTaxRateInactiveYn = $rfTaxRateInactiveYn;

        return $this;
    }

    /**
     * Get rfTaxRateInactiveYn
     *
     * @return boolean
     */
    public function getRfTaxRateInactiveYn()
    {
        return $this->rfTaxRateInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfTaxRate
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfTaxRateTrfYn
     *
     * @param boolean $rfTaxRateTrfYn
     *
     * @return RfTaxRate
     */
    public function setRfTaxRateTrfYn($rfTaxRateTrfYn)
    {
        $this->rfTaxRateTrfYn = $rfTaxRateTrfYn;

        return $this;
    }

    /**
     * Get rfTaxRateTrfYn
     *
     * @return boolean
     */
    public function getRfTaxRateTrfYn()
    {
        return $this->rfTaxRateTrfYn;
    }
}
