<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfTaxRateInv
 *
 * @ORM\Table(name="rf_tax_rate_inv", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"})
 * @ORM\Entity
 */
class RfTaxRateInv
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_inv_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfTaxRateInvIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_inv_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfTaxRateInvDb = '';

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_tax_rate_inv_id", type="integer", nullable=false)
     */
    private $rfTaxRateInvId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id", type="string", length=36, nullable=true)
     */
    private $fnLedgerId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_tax_rate_id", type="string", length=36, nullable=true)
     */
    private $rfTaxRateId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_tax_rate_inv_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfTaxRateInvTrfYn = '0';



    /**
     * Set rfTaxRateInvIx
     *
     * @param string $rfTaxRateInvIx
     *
     * @return RfTaxRateInv
     */
    public function setRfTaxRateInvIx($rfTaxRateInvIx)
    {
        $this->rfTaxRateInvIx = $rfTaxRateInvIx;

        return $this;
    }

    /**
     * Get rfTaxRateInvIx
     *
     * @return string
     */
    public function getRfTaxRateInvIx()
    {
        return $this->rfTaxRateInvIx;
    }

    /**
     * Set rfTaxRateInvDb
     *
     * @param string $rfTaxRateInvDb
     *
     * @return RfTaxRateInv
     */
    public function setRfTaxRateInvDb($rfTaxRateInvDb)
    {
        $this->rfTaxRateInvDb = $rfTaxRateInvDb;

        return $this;
    }

    /**
     * Get rfTaxRateInvDb
     *
     * @return string
     */
    public function getRfTaxRateInvDb()
    {
        return $this->rfTaxRateInvDb;
    }

    /**
     * Set rfTaxRateInvId
     *
     * @param integer $rfTaxRateInvId
     *
     * @return RfTaxRateInv
     */
    public function setRfTaxRateInvId($rfTaxRateInvId)
    {
        $this->rfTaxRateInvId = $rfTaxRateInvId;

        return $this;
    }

    /**
     * Get rfTaxRateInvId
     *
     * @return integer
     */
    public function getRfTaxRateInvId()
    {
        return $this->rfTaxRateInvId;
    }

    /**
     * Set fnLedgerId
     *
     * @param string $fnLedgerId
     *
     * @return RfTaxRateInv
     */
    public function setFnLedgerId($fnLedgerId)
    {
        $this->fnLedgerId = $fnLedgerId;

        return $this;
    }

    /**
     * Get fnLedgerId
     *
     * @return string
     */
    public function getFnLedgerId()
    {
        return $this->fnLedgerId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RfTaxRateInv
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set rfTaxRateId
     *
     * @param string $rfTaxRateId
     *
     * @return RfTaxRateInv
     */
    public function setRfTaxRateId($rfTaxRateId)
    {
        $this->rfTaxRateId = $rfTaxRateId;

        return $this;
    }

    /**
     * Get rfTaxRateId
     *
     * @return string
     */
    public function getRfTaxRateId()
    {
        return $this->rfTaxRateId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfTaxRateInv
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfTaxRateInvTrfYn
     *
     * @param boolean $rfTaxRateInvTrfYn
     *
     * @return RfTaxRateInv
     */
    public function setRfTaxRateInvTrfYn($rfTaxRateInvTrfYn)
    {
        $this->rfTaxRateInvTrfYn = $rfTaxRateInvTrfYn;

        return $this;
    }

    /**
     * Get rfTaxRateInvTrfYn
     *
     * @return boolean
     */
    public function getRfTaxRateInvTrfYn()
    {
        return $this->rfTaxRateInvTrfYn;
    }
}
