<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RfTitle
 *
 * @ORM\Table(name="rf_title", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rf_title_trf_yn", columns={"rf_title_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RfTitle
{
    /**
     * @var string
     *
     * @ORM\Column(name="rf_title_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rfTitleIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_title_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rfTitleDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rf_title_id", type="integer", nullable=false)
     */
    private $rfTitleId;

    /**
     * @var string
     *
     * @ORM\Column(name="rf_title_desc", type="string", length=10, nullable=true)
     */
    private $rfTitleDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_title_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfTitleInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rf_title_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rfTitleTrfYn;



    /**
     * Get rfTitleIx
     *
     * @return string
     */
    public function getRfTitleIx()
    {
        return $this->rfTitleIx;
    }

    /**
     * Set rfTitleDb
     *
     * @param string $rfTitleDb
     *
     * @return RfTitle
     */
    public function setRfTitleDb($rfTitleDb)
    {
        $this->rfTitleDb = $rfTitleDb;

        return $this;
    }

    /**
     * Get rfTitleDb
     *
     * @return string
     */
    public function getRfTitleDb()
    {
        return $this->rfTitleDb;
    }

    /**
     * Set rfTitleId
     *
     * @param integer $rfTitleId
     *
     * @return RfTitle
     */
    public function setRfTitleId($rfTitleId)
    {
        $this->rfTitleId = $rfTitleId;

        return $this;
    }

    /**
     * Get rfTitleId
     *
     * @return integer
     */
    public function getRfTitleId()
    {
        return $this->rfTitleId;
    }

    /**
     * Set rfTitleDesc
     *
     * @param string $rfTitleDesc
     *
     * @return RfTitle
     */
    public function setRfTitleDesc($rfTitleDesc)
    {
        $this->rfTitleDesc = $rfTitleDesc;

        return $this;
    }

    /**
     * Get rfTitleDesc
     *
     * @return string
     */
    public function getRfTitleDesc()
    {
        return $this->rfTitleDesc;
    }

    /**
     * Set rfTitleInactiveYn
     *
     * @param boolean $rfTitleInactiveYn
     *
     * @return RfTitle
     */
    public function setRfTitleInactiveYn($rfTitleInactiveYn)
    {
        $this->rfTitleInactiveYn = $rfTitleInactiveYn;

        return $this;
    }

    /**
     * Get rfTitleInactiveYn
     *
     * @return boolean
     */
    public function getRfTitleInactiveYn()
    {
        return $this->rfTitleInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RfTitle
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rfTitleTrfYn
     *
     * @param boolean $rfTitleTrfYn
     *
     * @return RfTitle
     */
    public function setRfTitleTrfYn($rfTitleTrfYn)
    {
        $this->rfTitleTrfYn = $rfTitleTrfYn;

        return $this;
    }

    /**
     * Get rfTitleTrfYn
     *
     * @return boolean
     */
    public function getRfTitleTrfYn()
    {
        return $this->rfTitleTrfYn;
    }
}
