<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtComponent
 *
 * @ORM\Table(name="rt_component", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_component_trf_yn", columns={"rt_component_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RtComponent
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtComponentIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtComponentDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_component_id", type="integer", nullable=false)
     */
    private $rtComponentId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_abbrv", type="string", length=5, nullable=true)
     */
    private $rtComponentAbbrv;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_desc", type="string", length=50, nullable=true)
     */
    private $rtComponentDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_freq_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtComponentFreqInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_room_attr_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtComponentRoomAttrYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_separate_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtComponentSeparateYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_separate_proforma_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtComponentSeparateProformaInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_sys_code", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtComponentSysCode;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_opt_yn", type="boolean", nullable=true)
     */
    private $rtComponentOptYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_def_yn", type="boolean", nullable=true)
     */
    private $rtComponentDefYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_comm", type="boolean", nullable=true)
     */
    private $rtComponentComm;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_freq", type="boolean", nullable=true)
     */
    private $rtComponentFreq;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_component_freqfact", type="integer", nullable=true)
     */
    private $rtComponentFreqfact;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_taxrate", type="string", length=36, nullable=true)
     */
    private $rtComponentTaxrate;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_taxgroup", type="string", length=36, nullable=true)
     */
    private $rtComponentTaxgroup;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtComponentInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtComponentTrfYn;



    /**
     * Get rtComponentIx
     *
     * @return string
     */
    public function getRtComponentIx()
    {
        return $this->rtComponentIx;
    }

    /**
     * Set rtComponentDb
     *
     * @param string $rtComponentDb
     *
     * @return RtComponent
     */
    public function setRtComponentDb($rtComponentDb)
    {
        $this->rtComponentDb = $rtComponentDb;

        return $this;
    }

    /**
     * Get rtComponentDb
     *
     * @return string
     */
    public function getRtComponentDb()
    {
        return $this->rtComponentDb;
    }

    /**
     * Set rtComponentId
     *
     * @param integer $rtComponentId
     *
     * @return RtComponent
     */
    public function setRtComponentId($rtComponentId)
    {
        $this->rtComponentId = $rtComponentId;

        return $this;
    }

    /**
     * Get rtComponentId
     *
     * @return integer
     */
    public function getRtComponentId()
    {
        return $this->rtComponentId;
    }

    /**
     * Set rtComponentAbbrv
     *
     * @param string $rtComponentAbbrv
     *
     * @return RtComponent
     */
    public function setRtComponentAbbrv($rtComponentAbbrv)
    {
        $this->rtComponentAbbrv = $rtComponentAbbrv;

        return $this;
    }

    /**
     * Get rtComponentAbbrv
     *
     * @return string
     */
    public function getRtComponentAbbrv()
    {
        return $this->rtComponentAbbrv;
    }

    /**
     * Set rtComponentDesc
     *
     * @param string $rtComponentDesc
     *
     * @return RtComponent
     */
    public function setRtComponentDesc($rtComponentDesc)
    {
        $this->rtComponentDesc = $rtComponentDesc;

        return $this;
    }

    /**
     * Get rtComponentDesc
     *
     * @return string
     */
    public function getRtComponentDesc()
    {
        return $this->rtComponentDesc;
    }

    /**
     * Set rtComponentFreqInd
     *
     * @param boolean $rtComponentFreqInd
     *
     * @return RtComponent
     */
    public function setRtComponentFreqInd($rtComponentFreqInd)
    {
        $this->rtComponentFreqInd = $rtComponentFreqInd;

        return $this;
    }

    /**
     * Get rtComponentFreqInd
     *
     * @return boolean
     */
    public function getRtComponentFreqInd()
    {
        return $this->rtComponentFreqInd;
    }

    /**
     * Set rtComponentRoomAttrYn
     *
     * @param boolean $rtComponentRoomAttrYn
     *
     * @return RtComponent
     */
    public function setRtComponentRoomAttrYn($rtComponentRoomAttrYn)
    {
        $this->rtComponentRoomAttrYn = $rtComponentRoomAttrYn;

        return $this;
    }

    /**
     * Get rtComponentRoomAttrYn
     *
     * @return boolean
     */
    public function getRtComponentRoomAttrYn()
    {
        return $this->rtComponentRoomAttrYn;
    }

    /**
     * Set rtComponentSeparateYn
     *
     * @param boolean $rtComponentSeparateYn
     *
     * @return RtComponent
     */
    public function setRtComponentSeparateYn($rtComponentSeparateYn)
    {
        $this->rtComponentSeparateYn = $rtComponentSeparateYn;

        return $this;
    }

    /**
     * Get rtComponentSeparateYn
     *
     * @return boolean
     */
    public function getRtComponentSeparateYn()
    {
        return $this->rtComponentSeparateYn;
    }

    /**
     * Set rtComponentSeparateProformaInd
     *
     * @param boolean $rtComponentSeparateProformaInd
     *
     * @return RtComponent
     */
    public function setRtComponentSeparateProformaInd($rtComponentSeparateProformaInd)
    {
        $this->rtComponentSeparateProformaInd = $rtComponentSeparateProformaInd;

        return $this;
    }

    /**
     * Get rtComponentSeparateProformaInd
     *
     * @return boolean
     */
    public function getRtComponentSeparateProformaInd()
    {
        return $this->rtComponentSeparateProformaInd;
    }

    /**
     * Set rtComponentSysCode
     *
     * @param boolean $rtComponentSysCode
     *
     * @return RtComponent
     */
    public function setRtComponentSysCode($rtComponentSysCode)
    {
        $this->rtComponentSysCode = $rtComponentSysCode;

        return $this;
    }

    /**
     * Get rtComponentSysCode
     *
     * @return boolean
     */
    public function getRtComponentSysCode()
    {
        return $this->rtComponentSysCode;
    }

    /**
     * Set rtComponentOptYn
     *
     * @param boolean $rtComponentOptYn
     *
     * @return RtComponent
     */
    public function setRtComponentOptYn($rtComponentOptYn)
    {
        $this->rtComponentOptYn = $rtComponentOptYn;

        return $this;
    }

    /**
     * Get rtComponentOptYn
     *
     * @return boolean
     */
    public function getRtComponentOptYn()
    {
        return $this->rtComponentOptYn;
    }

    /**
     * Set rtComponentDefYn
     *
     * @param boolean $rtComponentDefYn
     *
     * @return RtComponent
     */
    public function setRtComponentDefYn($rtComponentDefYn)
    {
        $this->rtComponentDefYn = $rtComponentDefYn;

        return $this;
    }

    /**
     * Get rtComponentDefYn
     *
     * @return boolean
     */
    public function getRtComponentDefYn()
    {
        return $this->rtComponentDefYn;
    }

    /**
     * Set rtComponentComm
     *
     * @param boolean $rtComponentComm
     *
     * @return RtComponent
     */
    public function setRtComponentComm($rtComponentComm)
    {
        $this->rtComponentComm = $rtComponentComm;

        return $this;
    }

    /**
     * Get rtComponentComm
     *
     * @return boolean
     */
    public function getRtComponentComm()
    {
        return $this->rtComponentComm;
    }

    /**
     * Set rtComponentFreq
     *
     * @param boolean $rtComponentFreq
     *
     * @return RtComponent
     */
    public function setRtComponentFreq($rtComponentFreq)
    {
        $this->rtComponentFreq = $rtComponentFreq;

        return $this;
    }

    /**
     * Get rtComponentFreq
     *
     * @return boolean
     */
    public function getRtComponentFreq()
    {
        return $this->rtComponentFreq;
    }

    /**
     * Set rtComponentFreqfact
     *
     * @param integer $rtComponentFreqfact
     *
     * @return RtComponent
     */
    public function setRtComponentFreqfact($rtComponentFreqfact)
    {
        $this->rtComponentFreqfact = $rtComponentFreqfact;

        return $this;
    }

    /**
     * Get rtComponentFreqfact
     *
     * @return integer
     */
    public function getRtComponentFreqfact()
    {
        return $this->rtComponentFreqfact;
    }

    /**
     * Set rtComponentTaxrate
     *
     * @param string $rtComponentTaxrate
     *
     * @return RtComponent
     */
    public function setRtComponentTaxrate($rtComponentTaxrate)
    {
        $this->rtComponentTaxrate = $rtComponentTaxrate;

        return $this;
    }

    /**
     * Get rtComponentTaxrate
     *
     * @return string
     */
    public function getRtComponentTaxrate()
    {
        return $this->rtComponentTaxrate;
    }

    /**
     * Set rtComponentTaxgroup
     *
     * @param string $rtComponentTaxgroup
     *
     * @return RtComponent
     */
    public function setRtComponentTaxgroup($rtComponentTaxgroup)
    {
        $this->rtComponentTaxgroup = $rtComponentTaxgroup;

        return $this;
    }

    /**
     * Get rtComponentTaxgroup
     *
     * @return string
     */
    public function getRtComponentTaxgroup()
    {
        return $this->rtComponentTaxgroup;
    }

    /**
     * Set rtComponentInactiveYn
     *
     * @param boolean $rtComponentInactiveYn
     *
     * @return RtComponent
     */
    public function setRtComponentInactiveYn($rtComponentInactiveYn)
    {
        $this->rtComponentInactiveYn = $rtComponentInactiveYn;

        return $this;
    }

    /**
     * Get rtComponentInactiveYn
     *
     * @return boolean
     */
    public function getRtComponentInactiveYn()
    {
        return $this->rtComponentInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtComponent
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtComponentTrfYn
     *
     * @param boolean $rtComponentTrfYn
     *
     * @return RtComponent
     */
    public function setRtComponentTrfYn($rtComponentTrfYn)
    {
        $this->rtComponentTrfYn = $rtComponentTrfYn;

        return $this;
    }

    /**
     * Get rtComponentTrfYn
     *
     * @return boolean
     */
    public function getRtComponentTrfYn()
    {
        return $this->rtComponentTrfYn;
    }
}
