<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtComponentInv
 *
 * @ORM\Table(name="rt_component_inv", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_component_inv_trf_yn", columns={"rt_component_inv_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RtComponentInv
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_inv_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtComponentInvIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_inv_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtComponentInvDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_component_inv_id", type="integer", nullable=false)
     */
    private $rtComponentInvId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_id", type="string", length=36, nullable=true)
     */
    private $rtComponentId;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_cost_centre_2_id", type="string", length=36, nullable=true)
     */
    private $fnCostCentre2Id;

    /**
     * @var string
     *
     * @ORM\Column(name="fn_ledger_id", type="string", length=36, nullable=true)
     */
    private $fnLedgerId;

    /**
     * @var string
     *
     * @ORM\Column(name="pr_business_id", type="string", length=36, nullable=true)
     */
    private $prBusinessId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_inv_inactive_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtComponentInvInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_component_inv_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtComponentInvTrfYn;



    /**
     * Get rtComponentInvIx
     *
     * @return string
     */
    public function getRtComponentInvIx()
    {
        return $this->rtComponentInvIx;
    }

    /**
     * Set rtComponentInvDb
     *
     * @param string $rtComponentInvDb
     *
     * @return RtComponentInv
     */
    public function setRtComponentInvDb($rtComponentInvDb)
    {
        $this->rtComponentInvDb = $rtComponentInvDb;

        return $this;
    }

    /**
     * Get rtComponentInvDb
     *
     * @return string
     */
    public function getRtComponentInvDb()
    {
        return $this->rtComponentInvDb;
    }

    /**
     * Set rtComponentInvId
     *
     * @param integer $rtComponentInvId
     *
     * @return RtComponentInv
     */
    public function setRtComponentInvId($rtComponentInvId)
    {
        $this->rtComponentInvId = $rtComponentInvId;

        return $this;
    }

    /**
     * Get rtComponentInvId
     *
     * @return integer
     */
    public function getRtComponentInvId()
    {
        return $this->rtComponentInvId;
    }

    /**
     * Set rtComponentId
     *
     * @param string $rtComponentId
     *
     * @return RtComponentInv
     */
    public function setRtComponentId($rtComponentId)
    {
        $this->rtComponentId = $rtComponentId;

        return $this;
    }

    /**
     * Get rtComponentId
     *
     * @return string
     */
    public function getRtComponentId()
    {
        return $this->rtComponentId;
    }

    /**
     * Set fnCostCentre2Id
     *
     * @param string $fnCostCentre2Id
     *
     * @return RtComponentInv
     */
    public function setFnCostCentre2Id($fnCostCentre2Id)
    {
        $this->fnCostCentre2Id = $fnCostCentre2Id;

        return $this;
    }

    /**
     * Get fnCostCentre2Id
     *
     * @return string
     */
    public function getFnCostCentre2Id()
    {
        return $this->fnCostCentre2Id;
    }

    /**
     * Set fnLedgerId
     *
     * @param string $fnLedgerId
     *
     * @return RtComponentInv
     */
    public function setFnLedgerId($fnLedgerId)
    {
        $this->fnLedgerId = $fnLedgerId;

        return $this;
    }

    /**
     * Get fnLedgerId
     *
     * @return string
     */
    public function getFnLedgerId()
    {
        return $this->fnLedgerId;
    }

    /**
     * Set prBusinessId
     *
     * @param string $prBusinessId
     *
     * @return RtComponentInv
     */
    public function setPrBusinessId($prBusinessId)
    {
        $this->prBusinessId = $prBusinessId;

        return $this;
    }

    /**
     * Get prBusinessId
     *
     * @return string
     */
    public function getPrBusinessId()
    {
        return $this->prBusinessId;
    }

    /**
     * Set rtComponentInvInactiveYn
     *
     * @param boolean $rtComponentInvInactiveYn
     *
     * @return RtComponentInv
     */
    public function setRtComponentInvInactiveYn($rtComponentInvInactiveYn)
    {
        $this->rtComponentInvInactiveYn = $rtComponentInvInactiveYn;

        return $this;
    }

    /**
     * Get rtComponentInvInactiveYn
     *
     * @return boolean
     */
    public function getRtComponentInvInactiveYn()
    {
        return $this->rtComponentInvInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtComponentInv
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtComponentInvTrfYn
     *
     * @param boolean $rtComponentInvTrfYn
     *
     * @return RtComponentInv
     */
    public function setRtComponentInvTrfYn($rtComponentInvTrfYn)
    {
        $this->rtComponentInvTrfYn = $rtComponentInvTrfYn;

        return $this;
    }

    /**
     * Get rtComponentInvTrfYn
     *
     * @return boolean
     */
    public function getRtComponentInvTrfYn()
    {
        return $this->rtComponentInvTrfYn;
    }
}
