<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtPeriod
 *
 * @ORM\Table(name="rt_period", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_period_trf_yn", columns={"rt_period_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"})})
 * @ORM\Entity
 */
class RtPeriod
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_period_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtPeriodIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_period_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtPeriodDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_period_id", type="integer", nullable=false)
     */
    private $rtPeriodId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_period_abbrv", type="string", length=5, nullable=true)
     */
    private $rtPeriodAbbrv;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_period_colour", type="string", length=6, nullable=true)
     */
    private $rtPeriodColour;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rt_period_date_from", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rtPeriodDateFrom;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rt_period_date_to", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rtPeriodDateTo;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_period_desc", type="string", length=255, nullable=true)
     */
    private $rtPeriodDesc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_period_inactive_yn", type="boolean", nullable=true)
     */
    private $rtPeriodInactiveYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_period_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtPeriodTrfYn;



    /**
     * Get rtPeriodIx
     *
     * @return string
     */
    public function getRtPeriodIx()
    {
        return $this->rtPeriodIx;
    }

    /**
     * Set rtPeriodDb
     *
     * @param string $rtPeriodDb
     *
     * @return RtPeriod
     */
    public function setRtPeriodDb($rtPeriodDb)
    {
        $this->rtPeriodDb = $rtPeriodDb;

        return $this;
    }

    /**
     * Get rtPeriodDb
     *
     * @return string
     */
    public function getRtPeriodDb()
    {
        return $this->rtPeriodDb;
    }

    /**
     * Set rtPeriodId
     *
     * @param integer $rtPeriodId
     *
     * @return RtPeriod
     */
    public function setRtPeriodId($rtPeriodId)
    {
        $this->rtPeriodId = $rtPeriodId;

        return $this;
    }

    /**
     * Get rtPeriodId
     *
     * @return integer
     */
    public function getRtPeriodId()
    {
        return $this->rtPeriodId;
    }

    /**
     * Set rtPeriodAbbrv
     *
     * @param string $rtPeriodAbbrv
     *
     * @return RtPeriod
     */
    public function setRtPeriodAbbrv($rtPeriodAbbrv)
    {
        $this->rtPeriodAbbrv = $rtPeriodAbbrv;

        return $this;
    }

    /**
     * Get rtPeriodAbbrv
     *
     * @return string
     */
    public function getRtPeriodAbbrv()
    {
        return $this->rtPeriodAbbrv;
    }

    /**
     * Set rtPeriodColour
     *
     * @param string $rtPeriodColour
     *
     * @return RtPeriod
     */
    public function setRtPeriodColour($rtPeriodColour)
    {
        $this->rtPeriodColour = $rtPeriodColour;

        return $this;
    }

    /**
     * Get rtPeriodColour
     *
     * @return string
     */
    public function getRtPeriodColour()
    {
        return $this->rtPeriodColour;
    }

    /**
     * Set rtPeriodDateFrom
     *
     * @param \DateTime $rtPeriodDateFrom
     *
     * @return RtPeriod
     */
    public function setRtPeriodDateFrom($rtPeriodDateFrom)
    {
        $this->rtPeriodDateFrom = $rtPeriodDateFrom;

        return $this;
    }

    /**
     * Get rtPeriodDateFrom
     *
     * @return \DateTime
     */
    public function getRtPeriodDateFrom()
    {
        return $this->rtPeriodDateFrom;
    }

    /**
     * Set rtPeriodDateTo
     *
     * @param \DateTime $rtPeriodDateTo
     *
     * @return RtPeriod
     */
    public function setRtPeriodDateTo($rtPeriodDateTo)
    {
        $this->rtPeriodDateTo = $rtPeriodDateTo;

        return $this;
    }

    /**
     * Get rtPeriodDateTo
     *
     * @return \DateTime
     */
    public function getRtPeriodDateTo()
    {
        return $this->rtPeriodDateTo;
    }

    /**
     * Set rtPeriodDesc
     *
     * @param string $rtPeriodDesc
     *
     * @return RtPeriod
     */
    public function setRtPeriodDesc($rtPeriodDesc)
    {
        $this->rtPeriodDesc = $rtPeriodDesc;

        return $this;
    }

    /**
     * Get rtPeriodDesc
     *
     * @return string
     */
    public function getRtPeriodDesc()
    {
        return $this->rtPeriodDesc;
    }

    /**
     * Set rtPeriodInactiveYn
     *
     * @param boolean $rtPeriodInactiveYn
     *
     * @return RtPeriod
     */
    public function setRtPeriodInactiveYn($rtPeriodInactiveYn)
    {
        $this->rtPeriodInactiveYn = $rtPeriodInactiveYn;

        return $this;
    }

    /**
     * Get rtPeriodInactiveYn
     *
     * @return boolean
     */
    public function getRtPeriodInactiveYn()
    {
        return $this->rtPeriodInactiveYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtPeriod
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtPeriodTrfYn
     *
     * @param boolean $rtPeriodTrfYn
     *
     * @return RtPeriod
     */
    public function setRtPeriodTrfYn($rtPeriodTrfYn)
    {
        $this->rtPeriodTrfYn = $rtPeriodTrfYn;

        return $this;
    }

    /**
     * Get rtPeriodTrfYn
     *
     * @return boolean
     */
    public function getRtPeriodTrfYn()
    {
        return $this->rtPeriodTrfYn;
    }
}
