<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtPeriodDates
 *
 * @ORM\Table(name="rt_period_dates", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_period_dates_trf_yn", columns={"rt_period_dates_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rt_period_id", columns={"rt_period_id"})})
 * @ORM\Entity
 */
class RtPeriodDates
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_period_dates_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtPeriodDatesIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_period_dates_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtPeriodDatesDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_period_dates_id", type="integer", nullable=false)
     */
    private $rtPeriodDatesId;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rt_period_from", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rtPeriodFrom;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="rt_period_to", type="date", nullable=false, options={"default"="0000-00-00"})
     */
    private $rtPeriodTo;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_period_id", type="string", length=36, nullable=true)
     */
    private $rtPeriodId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_period_dates_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtPeriodDatesTrfYn;



    /**
     * Get rtPeriodDatesIx
     *
     * @return string
     */
    public function getRtPeriodDatesIx()
    {
        return $this->rtPeriodDatesIx;
    }

    /**
     * Set rtPeriodDatesDb
     *
     * @param string $rtPeriodDatesDb
     *
     * @return RtPeriodDates
     */
    public function setRtPeriodDatesDb($rtPeriodDatesDb)
    {
        $this->rtPeriodDatesDb = $rtPeriodDatesDb;

        return $this;
    }

    /**
     * Get rtPeriodDatesDb
     *
     * @return string
     */
    public function getRtPeriodDatesDb()
    {
        return $this->rtPeriodDatesDb;
    }

    /**
     * Set rtPeriodDatesId
     *
     * @param integer $rtPeriodDatesId
     *
     * @return RtPeriodDates
     */
    public function setRtPeriodDatesId($rtPeriodDatesId)
    {
        $this->rtPeriodDatesId = $rtPeriodDatesId;

        return $this;
    }

    /**
     * Get rtPeriodDatesId
     *
     * @return integer
     */
    public function getRtPeriodDatesId()
    {
        return $this->rtPeriodDatesId;
    }

    /**
     * Set rtPeriodFrom
     *
     * @param \DateTime $rtPeriodFrom
     *
     * @return RtPeriodDates
     */
    public function setRtPeriodFrom($rtPeriodFrom)
    {
        $this->rtPeriodFrom = $rtPeriodFrom;

        return $this;
    }

    /**
     * Get rtPeriodFrom
     *
     * @return \DateTime
     */
    public function getRtPeriodFrom()
    {
        return $this->rtPeriodFrom;
    }

    /**
     * Set rtPeriodTo
     *
     * @param \DateTime $rtPeriodTo
     *
     * @return RtPeriodDates
     */
    public function setRtPeriodTo($rtPeriodTo)
    {
        $this->rtPeriodTo = $rtPeriodTo;

        return $this;
    }

    /**
     * Get rtPeriodTo
     *
     * @return \DateTime
     */
    public function getRtPeriodTo()
    {
        return $this->rtPeriodTo;
    }

    /**
     * Set rtPeriodId
     *
     * @param string $rtPeriodId
     *
     * @return RtPeriodDates
     */
    public function setRtPeriodId($rtPeriodId)
    {
        $this->rtPeriodId = $rtPeriodId;

        return $this;
    }

    /**
     * Get rtPeriodId
     *
     * @return string
     */
    public function getRtPeriodId()
    {
        return $this->rtPeriodId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtPeriodDates
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtPeriodDatesTrfYn
     *
     * @param boolean $rtPeriodDatesTrfYn
     *
     * @return RtPeriodDates
     */
    public function setRtPeriodDatesTrfYn($rtPeriodDatesTrfYn)
    {
        $this->rtPeriodDatesTrfYn = $rtPeriodDatesTrfYn;

        return $this;
    }

    /**
     * Get rtPeriodDatesTrfYn
     *
     * @return boolean
     */
    public function getRtPeriodDatesTrfYn()
    {
        return $this->rtPeriodDatesTrfYn;
    }
}
