<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtRate
 *
 * @ORM\Table(name="rt_rate", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_rate_trf_yn", columns={"rt_rate_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="ac_accomm_type_id", columns={"ac_accomm_type_id"}), @ORM\Index(name="rt_period_id", columns={"rt_period_id"}), @ORM\Index(name="rt_rate_type_id", columns={"rt_rate_type_id"})})
 * @ORM\Entity
 */
class RtRate
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtRateIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtRateDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_rate_id", type="integer", nullable=false)
     */
    private $rtRateId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_template_desc", type="string", length=50, nullable=true)
     */
    private $rtRateTemplateDesc;

    /**
     * @var string
     *
     * @ORM\Column(name="ac_accomm_type_id", type="string", length=36, nullable=true)
     */
    private $acAccommTypeId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_comp_template_attr_id", type="string", length=36, nullable=true)
     */
    private $rtCompTemplateAttrId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_period_id", type="string", length=36, nullable=true)
     */
    private $rtPeriodId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_type_id", type="string", length=36, nullable=true)
     */
    private $rtRateTypeId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_dist_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateDistYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_comm_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rtRateCommYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_overide_level_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateOverideLevelInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_oride_comm_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateOrideCommYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_ssupp_comm_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rtRateSsuppCommYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_round_dir", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateRoundDir;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_round_scale", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateRoundScale;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_waive_checks_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateWaiveChecksYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_pax_rate_group_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtPaxRateGroupYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_status_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateStatusInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_tba_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateTbaYn;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateTrfYn;



    /**
     * Get rtRateIx
     *
     * @return string
     */
    public function getRtRateIx()
    {
        return $this->rtRateIx;
    }

    /**
     * Set rtRateDb
     *
     * @param string $rtRateDb
     *
     * @return RtRate
     */
    public function setRtRateDb($rtRateDb)
    {
        $this->rtRateDb = $rtRateDb;

        return $this;
    }

    /**
     * Get rtRateDb
     *
     * @return string
     */
    public function getRtRateDb()
    {
        return $this->rtRateDb;
    }

    /**
     * Set rtRateId
     *
     * @param integer $rtRateId
     *
     * @return RtRate
     */
    public function setRtRateId($rtRateId)
    {
        $this->rtRateId = $rtRateId;

        return $this;
    }

    /**
     * Get rtRateId
     *
     * @return integer
     */
    public function getRtRateId()
    {
        return $this->rtRateId;
    }

    /**
     * Set rtRateTemplateDesc
     *
     * @param string $rtRateTemplateDesc
     *
     * @return RtRate
     */
    public function setRtRateTemplateDesc($rtRateTemplateDesc)
    {
        $this->rtRateTemplateDesc = $rtRateTemplateDesc;

        return $this;
    }

    /**
     * Get rtRateTemplateDesc
     *
     * @return string
     */
    public function getRtRateTemplateDesc()
    {
        return $this->rtRateTemplateDesc;
    }

    /**
     * Set acAccommTypeId
     *
     * @param string $acAccommTypeId
     *
     * @return RtRate
     */
    public function setAcAccommTypeId($acAccommTypeId)
    {
        $this->acAccommTypeId = $acAccommTypeId;

        return $this;
    }

    /**
     * Get acAccommTypeId
     *
     * @return string
     */
    public function getAcAccommTypeId()
    {
        return $this->acAccommTypeId;
    }

    /**
     * Set rtCompTemplateAttrId
     *
     * @param string $rtCompTemplateAttrId
     *
     * @return RtRate
     */
    public function setRtCompTemplateAttrId($rtCompTemplateAttrId)
    {
        $this->rtCompTemplateAttrId = $rtCompTemplateAttrId;

        return $this;
    }

    /**
     * Get rtCompTemplateAttrId
     *
     * @return string
     */
    public function getRtCompTemplateAttrId()
    {
        return $this->rtCompTemplateAttrId;
    }

    /**
     * Set rtPeriodId
     *
     * @param string $rtPeriodId
     *
     * @return RtRate
     */
    public function setRtPeriodId($rtPeriodId)
    {
        $this->rtPeriodId = $rtPeriodId;

        return $this;
    }

    /**
     * Get rtPeriodId
     *
     * @return string
     */
    public function getRtPeriodId()
    {
        return $this->rtPeriodId;
    }

    /**
     * Set rtRateTypeId
     *
     * @param string $rtRateTypeId
     *
     * @return RtRate
     */
    public function setRtRateTypeId($rtRateTypeId)
    {
        $this->rtRateTypeId = $rtRateTypeId;

        return $this;
    }

    /**
     * Get rtRateTypeId
     *
     * @return string
     */
    public function getRtRateTypeId()
    {
        return $this->rtRateTypeId;
    }

    /**
     * Set rtRateDistYn
     *
     * @param boolean $rtRateDistYn
     *
     * @return RtRate
     */
    public function setRtRateDistYn($rtRateDistYn)
    {
        $this->rtRateDistYn = $rtRateDistYn;

        return $this;
    }

    /**
     * Get rtRateDistYn
     *
     * @return boolean
     */
    public function getRtRateDistYn()
    {
        return $this->rtRateDistYn;
    }

    /**
     * Set rtRateCommYn
     *
     * @param boolean $rtRateCommYn
     *
     * @return RtRate
     */
    public function setRtRateCommYn($rtRateCommYn)
    {
        $this->rtRateCommYn = $rtRateCommYn;

        return $this;
    }

    /**
     * Get rtRateCommYn
     *
     * @return boolean
     */
    public function getRtRateCommYn()
    {
        return $this->rtRateCommYn;
    }

    /**
     * Set rtRateOverideLevelInd
     *
     * @param boolean $rtRateOverideLevelInd
     *
     * @return RtRate
     */
    public function setRtRateOverideLevelInd($rtRateOverideLevelInd)
    {
        $this->rtRateOverideLevelInd = $rtRateOverideLevelInd;

        return $this;
    }

    /**
     * Get rtRateOverideLevelInd
     *
     * @return boolean
     */
    public function getRtRateOverideLevelInd()
    {
        return $this->rtRateOverideLevelInd;
    }

    /**
     * Set rtRateOrideCommYn
     *
     * @param boolean $rtRateOrideCommYn
     *
     * @return RtRate
     */
    public function setRtRateOrideCommYn($rtRateOrideCommYn)
    {
        $this->rtRateOrideCommYn = $rtRateOrideCommYn;

        return $this;
    }

    /**
     * Get rtRateOrideCommYn
     *
     * @return boolean
     */
    public function getRtRateOrideCommYn()
    {
        return $this->rtRateOrideCommYn;
    }

    /**
     * Set rtRateSsuppCommYn
     *
     * @param boolean $rtRateSsuppCommYn
     *
     * @return RtRate
     */
    public function setRtRateSsuppCommYn($rtRateSsuppCommYn)
    {
        $this->rtRateSsuppCommYn = $rtRateSsuppCommYn;

        return $this;
    }

    /**
     * Get rtRateSsuppCommYn
     *
     * @return boolean
     */
    public function getRtRateSsuppCommYn()
    {
        return $this->rtRateSsuppCommYn;
    }

    /**
     * Set rtRateRoundDir
     *
     * @param boolean $rtRateRoundDir
     *
     * @return RtRate
     */
    public function setRtRateRoundDir($rtRateRoundDir)
    {
        $this->rtRateRoundDir = $rtRateRoundDir;

        return $this;
    }

    /**
     * Get rtRateRoundDir
     *
     * @return boolean
     */
    public function getRtRateRoundDir()
    {
        return $this->rtRateRoundDir;
    }

    /**
     * Set rtRateRoundScale
     *
     * @param boolean $rtRateRoundScale
     *
     * @return RtRate
     */
    public function setRtRateRoundScale($rtRateRoundScale)
    {
        $this->rtRateRoundScale = $rtRateRoundScale;

        return $this;
    }

    /**
     * Get rtRateRoundScale
     *
     * @return boolean
     */
    public function getRtRateRoundScale()
    {
        return $this->rtRateRoundScale;
    }

    /**
     * Set rtRateWaiveChecksYn
     *
     * @param boolean $rtRateWaiveChecksYn
     *
     * @return RtRate
     */
    public function setRtRateWaiveChecksYn($rtRateWaiveChecksYn)
    {
        $this->rtRateWaiveChecksYn = $rtRateWaiveChecksYn;

        return $this;
    }

    /**
     * Get rtRateWaiveChecksYn
     *
     * @return boolean
     */
    public function getRtRateWaiveChecksYn()
    {
        return $this->rtRateWaiveChecksYn;
    }

    /**
     * Set rtPaxRateGroupYn
     *
     * @param boolean $rtPaxRateGroupYn
     *
     * @return RtRate
     */
    public function setRtPaxRateGroupYn($rtPaxRateGroupYn)
    {
        $this->rtPaxRateGroupYn = $rtPaxRateGroupYn;

        return $this;
    }

    /**
     * Get rtPaxRateGroupYn
     *
     * @return boolean
     */
    public function getRtPaxRateGroupYn()
    {
        return $this->rtPaxRateGroupYn;
    }

    /**
     * Set rtRateStatusInd
     *
     * @param boolean $rtRateStatusInd
     *
     * @return RtRate
     */
    public function setRtRateStatusInd($rtRateStatusInd)
    {
        $this->rtRateStatusInd = $rtRateStatusInd;

        return $this;
    }

    /**
     * Get rtRateStatusInd
     *
     * @return boolean
     */
    public function getRtRateStatusInd()
    {
        return $this->rtRateStatusInd;
    }

    /**
     * Set rtRateTbaYn
     *
     * @param boolean $rtRateTbaYn
     *
     * @return RtRate
     */
    public function setRtRateTbaYn($rtRateTbaYn)
    {
        $this->rtRateTbaYn = $rtRateTbaYn;

        return $this;
    }

    /**
     * Get rtRateTbaYn
     *
     * @return boolean
     */
    public function getRtRateTbaYn()
    {
        return $this->rtRateTbaYn;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtRate
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtRateTrfYn
     *
     * @param boolean $rtRateTrfYn
     *
     * @return RtRate
     */
    public function setRtRateTrfYn($rtRateTrfYn)
    {
        $this->rtRateTrfYn = $rtRateTrfYn;

        return $this;
    }

    /**
     * Get rtRateTrfYn
     *
     * @return boolean
     */
    public function getRtRateTrfYn()
    {
        return $this->rtRateTrfYn;
    }
}
