<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtRateCompGrp
 *
 * @ORM\Table(name="rt_rate_comp_grp", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_rate_comp_grp_trf_yn", columns={"rt_rate_comp_grp_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rt_rate_group_id", columns={"rt_rate_group_id"}), @ORM\Index(name="rt_rate_component_id", columns={"rt_rate_component_id"})})
 * @ORM\Entity
 */
class RtRateCompGrp
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_comp_grp_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtRateCompGrpIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_comp_grp_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtRateCompGrpDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_rate_comp_grp_id", type="integer", nullable=false)
     */
    private $rtRateCompGrpId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_comp_amt", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rtRateCompAmt;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_comp_perc", type="decimal", precision=16, scale=2, nullable=false, options={"default"="0.00"})
     */
    private $rtRateCompPerc;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_comp_val_ind", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rtRateCompValInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_comp_grp_comm_yn", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rtRateCompGrpCommYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_comp_grp_seq", type="boolean", nullable=false, options={"default"="4"})
     */
    private $rtRateCompGrpSeq;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_group_id", type="string", length=36, nullable=true)
     */
    private $rtRateGroupId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_component_id", type="string", length=36, nullable=true)
     */
    private $rtRateComponentId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_comp_grp_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateCompGrpTrfYn;



    /**
     * Get rtRateCompGrpIx
     *
     * @return string
     */
    public function getRtRateCompGrpIx()
    {
        return $this->rtRateCompGrpIx;
    }

    /**
     * Set rtRateCompGrpDb
     *
     * @param string $rtRateCompGrpDb
     *
     * @return RtRateCompGrp
     */
    public function setRtRateCompGrpDb($rtRateCompGrpDb)
    {
        $this->rtRateCompGrpDb = $rtRateCompGrpDb;

        return $this;
    }

    /**
     * Get rtRateCompGrpDb
     *
     * @return string
     */
    public function getRtRateCompGrpDb()
    {
        return $this->rtRateCompGrpDb;
    }

    /**
     * Set rtRateCompGrpId
     *
     * @param integer $rtRateCompGrpId
     *
     * @return RtRateCompGrp
     */
    public function setRtRateCompGrpId($rtRateCompGrpId)
    {
        $this->rtRateCompGrpId = $rtRateCompGrpId;

        return $this;
    }

    /**
     * Get rtRateCompGrpId
     *
     * @return integer
     */
    public function getRtRateCompGrpId()
    {
        return $this->rtRateCompGrpId;
    }

    /**
     * Set rtRateCompAmt
     *
     * @param string $rtRateCompAmt
     *
     * @return RtRateCompGrp
     */
    public function setRtRateCompAmt($rtRateCompAmt)
    {
        $this->rtRateCompAmt = $rtRateCompAmt;

        return $this;
    }

    /**
     * Get rtRateCompAmt
     *
     * @return string
     */
    public function getRtRateCompAmt()
    {
        return $this->rtRateCompAmt;
    }

    /**
     * Set rtRateCompPerc
     *
     * @param string $rtRateCompPerc
     *
     * @return RtRateCompGrp
     */
    public function setRtRateCompPerc($rtRateCompPerc)
    {
        $this->rtRateCompPerc = $rtRateCompPerc;

        return $this;
    }

    /**
     * Get rtRateCompPerc
     *
     * @return string
     */
    public function getRtRateCompPerc()
    {
        return $this->rtRateCompPerc;
    }

    /**
     * Set rtRateCompValInd
     *
     * @param boolean $rtRateCompValInd
     *
     * @return RtRateCompGrp
     */
    public function setRtRateCompValInd($rtRateCompValInd)
    {
        $this->rtRateCompValInd = $rtRateCompValInd;

        return $this;
    }

    /**
     * Get rtRateCompValInd
     *
     * @return boolean
     */
    public function getRtRateCompValInd()
    {
        return $this->rtRateCompValInd;
    }

    /**
     * Set rtRateCompGrpCommYn
     *
     * @param boolean $rtRateCompGrpCommYn
     *
     * @return RtRateCompGrp
     */
    public function setRtRateCompGrpCommYn($rtRateCompGrpCommYn)
    {
        $this->rtRateCompGrpCommYn = $rtRateCompGrpCommYn;

        return $this;
    }

    /**
     * Get rtRateCompGrpCommYn
     *
     * @return boolean
     */
    public function getRtRateCompGrpCommYn()
    {
        return $this->rtRateCompGrpCommYn;
    }

    /**
     * Set rtRateCompGrpSeq
     *
     * @param boolean $rtRateCompGrpSeq
     *
     * @return RtRateCompGrp
     */
    public function setRtRateCompGrpSeq($rtRateCompGrpSeq)
    {
        $this->rtRateCompGrpSeq = $rtRateCompGrpSeq;

        return $this;
    }

    /**
     * Get rtRateCompGrpSeq
     *
     * @return boolean
     */
    public function getRtRateCompGrpSeq()
    {
        return $this->rtRateCompGrpSeq;
    }

    /**
     * Set rtRateGroupId
     *
     * @param string $rtRateGroupId
     *
     * @return RtRateCompGrp
     */
    public function setRtRateGroupId($rtRateGroupId)
    {
        $this->rtRateGroupId = $rtRateGroupId;

        return $this;
    }

    /**
     * Get rtRateGroupId
     *
     * @return string
     */
    public function getRtRateGroupId()
    {
        return $this->rtRateGroupId;
    }

    /**
     * Set rtRateComponentId
     *
     * @param string $rtRateComponentId
     *
     * @return RtRateCompGrp
     */
    public function setRtRateComponentId($rtRateComponentId)
    {
        $this->rtRateComponentId = $rtRateComponentId;

        return $this;
    }

    /**
     * Get rtRateComponentId
     *
     * @return string
     */
    public function getRtRateComponentId()
    {
        return $this->rtRateComponentId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtRateCompGrp
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtRateCompGrpTrfYn
     *
     * @param boolean $rtRateCompGrpTrfYn
     *
     * @return RtRateCompGrp
     */
    public function setRtRateCompGrpTrfYn($rtRateCompGrpTrfYn)
    {
        $this->rtRateCompGrpTrfYn = $rtRateCompGrpTrfYn;

        return $this;
    }

    /**
     * Get rtRateCompGrpTrfYn
     *
     * @return boolean
     */
    public function getRtRateCompGrpTrfYn()
    {
        return $this->rtRateCompGrpTrfYn;
    }
}
