<?php

namespace Resrequest\DB\Enterprise\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * RtRateComponent
 *
 * @ORM\Table(name="rt_rate_component", options={"collate"="utf8mb4_unicode_ci", "charset"="utf8mb4"}, indexes={@ORM\Index(name="rt_rate_component_trf_yn", columns={"rt_rate_component_trf_yn"}), @ORM\Index(name="dt_temp_id", columns={"dt_temp_id"}), @ORM\Index(name="rt_component_id", columns={"rt_component_id"}), @ORM\Index(name="rt_rate_id", columns={"rt_rate_id"})})
 * @ORM\Entity
 */
class RtRateComponent
{
    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_component_ix", type="string", length=36, nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $rtRateComponentIx;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_component_db", type="string", length=2, nullable=false, options={"default"="", "fixed"="true"})
     */
    private $rtRateComponentDb;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_rate_component_id", type="integer", nullable=false)
     */
    private $rtRateComponentId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_comp_comm_yn", type="boolean", nullable=true)
     */
    private $rtCompCommYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_comp_freq_ind", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtCompFreqInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_comp_freq_factor", type="boolean", nullable=false, options={"default"="1"})
     */
    private $rtCompFreqFactor;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_comp_itin_yn", type="boolean", nullable=true)
     */
    private $rtCompItinYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_comp_los_yn", type="boolean", nullable=true)
     */
    private $rtCompLosYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_comp_opt_yn", type="boolean", nullable=true)
     */
    private $rtCompOptYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_comp_opt_def_yn", type="boolean", nullable=true)
     */
    private $rtCompOptDefYn;

    /**
     * @var integer
     *
     * @ORM\Column(name="rt_comp_round_ind", type="integer", nullable=false, options={"default"="0"})
     */
    private $rtCompRoundInd;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_comp_separate_yn", type="boolean", nullable=true)
     */
    private $rtCompSeparateYn;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_tax_ind", type="boolean", nullable=true)
     */
    private $rtTaxInd;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_tax_id", type="string", length=36, nullable=true)
     */
    private $rtTaxId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_component_id", type="string", length=36, nullable=true)
     */
    private $rtComponentId;

    /**
     * @var string
     *
     * @ORM\Column(name="rt_rate_id", type="string", length=36, nullable=true)
     */
    private $rtRateId;

    /**
     * @var string
     *
     * @ORM\Column(name="dt_temp_id", type="string", length=36, nullable=true)
     */
    private $dtTempId;

    /**
     * @var boolean
     *
     * @ORM\Column(name="rt_rate_component_trf_yn", type="boolean", nullable=false, options={"default"="0"})
     */
    private $rtRateComponentTrfYn;



    /**
     * Get rtRateComponentIx
     *
     * @return string
     */
    public function getRtRateComponentIx()
    {
        return $this->rtRateComponentIx;
    }

    /**
     * Set rtRateComponentDb
     *
     * @param string $rtRateComponentDb
     *
     * @return RtRateComponent
     */
    public function setRtRateComponentDb($rtRateComponentDb)
    {
        $this->rtRateComponentDb = $rtRateComponentDb;

        return $this;
    }

    /**
     * Get rtRateComponentDb
     *
     * @return string
     */
    public function getRtRateComponentDb()
    {
        return $this->rtRateComponentDb;
    }

    /**
     * Set rtRateComponentId
     *
     * @param integer $rtRateComponentId
     *
     * @return RtRateComponent
     */
    public function setRtRateComponentId($rtRateComponentId)
    {
        $this->rtRateComponentId = $rtRateComponentId;

        return $this;
    }

    /**
     * Get rtRateComponentId
     *
     * @return integer
     */
    public function getRtRateComponentId()
    {
        return $this->rtRateComponentId;
    }

    /**
     * Set rtCompCommYn
     *
     * @param boolean $rtCompCommYn
     *
     * @return RtRateComponent
     */
    public function setRtCompCommYn($rtCompCommYn)
    {
        $this->rtCompCommYn = $rtCompCommYn;

        return $this;
    }

    /**
     * Get rtCompCommYn
     *
     * @return boolean
     */
    public function getRtCompCommYn()
    {
        return $this->rtCompCommYn;
    }

    /**
     * Set rtCompFreqInd
     *
     * @param boolean $rtCompFreqInd
     *
     * @return RtRateComponent
     */
    public function setRtCompFreqInd($rtCompFreqInd)
    {
        $this->rtCompFreqInd = $rtCompFreqInd;

        return $this;
    }

    /**
     * Get rtCompFreqInd
     *
     * @return boolean
     */
    public function getRtCompFreqInd()
    {
        return $this->rtCompFreqInd;
    }

    /**
     * Set rtCompFreqFactor
     *
     * @param boolean $rtCompFreqFactor
     *
     * @return RtRateComponent
     */
    public function setRtCompFreqFactor($rtCompFreqFactor)
    {
        $this->rtCompFreqFactor = $rtCompFreqFactor;

        return $this;
    }

    /**
     * Get rtCompFreqFactor
     *
     * @return boolean
     */
    public function getRtCompFreqFactor()
    {
        return $this->rtCompFreqFactor;
    }

    /**
     * Set rtCompItinYn
     *
     * @param boolean $rtCompItinYn
     *
     * @return RtRateComponent
     */
    public function setRtCompItinYn($rtCompItinYn)
    {
        $this->rtCompItinYn = $rtCompItinYn;

        return $this;
    }

    /**
     * Get rtCompItinYn
     *
     * @return boolean
     */
    public function getRtCompItinYn()
    {
        return $this->rtCompItinYn;
    }

    /**
     * Set rtCompLosYn
     *
     * @param boolean $rtCompLosYn
     *
     * @return RtRateComponent
     */
    public function setRtCompLosYn($rtCompLosYn)
    {
        $this->rtCompLosYn = $rtCompLosYn;

        return $this;
    }

    /**
     * Get rtCompLosYn
     *
     * @return boolean
     */
    public function getRtCompLosYn()
    {
        return $this->rtCompLosYn;
    }

    /**
     * Set rtCompOptYn
     *
     * @param boolean $rtCompOptYn
     *
     * @return RtRateComponent
     */
    public function setRtCompOptYn($rtCompOptYn)
    {
        $this->rtCompOptYn = $rtCompOptYn;

        return $this;
    }

    /**
     * Get rtCompOptYn
     *
     * @return boolean
     */
    public function getRtCompOptYn()
    {
        return $this->rtCompOptYn;
    }

    /**
     * Set rtCompOptDefYn
     *
     * @param boolean $rtCompOptDefYn
     *
     * @return RtRateComponent
     */
    public function setRtCompOptDefYn($rtCompOptDefYn)
    {
        $this->rtCompOptDefYn = $rtCompOptDefYn;

        return $this;
    }

    /**
     * Get rtCompOptDefYn
     *
     * @return boolean
     */
    public function getRtCompOptDefYn()
    {
        return $this->rtCompOptDefYn;
    }

    /**
     * Set rtCompRoundInd
     *
     * @param integer $rtCompRoundInd
     *
     * @return RtRateComponent
     */
    public function setRtCompRoundInd($rtCompRoundInd)
    {
        $this->rtCompRoundInd = $rtCompRoundInd;

        return $this;
    }

    /**
     * Get rtCompRoundInd
     *
     * @return integer
     */
    public function getRtCompRoundInd()
    {
        return $this->rtCompRoundInd;
    }

    /**
     * Set rtCompSeparateYn
     *
     * @param boolean $rtCompSeparateYn
     *
     * @return RtRateComponent
     */
    public function setRtCompSeparateYn($rtCompSeparateYn)
    {
        $this->rtCompSeparateYn = $rtCompSeparateYn;

        return $this;
    }

    /**
     * Get rtCompSeparateYn
     *
     * @return boolean
     */
    public function getRtCompSeparateYn()
    {
        return $this->rtCompSeparateYn;
    }

    /**
     * Set rtTaxInd
     *
     * @param boolean $rtTaxInd
     *
     * @return RtRateComponent
     */
    public function setRtTaxInd($rtTaxInd)
    {
        $this->rtTaxInd = $rtTaxInd;

        return $this;
    }

    /**
     * Get rtTaxInd
     *
     * @return boolean
     */
    public function getRtTaxInd()
    {
        return $this->rtTaxInd;
    }

    /**
     * Set rtTaxId
     *
     * @param string $rtTaxId
     *
     * @return RtRateComponent
     */
    public function setRtTaxId($rtTaxId)
    {
        $this->rtTaxId = $rtTaxId;

        return $this;
    }

    /**
     * Get rtTaxId
     *
     * @return string
     */
    public function getRtTaxId()
    {
        return $this->rtTaxId;
    }

    /**
     * Set rtComponentId
     *
     * @param string $rtComponentId
     *
     * @return RtRateComponent
     */
    public function setRtComponentId($rtComponentId)
    {
        $this->rtComponentId = $rtComponentId;

        return $this;
    }

    /**
     * Get rtComponentId
     *
     * @return string
     */
    public function getRtComponentId()
    {
        return $this->rtComponentId;
    }

    /**
     * Set rtRateId
     *
     * @param string $rtRateId
     *
     * @return RtRateComponent
     */
    public function setRtRateId($rtRateId)
    {
        $this->rtRateId = $rtRateId;

        return $this;
    }

    /**
     * Get rtRateId
     *
     * @return string
     */
    public function getRtRateId()
    {
        return $this->rtRateId;
    }

    /**
     * Set dtTempId
     *
     * @param string $dtTempId
     *
     * @return RtRateComponent
     */
    public function setDtTempId($dtTempId)
    {
        $this->dtTempId = $dtTempId;

        return $this;
    }

    /**
     * Get dtTempId
     *
     * @return string
     */
    public function getDtTempId()
    {
        return $this->dtTempId;
    }

    /**
     * Set rtRateComponentTrfYn
     *
     * @param boolean $rtRateComponentTrfYn
     *
     * @return RtRateComponent
     */
    public function setRtRateComponentTrfYn($rtRateComponentTrfYn)
    {
        $this->rtRateComponentTrfYn = $rtRateComponentTrfYn;

        return $this;
    }

    /**
     * Get rtRateComponentTrfYn
     *
     * @return boolean
     */
    public function getRtRateComponentTrfYn()
    {
        return $this->rtRateComponentTrfYn;
    }
}
